/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.mimvista.dicom.DicomAssociateReject;
import com.mimvista.dicom.DicomDestination;
import com.mimvista.dicom.GenericTestJDialog;
import com.mimvista.dicom.network.DcmSnd;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.ay;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.dcm4che2.net.pdu.AAssociateRJ;

public class DicomTestJDialog
extends GenericTestJDialog {
    private static final long serialVersionUID = 1L;
    private JLabel echoStatus;
    private DicomDestination dicomDestination = null;

    public DicomTestJDialog(JDialog jDialog, DicomDestination dicomDestination) {
        super(jDialog, dicomDestination.getHostname());
        this.dicomDestination = dicomDestination;
    }

    @Override
    protected String getDialogTitle() {
        return props.getProperty("DCM_TEST_TITLE");
    }

    @Override
    protected Dimension getDialogSize() {
        return new Dimension(250, 118);
    }

    @Override
    protected JPanel attachAdditionalLabels(JPanel jPanel) {
        JLabel jLabel = new JLabel(props.getProperty("DCM_TEST_ECHO"));
        this.echoStatus = new JLabel("");
        jPanel.add(jLabel);
        jPanel.add(this.echoStatus);
        return jPanel;
    }

    @Override
    protected void test(boolean bl2) {
        try {
            SwingUtilities.invokeAndWait(() -> {
                if (bl2) {
                    this.defaultPingStatus.setText(props.getProperty("DCM_TEST_SUCCESS"));
                    this.defaultPingStatus.setForeground(Color.GREEN);
                } else {
                    this.defaultPingStatus.setText(props.getProperty("DCM_TEST_FAIL"));
                    this.defaultPingStatus.setForeground(Color.RED);
                }
                this.echoStatus.setText(props.getProperty("DCM_TEST_TESTING"));
            });
        }
        catch (Throwable throwable) {
            ay.d((Object)throwable, this);
        }
        Exception exception = null;
        try {
            new DcmSnd(this.dicomDestination.toURL()).test();
        }
        catch (Exception exception2) {
            exception = exception2;
            ay.e(exception2);
        }
        Exception exception3 = exception;
        if (!this.shouldRun) {
            return;
        }
        try {
            SwingUtilities.invokeAndWait(() -> {
                if (exception3 == null) {
                    this.echoStatus.setText(props.getProperty("DCM_TEST_SUCCESS"));
                    this.echoStatus.setForeground(Color.GREEN);
                } else {
                    this.echoStatus.setText(props.getProperty("DCM_TEST_FAIL"));
                    this.echoStatus.setForeground(Color.RED);
                }
                if (!bl2) {
                    String string = MIMFormat.a(props.getProperty("DCM_TEST_PING_ERROR"), this.dicomDestination.getHostname());
                    JOptionPane.showMessageDialog(this.thisDialog, string, props.getProperty("DCM_TEST_PING_ERROR_TITLE"), 0);
                } else if (exception3 != null) {
                    String string = null;
                    string = exception3 instanceof AAssociateRJ ? MIMFormat.a(props.getProperty("DCM_TEST_CONNECT_ERROR"), this.dicomDestination.getHostname(), new DicomAssociateReject((AAssociateRJ)exception3).getReason()) : MIMFormat.a(props.getProperty("DCM_TEST_IP_ERROR"), this.dicomDestination.getHostname());
                    JOptionPane.showMessageDialog(this.thisDialog, string, props.getProperty("DCM_TEST_CONNECT_ERROR_TITLE"), 0);
                }
            });
        }
        catch (Throwable throwable) {
            ay.d((Object)throwable, this);
        }
    }
}

