/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.osdep.GetOSPath;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.by;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public abstract class GenericTestJDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static Messages props = Messages.a("Dicom");
    protected boolean shouldRun = true;
    protected JLabel defaultPingLabel;
    protected JLabel defaultPingStatus;
    protected JPanel contentPane;
    protected JDialog thisDialog;
    protected Component parent;
    protected String hostname;

    public GenericTestJDialog(JDialog jDialog, String string) {
        super((Dialog)jDialog, true);
        this.setResizable(false);
        this.hostname = string;
        this.thisDialog = this;
        this.parent = jDialog;
    }

    public void open() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GenericTestJDialog.this.stopTests();
                GenericTestJDialog.this.dispose();
            }
        });
        this.initContentPane();
        this.runTests();
        this.setLocationRelativeTo(this.parent);
        this.setTitle(this.getDialogTitle());
        this.pack();
        this.setVisible(true);
    }

    private void initContentPane() {
        this.defaultPingStatus = new JLabel("", null, 2);
        JButton jButton = new JButton(props.getProperty("GENERIC_TEST_CLOSE"), (ImageIcon)ImageManipulator.c("x_red", 18));
        jButton.addActionListener(actionEvent -> {
            this.stopTests();
            this.dispose();
        });
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        BorderLayout borderLayout = new BorderLayout(5, 5);
        this.contentPane.setLayout(borderLayout);
        JPanel jPanel = new JPanel(new GridLayout(0, 2, 5, 5));
        this.defaultPingLabel = new JLabel(props.getProperty("GENERIC_TEST_PING"));
        jPanel.add(this.defaultPingLabel);
        jPanel.add(this.defaultPingStatus);
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.add(jButton);
        this.contentPane.add((Component)this.attachAdditionalLabels(jPanel), "Center");
        this.contentPane.add((Component)jPanel2, "South");
        this.setContentPane(this.contentPane);
    }

    protected abstract Dimension getDialogSize();

    protected abstract JPanel attachAdditionalLabels(JPanel var1);

    protected abstract String getDialogTitle();

    protected abstract void test(boolean var1);

    protected boolean testDefaultPing() {
        try {
            SwingUtilities.invokeAndWait(() -> this.defaultPingStatus.setText(props.getProperty("GENERIC_TEST_TESTING")));
        }
        catch (Throwable throwable) {
            ay.d((Object)throwable, this);
        }
        return GenericTestJDialog.testPing(this.hostname);
    }

    private void runTests() {
        new TestThread().start();
    }

    private void stopTests() {
        this.shouldRun = false;
    }

    public static boolean testPing(String string) {
        try {
            string = new URL(string).getHost();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        if (File.separator.equals("/")) {
            try {
                String string2 = "ping -c 1 -w 3 ";
                if (GetOSPath.isMacOs()) {
                    string2 = "/sbin/ping -c 1 -t 3 ";
                }
                process = runtime.exec(string2 + string);
            }
            catch (IOException iOException) {
                return false;
            }
        }
        try {
            process = runtime.exec("ping -n 1 -w 3000 " + string);
        }
        catch (IOException iOException) {
            ay.d((Object)iOException, GenericTestJDialog.class);
            return false;
        }
        try {
            by.a(process, "PING");
        }
        catch (InterruptedException interruptedException) {
            ay.d((Object)interruptedException, GenericTestJDialog.class);
            return false;
        }
        return process.exitValue() == 0;
    }

    private class TestThread
    extends Thread {
        private TestThread() {
        }

        @Override
        public void run() {
            boolean bl2 = GenericTestJDialog.this.testDefaultPing();
            if (!GenericTestJDialog.this.shouldRun) {
                return;
            }
            GenericTestJDialog.this.test(bl2);
        }
    }
}

