/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;

public class ImageOrientation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int[] orient;

    public ImageOrientation(Collection<? extends Number> collection) {
        Preconditions.checkNotNull(collection);
        Preconditions.checkArgument((collection.size() == 6 ? 1 : 0) != 0, (Object)("Invalid orientation, must have 6 elements, got: " + collection));
        this.orient = new int[6];
        int n2 = 0;
        for (Number number : collection) {
            this.orient[n2++] = Math.round(number.floatValue() * 100.0f);
        }
    }

    public ImageOrientation(String[] stringArray) throws NumberFormatException {
        float[] fArray = new float[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            fArray[i2] = Float.valueOf(stringArray[i2]).floatValue();
        }
        this.init(fArray);
    }

    public ImageOrientation(float[] fArray) {
        this.init(fArray);
    }

    private void init(float[] fArray) {
        this.orient = new int[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            this.orient[i2] = Math.round(fArray[i2] * 100.0f);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ImageOrientation) {
            ImageOrientation imageOrientation = (ImageOrientation)object;
            return Arrays.equals(this.orient, imageOrientation.orient);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.orient);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).addValue((Object)Arrays.toString(this.orient)).toString();
    }
}

