/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Floats;
import com.mimvista.numerics.MathUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;

public class IsocentricImageOrientation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private float gantryAngle;
    private float[] isocenter;

    public IsocentricImageOrientation(float f2, float[] fArray) {
        this.gantryAngle = f2;
        this.isocenter = fArray;
    }

    public IsocentricImageOrientation(Number number, Collection<? extends Number> collection) {
        Preconditions.checkNotNull((Object)number);
        Preconditions.checkNotNull(collection);
        Preconditions.checkArgument((Iterables.size(collection) == 3 ? 1 : 0) != 0, (Object)("Invalid isocenter, should have 3 floats but got: " + collection));
        this.gantryAngle = number.floatValue();
        this.isocenter = Floats.toArray(collection);
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + Float.floatToIntBits(this.gantryAngle);
        n3 = 31 * n3 + Arrays.hashCode(this.isocenter);
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        IsocentricImageOrientation isocentricImageOrientation = (IsocentricImageOrientation)object;
        if (!MathUtils.a(this.gantryAngle, isocentricImageOrientation.gantryAngle, 0.01f)) {
            return false;
        }
        return MathUtils.a(this.isocenter, isocentricImageOrientation.isocenter, 0.01f);
    }
}

