/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.mimvista.dicom.CoercingJsonDicomSeries;
import com.mimvista.dicom.DicomObjectMapAdapter;
import com.mimvista.dicom.DicomSeries;
import com.mimvista.dicom.DicomSeriesMapAdapter;
import com.mimvista.dicom.JsonPathUtil;
import com.mimvista.metabase.MetabaseKeys;
import com.mimvista.state.ReadHelper;
import com.mimvista.state.d;
import com.mimvista.swing.widgets.MOptionPane;
import com.mimvista.util.MIMContext;
import com.mimvista.util.MapView;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.viewer.SeriesInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.dcm4che2.data.DicomObject;

public class JsonDicomSeries
extends CoercingJsonDicomSeries
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private transient Map<String, Object> cache = Maps.newHashMap();
    protected transient MapView<String, Object> json;

    public static JsonDicomSeries castOrConvert(DicomSeries dicomSeries) {
        if (dicomSeries == null) {
            return null;
        }
        if (dicomSeries instanceof JsonDicomSeries) {
            return (JsonDicomSeries)dicomSeries;
        }
        return new JsonDicomSeries(dicomSeries);
    }

    protected JsonDicomSeries() {
    }

    public JsonDicomSeries(Map<String, Object> map) {
        this.json = new MapView<String, Object>(map);
    }

    public JsonDicomSeries(JsonDicomSeries jsonDicomSeries) {
        this(jsonDicomSeries.json);
    }

    public JsonDicomSeries(DicomObject dicomObject) {
        this.json = new MapView<String, Object>(new DicomObjectMapAdapter(dicomObject));
    }

    public JsonDicomSeries(DicomSeries dicomSeries) {
        this.json = new MapView<String, Object>(new DicomSeriesMapAdapter(dicomSeries));
    }

    @Override
    public boolean exists(int n2) {
        return JsonDicomSeries.existsTest(this.getTagValue(n2));
    }

    @Override
    public boolean exists(JsonPath jsonPath) {
        try {
            return JsonDicomSeries.existsTest(this.get(jsonPath));
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public void clearCache() {
        this.cache = Maps.newHashMap();
    }

    public ImmutableList<DicomSeries> getTagSequence(int n2) {
        return this.getTagSequence(JsonPathUtil.forTag(n2));
    }

    public ImmutableList<DicomSeries> getTagSequence(JsonPath jsonPath) {
        return JsonDicomSeries.processTagValues(this.getValueOrNull(jsonPath));
    }

    @Override
    public <T> T getTagValue(int n2) {
        if (MetabaseKeys.isMIMFakeDicomTag(n2)) {
            return this.getTagValue(new JsonPath(MetabaseKeys.fromTag(n2), new Filter[0]));
        }
        return JsonDicomSeries.processTagValue(this.get(n2));
    }

    @Override
    public <T> T getTagValue(JsonPath jsonPath) {
        T t2 = this.getValueOrNull(jsonPath);
        return JsonDicomSeries.processTagValue(t2);
    }

    @Override
    public <T> ImmutableList<T> getTagValues(int n2) {
        return JsonDicomSeries.processTagValues(this.get(n2));
    }

    @Override
    public <T> ImmutableList<T> getTagValues(JsonPath jsonPath) {
        T t2 = this.getValueOrNull(jsonPath);
        return JsonDicomSeries.processTagValues(t2);
    }

    @Override
    public int[] getTagKeys() {
        ArrayList arrayList = Lists.newArrayList();
        Set<String> set = this.json.keySet();
        Iterator<String> iterator = set.iterator();
        for (int i2 = 0; i2 < set.size(); ++i2) {
            String string = iterator.next();
            try {
                arrayList.add(Integer.valueOf(string, 16));
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        int[] nArray = new int[arrayList.size()];
        for (int i3 = 0; i3 < arrayList.size(); ++i3) {
            nArray[i3] = (Integer)arrayList.get(i3);
        }
        return nArray;
    }

    public MapView<String, Object> getMapView() {
        return this.json;
    }

    public String toString() {
        return this.json.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T get(int n2) {
        String string = JsonPathUtil.pathStringForTag(n2);
        Object object = this.cache;
        synchronized (object) {
            if (this.cache.containsKey(string)) {
                return (T)this.cache.get(string);
            }
        }
        object = this.json.get(MetabaseKeys.fromTag(n2));
        Map<String, Object> map = this.cache;
        synchronized (map) {
            this.cache.put(string, object);
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T get(JsonPath jsonPath) throws Exception {
        Object object;
        String string = jsonPath.getPath();
        boolean bl2 = string.contains("?");
        if (!bl2) {
            object = this.cache;
            synchronized (object) {
                if (this.cache.containsKey(string)) {
                    return (T)this.cache.get(string);
                }
            }
        }
        try {
            object = jsonPath.read(this.json);
            if (!bl2) {
                Map<String, Object> map = this.cache;
                synchronized (map) {
                    this.cache.put(string, object);
                }
            }
            return (T)object;
        }
        catch (InvalidPathException invalidPathException) {
            return null;
        }
    }

    private <T> T getValueOrNull(JsonPath jsonPath) {
        try {
            return this.get(jsonPath);
        }
        catch (Throwable throwable) {
            ay.a((Object)("Error querying for path, the specified indexes may not exist: " + jsonPath.getPath()), this);
            return null;
        }
    }

    @Override
    public JsonDicomSeries clone() {
        try {
            JsonDicomSeries jsonDicomSeries = (JsonDicomSeries)super.clone();
            jsonDicomSeries.cache = new HashMap<String, Object>();
            jsonDicomSeries.json = this.json.b();
            return jsonDicomSeries;
        }
        catch (Throwable throwable) {
            ay.d((Object)throwable, this);
            return null;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (!d.a(objectOutputStream, this.json)) {
            ay.d((Object)"failed to serialize json dicom map", this);
            if (!MIMContext.P()) {
                Messages messages = Messages.a("Archive");
                MOptionPane.b(SeriesInfo.g, messages.b("FAILED_TO_SERIALIZE_JSON_DICOM"), messages.b("FAILED_TO_SERIALIZE_JSON_DICOM"), 0);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        ReadHelper readHelper = new ReadHelper();
        readHelper.a(getField, (Object)this);
        this.json = ReadHelper.b(getField, "json") ? (MapView)getField.get("json", new MapView(Maps.newHashMap())) : d.a(objectInputStream, MapView.class, true);
        if (this.cache == null) {
            this.cache = new HashMap<String, Object>();
        }
    }
}

