/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.google.common.collect.Maps;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import com.mimvista.dicom.util.TagUtils;
import com.mimvista.metabase.MetabaseKeys;
import java.util.Map;
import java.util.StringTokenizer;

public class JsonPathUtil {
    static final String JSONPATH_SPECIAL_CHARS = "$@.[]*,:?()'\"<>!=&| ";
    private static Map<Integer, JsonPath> cacheByTag = Maps.newHashMap();
    private static Map<String, JsonPath> cacheByKey = Maps.newHashMap();

    public static JsonPath normalize(JsonPath jsonPath) {
        return JsonPathUtil.normalize(jsonPath.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonPath normalize(String string) {
        String string2;
        Object object = cacheByKey;
        synchronized (object) {
            if (cacheByKey.containsKey(string)) {
                return cacheByKey.get(string);
            }
        }
        object = new StringTokenizer(string, JSONPATH_SPECIAL_CHARS, true);
        StringBuilder stringBuilder = new StringBuilder();
        while (((StringTokenizer)object).hasMoreTokens()) {
            string2 = ((StringTokenizer)object).nextToken();
            if (string2.length() == 1 && JSONPATH_SPECIAL_CHARS.contains(string2)) {
                stringBuilder.append(string2);
                continue;
            }
            try {
                int n2 = TagUtils.forTagName(string2);
                stringBuilder.append(MetabaseKeys.fromTag(n2));
            }
            catch (Throwable throwable) {
                stringBuilder.append(string2);
            }
        }
        string2 = JsonPath.compile((String)stringBuilder.toString(), (Filter[])new Filter[0]);
        Map<String, JsonPath> map = cacheByKey;
        synchronized (map) {
            cacheByKey.put(string, (JsonPath)string2);
        }
        return string2;
    }

    public static String denormalize(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, JSONPATH_SPECIAL_CHARS, true);
        StringBuilder stringBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() == 1 && JSONPATH_SPECIAL_CHARS.contains(string2)) {
                stringBuilder.append(string2);
                continue;
            }
            try {
                int n2 = TagUtils.forTagName(string2);
                stringBuilder.append(TagUtils.getTagName(n2));
            }
            catch (Throwable throwable) {
                stringBuilder.append(string2);
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonPath forTag(int n2) {
        JsonPath jsonPath = cacheByTag;
        synchronized (jsonPath) {
            if (cacheByTag.containsKey(n2)) {
                return cacheByTag.get(n2);
            }
        }
        jsonPath = JsonPath.compile((String)MetabaseKeys.fromTag(n2), (Filter[])new Filter[0]);
        Map<Integer, JsonPath> map = cacheByTag;
        synchronized (map) {
            cacheByTag.put(n2, jsonPath);
        }
        return jsonPath;
    }

    public static String pathStringForTag(int n2) {
        return "$." + MetabaseKeys.fromSingleTag(n2);
    }
}

