/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import java.util.StringTokenizer;

public final class MIMDcmUrl {
    public static final int DICOM_PORT = 104;
    private static final int DELIMITER = -1;
    private static final int CALLED_AET = 0;
    private static final int CALLING_AET = 1;
    private static final int HOST = 2;
    private static final int PORT = 3;
    private String calledAET;
    private String callingAET;
    private String host;
    private int port = 104;

    public MIMDcmUrl(String string) {
        this.parse(string.trim());
        if (this.calledAET == null) {
            throw new IllegalArgumentException("Missing called AET");
        }
        if (this.host == null) {
            throw new IllegalArgumentException("Missing host name");
        }
    }

    public MIMDcmUrl(String string, String string2, String string3, int n2) {
        this.calledAET = string;
        this.callingAET = string2;
        this.host = string3;
        this.port = n2;
    }

    public final String[] getCipherSuites() {
        return null;
    }

    public final boolean isTLS() {
        return false;
    }

    public final String getCallingAET() {
        return this.callingAET;
    }

    public final String getCalledAET() {
        return this.calledAET;
    }

    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("dicom").append("://").append(this.calledAET);
        if (this.callingAET != null) {
            stringBuffer.append(':').append(this.callingAET);
        }
        stringBuffer.append('@').append(this.host).append(':').append(this.port);
        return stringBuffer.toString();
    }

    private void parse(String string) {
        int n2 = string.indexOf("://");
        if (n2 == -1) {
            throw new IllegalArgumentException(string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n2 + 3), ":@/", true);
        int n3 = 0;
        boolean bl2 = false;
        block11: while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            switch (string2.charAt(0)) {
                case ':': {
                    n3 = bl2 ? 3 : 1;
                    continue block11;
                }
                case '@': {
                    bl2 = true;
                    n3 = 2;
                    continue block11;
                }
                case '/': {
                    return;
                }
            }
            switch (n3) {
                case 0: {
                    this.calledAET = string2;
                    break;
                }
                case 1: {
                    this.callingAET = string2;
                    break;
                }
                case 2: {
                    this.host = string2;
                    break;
                }
                case 3: {
                    this.port = Integer.parseInt(string2);
                    return;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            n3 = -1;
        }
    }
}

