/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mimvista.dicom.DicomSeries;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;

public class MapDicomSeries
implements DicomSeries,
Serializable {
    private static final long serialVersionUID = -3925173908632239175L;
    private Map<Integer, Object> map;

    public MapDicomSeries(Map<Integer, Object> map) {
        this.map = map;
    }

    @Override
    public boolean exists(int n2) {
        return this.map.containsKey(n2) && this.map.get(n2) != null;
    }

    @Override
    public ImmutableList<? extends DicomSeries> getTagSequence(int n2) {
        Iterable iterable = (Iterable)this.map.get(n2);
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)iterable, (Function)new Function<Object, MapDicomSeries>(){

            public MapDicomSeries apply(Object object) {
                return new MapDicomSeries((Map)object);
            }
        }));
    }

    @Override
    public <T> T getTagValue(int n2) {
        Object object = this.map.get(n2);
        if (object == null) {
            return null;
        }
        if (object instanceof Iterable) {
            Iterable iterable = (Iterable)object;
            if (Iterables.isEmpty((Iterable)iterable)) {
                return null;
            }
            Object object2 = Iterables.get((Iterable)iterable, (int)0);
            if (object2 instanceof Map) {
                return (T)new MapDicomSeries((Map)object2);
            }
            return (T)object2;
        }
        return (T)object;
    }

    @Override
    public <T> ImmutableList<T> getTagValues(int n2) {
        Object object = this.map.get(n2);
        if (object == null) {
            return null;
        }
        if (object instanceof Iterable) {
            return ImmutableList.copyOf((Iterable)((Iterable)object));
        }
        return ImmutableList.of((Object)object);
    }

    @Override
    public int[] getTagKeys() {
        Set<Integer> set = this.map.keySet();
        int[] nArray = new int[set.size()];
        int n2 = 0;
        for (int n3 : set) {
            nArray[n2++] = n3;
        }
        return nArray;
    }
}

