/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mimvista.report.codes.Concept;
import com.mimvista.report.codes.ConceptCode;
import com.mimvista.report.codes.GenericConceptCode;
import com.mimvista.util.Messages;
import com.mimvista.util.cn;
import java.util.Collection;
import java.util.List;

public enum Modality implements Concept
{
    CT(Modality.$("CT"), Modality.$("1.2.840.10008.5.1.4.1.1.2")),
    PT(Modality.$("PT"), Modality.$("1.2.840.10008.5.1.4.1.1.128", "1.2.840.10008.5.1.4.1.1.130")),
    MR(Modality.$("MR"), Modality.$("1.2.840.10008.5.1.4.1.1.4")),
    NM(Modality.$("NM"), Modality.$("1.2.840.10008.5.1.4.1.1.20")),
    US(Modality.$("US"), Modality.$("1.2.840.10008.5.1.4.1.1.6.1", "1.2.840.10008.5.1.4.1.1.3.1")),
    USVID(Modality.$("USVID"), Modality.$(new String[0])),
    REG(Modality.$("REG"), Modality.$("1.2.840.10008.5.1.4.1.1.66.1", "1.2.840.10008.5.1.4.1.1.66.3")),
    OT(Modality.$("OT"), Modality.$("1.2.840.10008.5.1.4.1.1.7")),
    FUS(Modality.$("FUS"), Modality.$(new String[0])),
    RTST(Modality.$("RTSTRUCT", "RTST"), Modality.$("1.2.840.10008.5.1.4.1.1.481.3")),
    RTDOSE(Modality.$("RTDOSE"), Modality.$("1.2.840.10008.5.1.4.1.1.481.2")),
    RTPLAN(Modality.$("RTPLAN"), Modality.$("1.2.840.10008.5.1.4.1.1.481.5", "1.2.840.10008.5.1.4.1.1.481.8")),
    RTIMAGE(Modality.$("RTIMAGE"), Modality.$("1.2.840.10008.5.1.4.1.1.481.1")),
    DOC(Modality.$("DOC"), Modality.$(new String[0])),
    SR(Modality.$("SR"), Modality.$("1.2.840.10008.5.1.4.1.1.88.22")),
    XA(Modality.$("XA"), Modality.$("1.2.840.10008.5.1.4.1.1.12.1")),
    DX(Modality.$("DX"), Modality.$("1.2.840.10008.5.1.4.1.1.1.1", "1.2.840.10008.5.1.4.1.1.1.1.1")),
    CR(Modality.$("CR"), Modality.$("1.2.840.10008.5.1.4.1.1.1")),
    FINDINGS(Modality.$("FINDINGS"), Modality.$(new String[0])),
    RAW(Modality.$("RAW"), Modality.$(new String[0])),
    MG(Modality.$("MG"), Modality.$("1.2.840.10008.5.1.4.1.1.1.2", "1.2.840.10008.5.1.4.1.1.1.2.1")),
    SEG(Modality.$("SEG"), Modality.$("1.2.840.10008.5.1.4.1.1.66.5")),
    UNKNOWN(Modality.$(""), Modality.$(new String[0]));

    public static List<Modality> rtModalities;
    final ConceptCode code;
    final Collection<String> legalModalities = Lists.newArrayList();
    final Collection<String> sopClassUIDs;
    public static final String SESSION = "SESSION";
    public static final String BXplan = "BXplan";

    private static String[] $(String ... stringArray) {
        return stringArray;
    }

    private Modality(String[] stringArray, String[] stringArray2) {
        for (String string2 : stringArray) {
            this.legalModalities.add(string2.toUpperCase());
        }
        this.sopClassUIDs = Lists.newArrayList();
        for (String string2 : stringArray2) {
            this.sopClassUIDs.add(string2);
        }
        this.code = cn.h(stringArray[0]) ? new GenericConceptCode("114010", "DCM", "01", Messages.a("InfoItem", "UNKNOWN"), this) : new GenericConceptCode(stringArray[0], "DCM", "01", stringArray[0], this);
    }

    @Override
    public ConceptCode getCode() {
        return this.code;
    }

    @Override
    public String getCodeMeaning() {
        return this.get();
    }

    @Override
    public boolean isHeadingConcept() {
        return false;
    }

    public String get() {
        return this.legalModalities.iterator().next();
    }

    public List<String> getAssociatedSopClassUIDs() {
        return new ImmutableList.Builder().addAll(this.sopClassUIDs).build();
    }

    public String getShortest() {
        String string = this.get();
        for (String string2 : this.legalModalities) {
            if (string2.length() >= string.length()) continue;
            string = string2;
        }
        return string;
    }

    public boolean isSameModality(String string) {
        if (string == null) {
            return false;
        }
        return this.legalModalities.contains(string.toUpperCase());
    }

    public static Modality get(String string) {
        try {
            return Modality.valueOf(string);
        }
        catch (Exception exception) {
            for (Modality modality : Modality.values()) {
                if (!modality.isSameModality(string)) continue;
                return modality;
            }
            return UNKNOWN;
        }
    }

    public static String getCanonicalModalityString(String string) {
        Modality modality = Modality.get(string);
        return modality == UNKNOWN ? string : modality.get();
    }

    public static boolean isSameModality(String string, Modality modality, Modality ... modalityArray) {
        Modality modality2 = Modality.get(string);
        if (modality2 == modality) {
            return true;
        }
        if (modalityArray != null) {
            for (Modality modality3 : modalityArray) {
                if (modality3 != modality2) continue;
                return true;
            }
        }
        return false;
    }

    public static Modality getModalityForSopClass(String string) {
        for (Modality modality : Modality.values()) {
            if (!modality.getAssociatedSopClassUIDs().contains(string)) continue;
            return modality;
        }
        return null;
    }

    public static boolean isRTModality(String string) {
        return RTPLAN.isSameModality(string) || RTST.isSameModality(string) || RTDOSE.isSameModality(string);
    }

    public static boolean isMIMpacsPremiumRequired(String string) {
        return RTIMAGE.isSameModality(string) || RTDOSE.isSameModality(string) || RTPLAN.isSameModality(string);
    }

    public static boolean isRtSopClass(String string) {
        Modality modality = Modality.getModalityForSopClass(string);
        return rtModalities.contains(modality);
    }

    static {
        rtModalities = new ImmutableList.Builder().addAll((Iterable)Lists.newArrayList((Object[])new Modality[]{RTIMAGE, RTDOSE, RTPLAN})).build();
    }
}

