/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.google.common.base.Joiner;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.viewer.SeriesInfo;

public enum NMImageType {
    STATIC,
    WHOLEBODY,
    DYNAMIC,
    DERIVED,
    CAPTURE,
    GATED(false, true),
    TOMO(false, true),
    GATED_TOMO(false, true),
    RECON_TOMO(true, false),
    GATED_RECON_TOMO(true, true);

    public final boolean is3D;
    public final boolean isCine;

    private NMImageType(boolean bl2, boolean bl3) {
        this.is3D = bl2;
        this.isCine = bl3;
    }

    private NMImageType() {
        this.is3D = false;
        this.isCine = false;
    }

    public static NMImageType fromDicomImageType(SeriesInfo seriesInfo) {
        return NMImageType.fromDicomImageType(seriesInfo.imageType);
    }

    public static NMImageType fromDicomImageType(String[] stringArray) {
        return NMImageType.fromDicomImageType(Joiner.on((char)'\\').join((Object[])stringArray));
    }

    public static NMImageType fromDicomImageType(Iterable<String> iterable) {
        return NMImageType.fromDicomImageType(Joiner.on((char)'\\').join(iterable));
    }

    public static NMImageType fromDicomImageType(String string) {
        if (cn.g(string)) {
            return null;
        }
        if ((string = string.toUpperCase()).contains("STATIC")) {
            return STATIC;
        }
        if (string.contains("WHOLEBODY") || string.contains("WHOLE BODY")) {
            return WHOLEBODY;
        }
        if (string.contains("DYNAMIC")) {
            return DYNAMIC;
        }
        if (string.contains("GATED")) {
            if (string.contains("RECON")) {
                return GATED_RECON_TOMO;
            }
            if (string.contains("TOMO")) {
                return GATED_TOMO;
            }
            return GATED;
        }
        if (string.contains("TOMO")) {
            if (string.contains("RECON")) {
                return RECON_TOMO;
            }
            return TOMO;
        }
        if (string.contains("DERIVED")) {
            return DERIVED;
        }
        if (string.contains("SECONDARY")) {
            return CAPTURE;
        }
        ay.b((Object)("Don't know what type of NM an '" + string + "' is."), NMImageType.class);
        return null;
    }
}

