/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.google.common.collect.Lists;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.SeriesGroupable;
import com.mimvista.dicom.util.DicomSeriesEvaluator;
import com.mimvista.dicom.util.TagPath;
import com.mimvista.dicom.util.TagUtils;
import com.mimvista.dicom.util.VRUtils;
import com.mimvista.util.cn;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class SeriesGroup
implements SeriesGroupable {
    private final Set<DcmSeries> series = new HashSet<DcmSeries>();

    public SeriesGroup() {
    }

    public SeriesGroup(SeriesGroupable ... seriesGroupableArray) {
        this(Lists.newArrayList((Object[])seriesGroupableArray));
    }

    public SeriesGroup(Collection<? extends SeriesGroupable> collection) {
        for (SeriesGroupable seriesGroupable : collection) {
            this.series.addAll(seriesGroupable.asSeriesGroup().getSeries());
        }
    }

    public SeriesGroup(DcmSeries dcmSeries) {
        this.series.add(dcmSeries);
    }

    public Set<DcmSeries> getSeries() {
        return new HashSet<DcmSeries>(this.series);
    }

    public boolean addSeries(DcmSeries dcmSeries) {
        return this.series.add(dcmSeries);
    }

    public boolean removeSeries(DcmSeries dcmSeries) {
        return this.series.remove(dcmSeries);
    }

    @Override
    public SeriesGroup asSeriesGroup() {
        return this;
    }

    public Set<String> getSeriesGroupEqualityHash(boolean bl2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (DcmSeries dcmSeries : this.series) {
            hashSet.add(bl2 ? dcmSeries.getSeriesInstanceUID() : dcmSeries.getEqualityHash());
        }
        return hashSet;
    }

    public Set<Object> getParsedTagValues(int n2) {
        return this.getParsedTagValues(new TagPath(n2));
    }

    public Set<Object> getParsedTagValues(TagPath tagPath) {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (DcmSeries dcmSeries : this.series) {
            hashSet.add(new DicomSeriesEvaluator(dcmSeries).getParsedDicomValue(tagPath));
        }
        return hashSet;
    }

    public Date getOldestDate(TagPath tagPath) {
        SortedSet<Date> sortedSet = this.getSortedDates(tagPath);
        if (sortedSet.isEmpty()) {
            return null;
        }
        return sortedSet.first();
    }

    public Date getNewestDate(TagPath tagPath) {
        SortedSet<Date> sortedSet = this.getSortedDates(tagPath);
        if (sortedSet.isEmpty()) {
            return null;
        }
        return sortedSet.last();
    }

    private SortedSet<Date> getSortedDates(TagPath tagPath) {
        if (!VRUtils.isAnyDateTypeVR(TagUtils.vrOfTag(tagPath))) {
            throw new IllegalArgumentException("can't ask for oldest date on a tag that isn't a date VR");
        }
        Set<Object> set = this.getParsedTagValues(tagPath);
        set.removeAll(Lists.newArrayList((Object[])new Serializable[]{new Date(0L), null, ""}));
        TreeSet<Date> treeSet = new TreeSet<Date>();
        for (Object object : set) {
            treeSet.add((Date)object);
        }
        return treeSet;
    }

    public boolean isSingleSeries() {
        return this.series.size() == 1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("group: {");
        for (DcmSeries dcmSeries : this.series) {
            stringBuilder.append(dcmSeries.toString());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof SeriesGroup)) {
            return false;
        }
        if (super.equals(object)) {
            return true;
        }
        SeriesGroup seriesGroup = (SeriesGroup)object;
        ArrayList arrayList = Lists.newArrayList(seriesGroup.getSeries());
        ArrayList arrayList2 = Lists.newArrayList(this.getSeries());
        if (arrayList.size() != arrayList2.size()) {
            return false;
        }
        Comparator<DcmSeries> comparator = new Comparator<DcmSeries>(){

            @Override
            public int compare(DcmSeries dcmSeries, DcmSeries dcmSeries2) {
                String string = (String)dcmSeries.getTagValue(0x20000E);
                String string2 = (String)dcmSeries2.getTagValue(0x20000E);
                return string.compareTo(string2);
            }
        };
        Collections.sort(arrayList, comparator);
        Collections.sort(arrayList2, comparator);
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            DcmSeries dcmSeries = (DcmSeries)arrayList.get(i2);
            DcmSeries dcmSeries2 = (DcmSeries)arrayList2.get(i2);
            if (dcmSeries.getTagValue(0x20000E).equals(dcmSeries2.getTagValue(0x20000E))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        ArrayList arrayList = Lists.newArrayList(this.getSeries());
        Collections.sort(arrayList, new Comparator<DcmSeries>(){

            @Override
            public int compare(DcmSeries dcmSeries, DcmSeries dcmSeries2) {
                String string = (String)dcmSeries.getTagValue(0x20000E);
                String string2 = (String)dcmSeries2.getTagValue(0x20000E);
                return string.compareTo(string2);
            }
        });
        ArrayList arrayList2 = Lists.newArrayList();
        for (DcmSeries dcmSeries : arrayList) {
            arrayList2.add((String)dcmSeries.getTagValue(0x20000E));
        }
        return cn.a(arrayList2).hashCode();
    }
}

