/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mimvista.archive.NameFormatter;
import com.mimvista.d;
import com.mimvista.dicom.DicomSeries;
import com.mimvista.dicom.ImageOrientation;
import com.mimvista.dicom.JsonDicomSeries;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.NMImageType;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.dicom.util.ThirdPartyTag;
import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.iphone.a.a;
import com.mimvista.preferencesNew.ContrastPresetsPrefs;
import com.mimvista.preferencesNew.NukesPrefs0;
import com.mimvista.util.DateUtils;
import com.mimvista.util.MIMContext;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.bz;
import com.mimvista.util.cn;
import com.mimvista.util.x;
import com.mimvista.viewer.PTSeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.viewer.UnitHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.vecmath.Matrix4f;
import org.dcm4che2.data.DicomObject;

public class SeriesIdentifier {
    public static Messages props = Messages.a("Dicom");
    public static final String booPhilips3dXray = "1.3.46.670589.2.4.1.1";
    private static final List<Modality> functionalModalityQualifiers = Lists.newArrayList((Object[])new Modality[]{Modality.NM, Modality.PT, Modality.RTDOSE});
    private static boolean triedAlignmentComparator = false;
    private static Comparator<FusInfo> fusionAlignmentComparatorIfNotMinSrc = null;
    private static final ImmutableList<String> GATEWAY_HISTORY_KEYWORDS = ImmutableList.of((Object)"ACQUISITIONGATEWAY", (Object)"ACQUISITION GATEWAY", (Object)"LABELLER", (Object)"LABELER");
    public static List<String> legal3DModalities = ImmutableList.builder().add((Object)"CT").add((Object)"MR").add((Object)"NM").add((Object)"PT").add((Object)"ST").add((Object)"NEURO").add((Object)"Z-score").build();
    public static List<String> legal2DModalities = ImmutableList.builder().add((Object)"CR").add((Object)"US").add((Object)"USVID").add((Object)"OT").add((Object)"SC").add((Object)"XA").add((Object)"RF").add((Object)"RTIMAGE").add((Object)"DX").add((Object)"MG").add((Object)"RG").add((Object)"XC").add((Object)"PX").add((Object)"SM").add((Object)"OP").add((Object)"BDUS").add((Object)"BMD").build();
    public static List<String> legalImageSetModalities = ImmutableList.builder().add((Object)"REG").add((Object)"RTSTRUCT").add((Object)"RTST").add((Object)"RTPLAN").add((Object)"PR").build();
    public static Map<String, List<String>> groupModalities = new HashMap<String, List<String>>();

    public static boolean isSuvPet(SeriesInfo.a a2) {
        SeriesInfo seriesInfo = a2.getUncopiedMutableInfo();
        if (seriesInfo != null) {
            return SeriesIdentifier.isSuvPet(seriesInfo.u().z(), seriesInfo.modality);
        }
        return false;
    }

    public static boolean isSuvPet(String string, String string2) {
        return ("suv".equalsIgnoreCase(string) || "suvlbm".equalsIgnoreCase(string) || "suvbsa".equalsIgnoreCase(string) || "suvbw".equalsIgnoreCase(string)) && Modality.PT.isSameModality(string2);
    }

    public static boolean hasBeenTouchedByMayoGateway(SeriesInfo seriesInfo) {
        try {
            JsonDicomSeries jsonDicomSeries = seriesInfo.y();
            if (jsonDicomSeries == null) {
                ay.c((Object)"Loading series with no DICOM info?", SeriesIdentifier.class);
                return false;
            }
            int n2 = x.a(ThirdPartyTag.MayoGatewayCStoreHistory, jsonDicomSeries);
            if (n2 == -1) {
                return false;
            }
            String string = jsonDicomSeries.getTagValue(n2, String.class);
            if (string == null) {
                return false;
            }
            string = string.toUpperCase(Locale.ENGLISH);
            for (String string2 : GATEWAY_HISTORY_KEYWORDS) {
                if (!string.contains(string2)) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            ay.d((Object)"Error trying to read private gateway tags.", (Throwable)exception, SeriesIdentifier.class);
            return false;
        }
    }

    @d
    public static MayoSeriesInfo tryParseMayoSeriesInfo(SimpleImageFrame simpleImageFrame) {
        SeriesInfo seriesInfo = simpleImageFrame.getUncopiedMutableInfo();
        if (!SeriesIdentifier.hasBeenTouchedByMayoGateway(seriesInfo)) {
            return null;
        }
        String string = seriesInfo.seriesDesc;
        if (cn.h(string)) {
            return null;
        }
        String[] stringArray = string.split(":");
        if (stringArray.length < 4) {
            return null;
        }
        return new MayoSeriesInfo(stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
    }

    public static boolean isCine(SeriesInfo seriesInfo) {
        boolean bl2 = false;
        if (seriesInfo.imageType.toLowerCase().contains("gated")) {
            if (!seriesInfo.angularViewVector.isEmpty()) {
                bl2 = true;
            }
        } else if (seriesInfo.seriesType != null && !seriesInfo.seriesType.isEmpty()) {
            String string = seriesInfo.seriesType.toLowerCase();
            if (string.contains("projection")) {
                bl2 = true;
            }
        } else if (!seriesInfo.frameTimeVector.isEmpty()) {
            bl2 = true;
        } else if (!seriesInfo.rotationVector.isEmpty()) {
            if (seriesInfo.numberOfRotations > 1) {
                bl2 = true;
            }
        } else if (seriesInfo.imageType.toLowerCase().contains("projection image")) {
            bl2 = true;
        }
        return bl2;
    }

    public static boolean is3DVolume(SeriesInfo seriesInfo, @d Integer n2) {
        NMImageType nMImageType;
        boolean bl2;
        String string = seriesInfo.sopClassUID;
        if ("RGB".equalsIgnoreCase(seriesInfo.photometricInterp) && !"1.2.840.10008.5.1.4.1.1.6.1".equals(string)) {
            return false;
        }
        boolean bl3 = bl2 = MIMContext.v() && "XA".equalsIgnoreCase(seriesInfo.modality);
        if (bl2) {
            ay.b((Object)"Forcing 3D X-Ray for silver manta.", SeriesIdentifier.class);
        }
        if ("1.2.840.10008.5.1.4.1.1.20".equals(string) && (nMImageType = NMImageType.fromDicomImageType(seriesInfo)) != null) {
            return nMImageType.is3D;
        }
        if (n2 == null && SeriesIdentifier.is3DSOPClass(string, bl2)) {
            return !seriesInfo.imageType.contains("LOCALIZER");
        }
        if (n2 != null && n2 > 1) {
            if ("1.2.840.10008.5.1.4.1.1.128".equals(string) && seriesInfo.u().v()) {
                return false;
            }
            if (SeriesIdentifier.is3DSOPClass(string, bl2)) {
                return true;
            }
            if (Modality.MR.isSameModality(seriesInfo.origModality) && "MONOCHROME2".equals(seriesInfo.photometricInterp) && "1.2.840.10008.5.1.4.1.1.7".equals(string) && Boolean.TRUE.equals(seriesInfo.hasImagePositionPatient)) {
                return true;
            }
        } else {
            if ("1.2.840.10008.5.1.4.1.1.20".equals(string)) {
                nMImageType = NMImageType.fromDicomImageType(seriesInfo);
                return nMImageType != null && nMImageType.is3D;
            }
            if ("1.2.840.10008.5.1.4.1.1.3.1".equals(string) || "1.2.840.10008.5.1.4.1.1.2.1".equals(string) || "1.2.840.10008.5.1.4.1.1.130".equals(string) || "1.2.840.10008.5.1.4.1.1.4.1".equals(string) || "1.2.840.10008.5.1.4.1.1.6.2".equals(string)) {
                return true;
            }
        }
        return false;
    }

    private static boolean is3DSOPClass(String string, boolean bl2) {
        return "1.2.840.10008.5.1.4.1.1.2".equals(string) || "1.2.840.10008.5.1.4.1.1.2.1".equals(string) || "1.2.840.10008.5.1.4.1.1.128".equals(string) || "1.2.840.10008.5.1.4.1.1.130".equals(string) || "1.2.840.10008.5.1.4.1.1.4".equals(string) || "1.2.840.10008.5.1.4.1.1.4.1".equals(string) || "1.2.840.10008.5.1.4.1.1.20".equals(string) || booPhilips3dXray.equals(string) || bl2;
    }

    public static boolean isEncapsulatedPDF(SeriesInfo seriesInfo) {
        return SeriesIdentifier.isEncapsulatedPDF(seriesInfo.sopClassUID);
    }

    public static boolean isEncapsulatedByMIM(DicomObject dicomObject) {
        return dicomObject.contains(930283552);
    }

    public static boolean isEncapsulatedPDF(String string) {
        return "1.2.840.10008.5.1.4.1.1.104.1".equals(string);
    }

    public static boolean isDataFile(DicomSeries dicomSeries) {
        String string = (String)dicomSeries.getTagValue(524310);
        String string2 = (String)dicomSeries.getTagValue(5509121);
        return SeriesIdentifier.isDataFileSOPClass(string) || "1.2.840.10008.5.1.4.1.1.128".equals(string) && "Gy".equalsIgnoreCase(string2);
    }

    public static boolean isNonImageSeries(SeriesInfo seriesInfo) {
        String string = seriesInfo.sopClassUID;
        return SeriesIdentifier.isFinding(seriesInfo) || "1.2.840.10008.5.1.4.1.1.481.3".equals(string) || "1.2.840.10008.5.1.4.1.1.66.1".equals(string) || "1.2.840.10008.5.1.4.1.1.66.3".equals(string) || SeriesIdentifier.isStructuredReport(string) || SeriesIdentifier.isEncapsulatedPDF(seriesInfo) || "1.2.840.10008.5.1.4.1.1.481.5".equals(string) || "1.2.840.10008.5.1.4.1.1.481.8".equals(string) || "1.2.840.10008.5.1.4.1.1.66".equals(string) || "1.2.840.10008.5.1.4.1.1.9.4.1".equals(string) || "1.2.840.10008.5.1.4.1.1.11.1".equals(string) || "1.2.840.10008.5.1.4.1.1.88.59".equals(string);
    }

    public static boolean isDataFileSOPClass(String string) {
        return "1.2.840.10008.5.1.4.1.1.481.3".equals(string) || "1.2.840.10008.5.1.4.1.1.66.1".equals(string) || "1.2.840.10008.5.1.4.1.1.66.3".equals(string) || SeriesIdentifier.isStructuredReport(string) || "1.2.840.10008.5.1.4.1.1.481.5".equals(string) || "1.2.840.10008.5.1.4.1.1.481.8".equals(string) || "1.2.840.10008.5.1.4.1.1.66".equals(string) || "1.2.840.10008.5.1.4.1.1.481.2".equals(string) || "1.2.840.10008.5.1.4.1.1.9.4.1".equals(string) || "1.2.840.10008.5.1.4.1.1.11.1".equals(string) || "1.2.840.10008.5.1.4.1.1.88.59".equals(string) || "1.2.840.10008.5.1.4.1.1.66.5".equals(string);
    }

    public static boolean isStructuredReport(String string) {
        return "1.2.840.10008.5.1.4.1.1.88.11".equals(string) || "1.2.840.10008.5.1.4.1.1.88.22".equals(string) || "1.2.840.10008.5.1.4.1.1.88.33".equals(string);
    }

    public static boolean isStructuredReport(SeriesInfo seriesInfo) {
        return Modality.SR.isSameModality(seriesInfo.modality);
    }

    public static boolean isFinding(SeriesInfo seriesInfo) {
        return SeriesIdentifier.isFinding(seriesInfo.modality);
    }

    public static boolean isFinding(String string) {
        return Modality.FINDINGS.isSameModality(string);
    }

    public static boolean isFunctionalModality(Modality modality) {
        return functionalModalityQualifiers.contains(modality);
    }

    public static boolean isFunctionalModality(String string) {
        return SeriesIdentifier.isFunctionalModality(Modality.get(string));
    }

    public static boolean shouldUseDicomContrast(String string) {
        List<String> list = ContrastPresetsPrefs.modalitiesThatWeShouldTryToLoadContrastFromDicom.getValue();
        HashSet hashSet = Sets.newHashSet();
        for (String string2 : list) {
            hashSet.add(Modality.get(string2));
        }
        return hashSet.contains(Modality.get(string));
    }

    public static boolean is2D(SeriesInfo seriesInfo) {
        boolean bl2 = SeriesIdentifier.is3DVolume(seriesInfo, null);
        bl2 |= SeriesIdentifier.isDataFile(seriesInfo.y());
        if (!(bl2 |= SeriesIdentifier.isEncapsulatedPDF(seriesInfo)) && cn.g(seriesInfo.modality) && cn.g(seriesInfo.sopClassUID)) {
            return false;
        }
        return !bl2;
    }

    public static boolean is2D(DicomSeries dicomSeries) {
        Object object;
        NMImageType nMImageType;
        String string = cn.a(dicomSeries.getTagValue(524384), "");
        if (Modality.NM.isSameModality(string) && (nMImageType = NMImageType.fromDicomImageType(object = dicomSeries.getTagValues(524296))) != null) {
            return !nMImageType.is3D;
        }
        if (Modality.US.isSameModality(string)) {
            object = cn.a(dicomSeries.getTagValue(524310), "");
            if ("1.2.840.10008.5.1.4.1.1.3.1".equals(object + "")) {
                return false;
            }
            if ("1.2.840.10008.5.1.4.1.1.6.1".equals(object)) {
                return true;
            }
        }
        return SeriesIdentifier.is2dModality(string);
    }

    public static boolean isModalityGroup(String string) {
        return groupModalities.containsKey(string.toUpperCase());
    }

    public static boolean isAnatomicGroup(String string) {
        return SeriesIdentifier.isInModalityGroup("ANAT", string);
    }

    public static boolean isFunctionalGroup(String string) {
        return SeriesIdentifier.isInModalityGroup("FUNC", string);
    }

    public static boolean isInModalityGroup(String string, String string2) {
        if (!groupModalities.containsKey(string)) {
            return false;
        }
        return groupModalities.get(string).contains(string2);
    }

    public static boolean is3dModality(String string) {
        return legal3DModalities.contains(string.toUpperCase());
    }

    public static boolean is2dModality(String string) {
        if (string == null) {
            return false;
        }
        return legal2DModalities.contains(string.toUpperCase());
    }

    public static boolean isImageSet(String string) {
        return legalImageSetModalities.contains(string.toUpperCase());
    }

    public static boolean isReferringSeries(String string) {
        return (string = string.toUpperCase()).indexOf("RTST") > -1 || string.indexOf("RTDOSE") > -1 || Modality.SEG.isSameModality(string) || Modality.REG.isSameModality(string) || Modality.RTPLAN.isSameModality(string) || "BXplan".equalsIgnoreCase(string) || Modality.FINDINGS.isSameModality(string);
    }

    public static boolean isReferringSeries(Modality modality) {
        return SeriesIdentifier.isReferringSeries(modality.get());
    }

    public static boolean looksRTSTRUCTy(SeriesInfo seriesInfo) {
        return Modality.RTST.isSameModality(seriesInfo.modality);
    }

    public static boolean canAutoFusePro(SeriesInfo seriesInfo, SeriesInfo seriesInfo2) {
        boolean bl2 = false;
        if (SeriesIdentifier.is2D(seriesInfo) == SeriesIdentifier.is2D(seriesInfo2) && seriesInfo2.modality.compareTo(seriesInfo.modality) >= 1 && !SeriesIdentifier.looksRTSTRUCTy(seriesInfo) && !SeriesIdentifier.looksRTSTRUCTy(seriesInfo2)) {
            boolean bl3 = false;
            if (!seriesInfo2.frameOfRefUID.equals(seriesInfo.frameOfRefUID) && seriesInfo2.frameOfRefUID.length() > 0) {
                bl3 = true;
            }
            if (!SeriesIdentifier.isNAC(seriesInfo2) && !SeriesIdentifier.isNAC(seriesInfo)) {
                if (seriesInfo2.modality.equals("PT") && seriesInfo2.scatterCorrection.equals("NONE") && seriesInfo2.manufacturer.toLowerCase().indexOf("philips") > -1) {
                    System.out.println("PREVIEW PET");
                } else if (seriesInfo.modality.equals("PT") && seriesInfo.scatterCorrection.equals("NONE") && seriesInfo.manufacturer.toLowerCase().indexOf("philips") > -1) {
                    System.out.println("PREVIEW PET");
                } else {
                    boolean bl4 = true;
                    if (seriesInfo2.studyUID == null || !seriesInfo2.studyUID.equals(seriesInfo.studyUID)) {
                        bl4 = false;
                    } else {
                        System.out.println("Same Study UID");
                    }
                    if (!bl3 || SeriesIdentifier.quasiAllowed(seriesInfo2) && SeriesIdentifier.quasiAllowed(seriesInfo) && bl4) {
                        if (bl3 && Math.abs(Integer.valueOf(seriesInfo2.P()) - Integer.valueOf(seriesInfo.P())) < 20000 && ("NM".equals(seriesInfo.modality) || "NM".equals(seriesInfo2.modality))) {
                            System.out.println("Quasi FOR failed");
                        } else if (SeriesIdentifier.areInSameModalityGroup(seriesInfo.modality.toUpperCase(), seriesInfo2.modality.toUpperCase())) {
                            System.out.println("Functional modalities don't fuse with each other.And neither do anatomic ones.");
                        } else {
                            bl2 = true;
                        }
                    }
                }
            }
        }
        return bl2;
    }

    public static boolean isNAC(SeriesInfo seriesInfo) {
        if (!seriesInfo.modality.equals("PT") || seriesInfo.modInfo == null) {
            return false;
        }
        if (!(seriesInfo.modInfo instanceof PTSeriesInfo)) {
            return false;
        }
        PTSeriesInfo pTSeriesInfo = (PTSeriesInfo)seriesInfo.modInfo;
        if (pTSeriesInfo.attenuationCorrectionMethod != null) {
            return false;
        }
        if (seriesInfo.correctedImage.toLowerCase().indexOf("attn") == -1) {
            System.out.println("UNCORRECTED PET!: " + seriesInfo.correctedImage);
            return true;
        }
        return seriesInfo.u().c("PROPCNTS");
    }

    public static boolean quasiAllowed(SeriesInfo seriesInfo) {
        boolean bl2;
        boolean bl3 = seriesInfo.manufacturer.toLowerCase().indexOf("philips") > -1;
        boolean bl4 = seriesInfo.imageType.toLowerCase().indexOf("primary") > -1;
        boolean bl5 = bl2 = seriesInfo.imageType.toLowerCase().indexOf("derived") > -1;
        if (bl3) {
            bl2 = false;
        }
        if (bl3 && seriesInfo.modality.equalsIgnoreCase("CT")) {
            return true;
        }
        return bl4 && !bl2;
    }

    public static boolean areInSameModalityGroup(String string, String string2) {
        for (String string3 : groupModalities.keySet()) {
            List<String> list = groupModalities.get(string3);
            if (list.contains(string)) {
                return list.contains(string2);
            }
            if (!list.contains(string2)) continue;
            return false;
        }
        return false;
    }

    public static String sanitizeId(String string) {
        string = string.replaceAll("\\*", ".");
        string = string.replaceAll("_", ".");
        string = string.replaceAll("/", ".");
        string = string.replaceAll("_", ".");
        string = string.toLowerCase().replaceAll(" ", "^");
        return string;
    }

    public static String sanitizeName(String string) {
        string = string.replaceAll(", ", " ");
        string = string.replaceAll("\\s+", " ");
        string = string.trim();
        string = string.replaceAll("[^0-9a-zA-Z_\\^\\s]", "");
        string = string.toLowerCase().replaceAll(" ", "^");
        return string;
    }

    public static boolean comparePatientNames(String string, String string2) {
        return SeriesIdentifier.compareSanitizedCrunchedPatientNames(SeriesIdentifier.sanitizeName(NameFormatter.d(string)), SeriesIdentifier.sanitizeName(NameFormatter.d(string2)));
    }

    public static boolean compareSanitizedCrunchedPatientNames(String string, String string2) {
        String[] stringArray = string.split("\\^");
        String[] stringArray2 = string2.split("\\^");
        for (int i2 = 0; i2 < Math.min(stringArray.length, stringArray2.length); ++i2) {
            String string3 = stringArray[i2];
            String string4 = stringArray2[i2];
            if (string3.equals(string4)) continue;
            return false;
        }
        return true;
    }

    public static void removeDuplicatedFusionEntries(List<? extends FusInfo> list) {
        ArrayList arrayList = Lists.newArrayList();
        ArrayList arrayList2 = Lists.newArrayList(list);
        for (Object object : arrayList2) {
            if (!arrayList.contains(object)) {
                arrayList.add(object);
                continue;
            }
            list.remove(object);
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (FusInfo entry : list) {
            SeriesIdentifier.addMapEntry(entry.x, linkedHashMap, entry);
            SeriesIdentifier.addMapEntry(entry.y, linkedHashMap, entry);
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            List list2 = (List)entry.getValue();
            if (list2.size() <= 1) continue;
            SeriesIdentifier.sortFusions(list2);
            FusInfo fusInfo = (FusInfo)list2.get(0);
            for (int i2 = 1; i2 < list2.size(); ++i2) {
                FusInfo fusInfo2 = (FusInfo)list2.get(i2);
                if (fusInfo2.x == entry.getKey()) {
                    ((List)linkedHashMap.get(fusInfo2.y)).remove(fusInfo2);
                } else {
                    ((List)linkedHashMap.get(fusInfo2.x)).remove(fusInfo2);
                }
                list.remove(fusInfo2);
            }
            list2.clear();
            list2.add(fusInfo);
        }
    }

    private static void sortFusions(List<FusInfo> list) {
        Collections.sort(list, new Comparator<FusInfo>(){

            @Override
            public int compare(FusInfo fusInfo, FusInfo fusInfo2) {
                if (this.isSecondaryAlignedToPrimary(fusInfo) && !this.isSecondaryAlignedToPrimary(fusInfo2)) {
                    return -1;
                }
                if (!this.isSecondaryAlignedToPrimary(fusInfo) && this.isSecondaryAlignedToPrimary(fusInfo2)) {
                    return 1;
                }
                if (this.isSameModalityFusion(fusInfo) && !this.isSameModalityFusion(fusInfo2)) {
                    return 1;
                }
                if (!this.isSameModalityFusion(fusInfo) && this.isSameModalityFusion(fusInfo2)) {
                    return -1;
                }
                if (this.isSameStudyUID(fusInfo) && !this.isSameStudyUID(fusInfo2)) {
                    return -1;
                }
                if (!this.isSameStudyUID(fusInfo) && this.isSameStudyUID(fusInfo2)) {
                    return 1;
                }
                if (this.isSameFrameOfReference(fusInfo) && !this.isSameFrameOfReference(fusInfo2)) {
                    return -1;
                }
                if (!this.isSameFrameOfReference(fusInfo) && this.isSameFrameOfReference(fusInfo2)) {
                    return 1;
                }
                long l2 = this.fusionTimeDifference(fusInfo);
                long l3 = this.fusionTimeDifference(fusInfo2);
                if (l2 > 0L && l3 < 0L) {
                    return -1;
                }
                if (l3 > 0L && l2 < 0L) {
                    return 1;
                }
                if (l2 > 0L && l3 > 0L) {
                    if (l2 < l3) {
                        return -1;
                    }
                    if (l3 < l2) {
                        return 1;
                    }
                }
                if (this.areBothSecondaryModality("PT", fusInfo, fusInfo2)) {
                    if (this.isRoughlyAttenCorrectedPet(fusInfo.y) && !this.isRoughlyAttenCorrectedPet(fusInfo2.y)) {
                        return -1;
                    }
                    if (!this.isRoughlyAttenCorrectedPet(fusInfo.y) && this.isRoughlyAttenCorrectedPet(fusInfo2.y)) {
                        return 1;
                    }
                }
                if (this.areBothSecondaryModality("NM", fusInfo, fusInfo2)) {
                    if (this.isTransmissionNuke(fusInfo.y) && !this.isTransmissionNuke(fusInfo2.y)) {
                        return 1;
                    }
                    if (!this.isTransmissionNuke(fusInfo.y) && this.isTransmissionNuke(fusInfo2.y)) {
                        return -1;
                    }
                }
                int n2 = this.sortByAlignmentIfPossible(fusInfo, fusInfo2);
                return n2;
            }

            private synchronized int sortByAlignmentIfPossible(FusInfo fusInfo, FusInfo fusInfo2) {
                if (fusionAlignmentComparatorIfNotMinSrc != null) {
                    return fusionAlignmentComparatorIfNotMinSrc.compare(fusInfo, fusInfo2);
                }
                if (triedAlignmentComparator) {
                    return 0;
                }
                triedAlignmentComparator = true;
                bz<Object> bz2 = new bz<Object>();
                Comparator comparator = bz2.a(null, "com.mimvista.dicom.SeriesIdentifierMIM", "sortBetterAlignedFusionsFirst");
                fusionAlignmentComparatorIfNotMinSrc = comparator;
                return fusionAlignmentComparatorIfNotMinSrc.compare(fusInfo, fusInfo2);
            }

            private boolean areBothSecondaryModality(String string, FusInfo fusInfo, FusInfo fusInfo2) {
                return string.equals(fusInfo.y.getUncopiedMutableInfo().modality) && string.equals(fusInfo2.y.getUncopiedMutableInfo().modality);
            }

            private boolean isTransmissionNuke(SeriesInfo.a a2) {
                return a2.getUncopiedMutableInfo().imageType.contains("TRANSMISSION");
            }

            private boolean isRoughlyAttenCorrectedPet(SeriesInfo.a a2) {
                SeriesInfo seriesInfo = a2.getUncopiedMutableInfo();
                if (!"PT".equals(seriesInfo.modality)) {
                    return false;
                }
                UnitHelper unitHelper = seriesInfo.u();
                if (unitHelper.c("PROPCNTS")) {
                    return false;
                }
                if (unitHelper.c("PROPCPS")) {
                    return false;
                }
                if (unitHelper.b("bq")) {
                    return true;
                }
                if (unitHelper.x()) {
                    return true;
                }
                if (seriesInfo.modInfo == null || !(seriesInfo.modInfo instanceof PTSeriesInfo)) {
                    return false;
                }
                PTSeriesInfo pTSeriesInfo = (PTSeriesInfo)seriesInfo.modInfo;
                String string = pTSeriesInfo.attenuationCorrectionMethod;
                return string != null && !string.isEmpty();
            }

            private long fusionTimeDifference(FusInfo fusInfo) {
                SeriesInfo seriesInfo = fusInfo.x.getUncopiedMutableInfo();
                SeriesInfo seriesInfo2 = fusInfo.y.getUncopiedMutableInfo();
                Boolean bl2 = NukesPrefs0.useAcquisitionTimeForAutoFusions.getValue();
                if (Modality.NM.isSameModality(seriesInfo2.modality) && bl2.booleanValue()) {
                    return this.fusionTimeDifferenceNM(fusInfo);
                }
                return this.fusionSeriesTimeDifference(seriesInfo, seriesInfo2);
            }

            private long fusionSeriesTimeDifference(SeriesInfo seriesInfo, SeriesInfo seriesInfo2) {
                Date date = seriesInfo.e();
                Date date2 = seriesInfo2.e();
                if (date != null && date2 != null) {
                    Date date3 = seriesInfo.f();
                    Date date4 = seriesInfo2.f();
                    if (date3 != null && date4 != null) {
                        DateUtils.a(date, date3);
                        DateUtils.a(date2, date4);
                    }
                    return date2.getTime() - date.getTime();
                }
                return 0L;
            }

            private long fusionTimeDifferenceNM(FusInfo fusInfo) {
                SeriesInfo seriesInfo = fusInfo.x.getUncopiedMutableInfo();
                SeriesInfo seriesInfo2 = fusInfo.y.getUncopiedMutableInfo();
                Date date = seriesInfo.acqDate;
                Date date2 = seriesInfo2.acqDate;
                long l2 = Long.MAX_VALUE;
                long l3 = Long.MAX_VALUE;
                if (date != null && date2 != null) {
                    Date date3 = seriesInfo.acqTime;
                    Date date4 = seriesInfo2.acqTime;
                    if (date3 != null && date4 != null) {
                        DateUtils.a(date, date3);
                        DateUtils.a(date2, date4);
                    }
                    l3 = date2.getTime() - date.getTime();
                }
                if (l3 != Long.MAX_VALUE) {
                    return l3;
                }
                return this.fusionSeriesTimeDifference(seriesInfo, seriesInfo2);
            }

            private boolean isSameModalityFusion(FusInfo fusInfo) {
                return fusInfo.x.getUncopiedMutableInfo().modality.equalsIgnoreCase(fusInfo.y.getUncopiedMutableInfo().modality);
            }

            private boolean isSameStudyUID(FusInfo fusInfo) {
                return fusInfo.x.getUncopiedMutableInfo().studyUID.equals(fusInfo.y.getUncopiedMutableInfo().studyUID);
            }

            private boolean isSameFrameOfReference(FusInfo fusInfo) {
                return fusInfo.x.getUncopiedMutableInfo().frameOfRefUID.equals(fusInfo.y.getUncopiedMutableInfo().frameOfRefUID);
            }

            private boolean isSecondaryAlignedToPrimary(FusInfo fusInfo) {
                return cn.a(fusInfo.x.getUncopiedMutableInfo().ag(), fusInfo.y.getUncopiedMutableInfo().alignedToVolumeSeriesUID, false);
            }
        });
    }

    private static void addMapEntry(SeriesInfo.a a2, Map<SeriesInfo.a, List<FusInfo>> map, FusInfo fusInfo) {
        ArrayList arrayList = map.get(a2);
        if (arrayList == null) {
            arrayList = Lists.newArrayList();
            map.put(a2, arrayList);
        }
        arrayList.add(fusInfo);
    }

    public static void sortOnModality(List<? extends SeriesInfo.a> list) {
        Collections.sort(list, new Comparator<SeriesInfo.a>(){

            @Override
            public int compare(SeriesInfo.a a2, SeriesInfo.a a3) {
                return a2.getUncopiedMutableInfo().modality.compareToIgnoreCase(a3.getUncopiedMutableInfo().modality);
            }
        });
    }

    public static List<? extends FusInfo> makeAutoFusionEntries(List<? extends SeriesInfo.a> list) {
        ArrayList arrayList = Lists.newArrayList();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            SeriesInfo.a a2 = list.get(i2);
            SeriesInfo seriesInfo = a2.getUncopiedMutableInfo();
            for (int i3 = i2 + 1; i3 < list.size(); ++i3) {
                SeriesInfo.a a3 = list.get(i3);
                if (!SeriesIdentifier.canAutoFusePro(seriesInfo, a3.getUncopiedMutableInfo())) continue;
                arrayList.add(FusInfo.get(a2, a3));
            }
        }
        return arrayList;
    }

    public static List<? extends FusInfo> makeAutoFusionEntriesSpecial(List<? extends SeriesInfo.a> list, List<? extends SeriesInfo.a> list2) {
        ArrayList arrayList = Lists.newArrayList();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            SeriesInfo.a a2;
            int n2;
            SeriesInfo.a a3 = list.get(i2);
            SeriesInfo seriesInfo = a3.getUncopiedMutableInfo();
            for (n2 = 0; n2 < list2.size(); ++n2) {
                a2 = list2.get(n2);
                if (!SeriesIdentifier.canAutoFusePro(a2.getUncopiedMutableInfo(), seriesInfo)) continue;
                arrayList.add(FusInfo.get(a2, a3));
            }
            for (n2 = i2 + 1; n2 < list.size(); ++n2) {
                a2 = list.get(n2);
                if (!SeriesIdentifier.canAutoFusePro(seriesInfo, a2.getUncopiedMutableInfo())) continue;
                arrayList.add(FusInfo.get(a3, a2));
            }
        }
        return arrayList;
    }

    public static boolean isMultiplyOrientedMR(SeriesInfo seriesInfo, Iterable<File> iterable) {
        if (!"1.2.840.10008.5.1.4.1.1.4".equalsIgnoreCase(seriesInfo.sopClassUID) && !"1.2.840.10008.5.1.4.1.1.4.1".equalsIgnoreCase(seriesInfo.sopClassUID)) {
            return false;
        }
        HashSet hashSet = Sets.newHashSet();
        for (File file : iterable) {
            Object[] objectArray;
            DicomObject dicomObject = DicomReader.readFileIntoDicomObject(file, 2097208);
            if (dicomObject == null || (objectArray = dicomObject.getStrings(2097207)) == null || objectArray.length != 6) continue;
            try {
                hashSet.add(new ImageOrientation((String[])objectArray));
            }
            catch (NumberFormatException numberFormatException) {
                ay.d((Object)("Invalid ImageOrientationPatient: " + Arrays.toString(objectArray)), (Throwable)numberFormatException, SeriesIdentifier.class);
                continue;
            }
            if (hashSet.size() <= 1) continue;
            return true;
        }
        return false;
    }

    public static boolean isProjectionImageType(DicomObject dicomObject) {
        String[] stringArray = dicomObject.getStrings(524296);
        if (stringArray != null) {
            for (String string : stringArray) {
                if (!"projection image".equals(string.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public static class FusInfo {
        public final SeriesInfo.a x;
        public final SeriesInfo.a y;
        public Matrix4f forcedAlignment = null;

        public FusInfo(SeriesInfo.a a2, SeriesInfo.a a3) {
            this.x = a2;
            this.y = a3;
        }

        public static FusInfo get(SeriesInfo.a a2, SeriesInfo.a a3) {
            if (a2 instanceof a.c && a3 instanceof a.c) {
                return FusInfoPro.get((a.c)a2, (a.c)a3);
            }
            return new FusInfo(a2, a3);
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + (this.forcedAlignment == null ? 0 : this.forcedAlignment.hashCode());
            n3 = 31 * n3 + (this.x == null ? 0 : this.x.hashCode());
            n3 = 31 * n3 + (this.y == null ? 0 : this.y.hashCode());
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            FusInfo fusInfo = (FusInfo)object;
            if (this.forcedAlignment == null ? fusInfo.forcedAlignment != null : !this.forcedAlignment.equals(fusInfo.forcedAlignment)) {
                return false;
            }
            if (this.x == null ? fusInfo.x != null : !this.x.equals(fusInfo.x)) {
                return false;
            }
            return !(this.y == null ? fusInfo.y != null : !this.y.equals(fusInfo.y));
        }
    }

    public static class FusInfoPro
    extends FusInfo {
        private FusInfoPro(a.c c2, a.c c3) {
            super(c2, c3);
        }

        public static FusInfoPro get(a.c c2, a.c c3) {
            return new FusInfoPro(c2, c3);
        }

        public a.c getPri() {
            return (a.c)this.x;
        }

        public a.c getSec() {
            return (a.c)this.y;
        }
    }

    public static class MayoSeriesInfo {
        public final String orientation;
        public final String bodyPart;
        public final String tracerOrIsotope;
        public final String sundryDesc;

        public MayoSeriesInfo(String string, String string2, String string3, String string4) {
            this.orientation = string;
            this.bodyPart = string2;
            this.tracerOrIsotope = string3;
            this.sundryDesc = string4;
        }
    }
}

