/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.mimvista.dicom.DcmSeries;
import com.mimvista.util.ay;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class SeriesOwnerInfo
implements Serializable {
    public static final Comparator<SeriesOwnerInfo> TIME_COMPARATOR_DES = new Comparator<SeriesOwnerInfo>(){

        @Override
        public int compare(SeriesOwnerInfo seriesOwnerInfo, SeriesOwnerInfo seriesOwnerInfo2) {
            try {
                return seriesOwnerInfo2.getTime().compareTo(seriesOwnerInfo.getTime());
            }
            catch (NullPointerException nullPointerException) {
                if (seriesOwnerInfo == null || seriesOwnerInfo2 == null) {
                    ay.d((Object)"Cannot compare null SeriesOwnerInfo objects", SeriesOwnerInfo.class);
                } else {
                    ay.d((Object)"Cannot compare null times for SeriesOwnerInfo objects", SeriesOwnerInfo.class);
                }
                return 0;
            }
        }
    };
    private static final long serialVersionUID = 1L;
    private String ownerName;
    private String actor;
    private Date time;

    public SeriesOwnerInfo(String string, String string2, Date date) {
        this.ownerName = string;
        this.actor = string2;
        this.time = date;
    }

    public SeriesOwnerInfo(DBObject dBObject) {
        this.ownerName = (String)dBObject.get("ownerName");
        this.actor = (String)dBObject.get("actor");
        this.time = (Date)dBObject.get("time");
    }

    public DBObject toDBObject() {
        BasicDBObject basicDBObject = new BasicDBObject().append("time", (Object)this.time).append("ownerName", (Object)this.ownerName).append("actor", (Object)this.actor);
        return basicDBObject;
    }

    public static List<SeriesOwnerInfo> getOwners(DcmSeries dcmSeries) {
        ArrayList<SeriesOwnerInfo> arrayList = new ArrayList<SeriesOwnerInfo>();
        List<Object> list = dcmSeries.getMimdataList("owners");
        for (Object object : list) {
            DBObject dBObject = (DBObject)object;
            arrayList.add(new SeriesOwnerInfo(dBObject));
        }
        Collections.sort(arrayList, TIME_COMPARATOR_DES);
        return arrayList;
    }

    public static SeriesOwnerInfo getCurrentOwner(DcmSeries dcmSeries) {
        List<SeriesOwnerInfo> list = SeriesOwnerInfo.getOwners(dcmSeries);
        SeriesOwnerInfo seriesOwnerInfo = null;
        if (list.size() != 0) {
            seriesOwnerInfo = list.get(0);
        }
        return seriesOwnerInfo;
    }

    public static void setOwner(DcmSeries dcmSeries, SeriesOwnerInfo seriesOwnerInfo) {
        Map map = (Map)dcmSeries.json.get("mimdata");
        List<Object> list = dcmSeries.getMimdataList("owners");
        if (seriesOwnerInfo != null && map != null) {
            list.add(seriesOwnerInfo.toDBObject());
            map.put("owners", list);
        }
    }

    public static void clearOwnerHistory(DcmSeries dcmSeries) {
        Map map = (Map)dcmSeries.json.get("mimdata");
        map.remove("owners");
        map.remove("mimdata.currentOwner");
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public Date getTime() {
        return (Date)this.time.clone();
    }

    public String getActor() {
        return this.actor;
    }

    public String toString() {
        return this.ownerName + ":" + this.actor + ":" + this.time;
    }

    public boolean equals(Object object) {
        if (object instanceof SeriesOwnerInfo) {
            SeriesOwnerInfo seriesOwnerInfo = (SeriesOwnerInfo)object;
            return this.ownerName.equals(seriesOwnerInfo.ownerName) && this.actor.equals(seriesOwnerInfo.actor) && this.time.equals(seriesOwnerInfo.time);
        }
        return false;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.ownerName == null ? 0 : this.ownerName.hashCode());
        n3 = 31 * n3 + (this.actor == null ? 0 : this.actor.hashCode());
        n3 = 31 * n3 + (this.time == null ? 0 : this.time.hashCode());
        return n3;
    }
}

