/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.mimvista.archive.gui.av;
import com.mimvista.archive.remote.RemoteQueryServer;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.SeriesOwnerInfo;
import com.mimvista.metabase.MetabaseOwnerStrings;
import com.mimvista.user.LoginChecker;
import com.mimvista.util.ay;
import com.mimvista.util.cb;
import com.mimvista.util.cn;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.List;

public class SeriesOwnerUpdater {
    public static void updateOwner(RemoteQueryServer remoteQueryServer, DcmSeries dcmSeries) {
        SeriesOwnerUpdater.updateOwner(remoteQueryServer, Collections.singletonList(dcmSeries));
    }

    public static void updateOwner(RemoteQueryServer remoteQueryServer, List<DcmSeries> list) {
        block3: {
            try {
                for (DcmSeries dcmSeries : list) {
                    SeriesOwnerInfo seriesOwnerInfo = remoteQueryServer.getOwner(dcmSeries.getPrimaryKey(), LoginChecker.getInstance().currentCookieBox());
                    SeriesOwnerInfo.setOwner(dcmSeries, seriesOwnerInfo);
                }
            }
            catch (RemoteException remoteException) {
                if (cb.a(remoteException)) break block3;
                ay.d((Object)remoteException, av.class);
            }
        }
    }

    public static void setOwner(RemoteQueryServer remoteQueryServer, String string, DcmSeries dcmSeries) {
        SeriesOwnerUpdater.setOwner(remoteQueryServer, string, Collections.singletonList(dcmSeries));
    }

    public static void setOwner(RemoteQueryServer remoteQueryServer, String string, List<DcmSeries> list) {
        for (DcmSeries dcmSeries : list) {
            if (SeriesOwnerUpdater.getOwnerName(dcmSeries).equals(string)) continue;
            try {
                remoteQueryServer.setOwner(dcmSeries.getPrimaryKey(), string, LoginChecker.getInstance().currentCookieBox());
                SeriesOwnerUpdater.updateOwner(remoteQueryServer, dcmSeries);
            }
            catch (RemoteException remoteException) {
                if (cb.a(remoteException)) continue;
                ay.d((Object)remoteException, av.class);
            }
        }
    }

    public static String getOwnerName(DcmSeries dcmSeries) {
        if (SeriesOwnerUpdater.hasOwner(dcmSeries)) {
            return SeriesOwnerInfo.getCurrentOwner(dcmSeries).getOwnerName();
        }
        return "";
    }

    public static void removeOwner(RemoteQueryServer remoteQueryServer, DcmSeries dcmSeries) {
        SeriesOwnerUpdater.removeOwner(remoteQueryServer, Collections.singletonList(dcmSeries));
    }

    public static void clearOwnerHistory(RemoteQueryServer remoteQueryServer, List<DcmSeries> list) {
        for (DcmSeries dcmSeries : list) {
            try {
                remoteQueryServer.clearOwnerHistory(dcmSeries.getPrimaryKey(), LoginChecker.getInstance().currentCookieBox());
                SeriesOwnerUpdater.updateOwner(remoteQueryServer, dcmSeries);
            }
            catch (RemoteException remoteException) {
                if (cb.a(remoteException)) continue;
                ay.d((Object)remoteException, av.class);
            }
        }
    }

    public static boolean hasOwner(DcmSeries dcmSeries) {
        SeriesOwnerInfo seriesOwnerInfo = SeriesOwnerInfo.getCurrentOwner(dcmSeries);
        return seriesOwnerInfo != null && !cn.h(seriesOwnerInfo.getOwnerName()) && MetabaseOwnerStrings.b.b(seriesOwnerInfo.getOwnerName()) == null;
    }

    public static void removeOwner(RemoteQueryServer remoteQueryServer, List<DcmSeries> list) {
        for (DcmSeries dcmSeries : list) {
            if (!SeriesOwnerUpdater.hasOwner(dcmSeries)) continue;
            SeriesOwnerUpdater.setOwner(remoteQueryServer, MetabaseOwnerStrings.c.c(), Collections.singletonList(dcmSeries));
        }
    }

    public static boolean hasOwner(List<DcmSeries> list) {
        for (DcmSeries dcmSeries : list) {
            if (!SeriesOwnerUpdater.hasOwner(dcmSeries)) continue;
            return true;
        }
        return false;
    }
}

