/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.mimvista.ExternallyVisible;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@ExternallyVisible
public class SeriesParameters
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @Deprecated
    private String[] uids;
    public String contentDate;
    public String studyDate;
    public String archivePath;
    public String name;
    public String modality;
    public transient String referencingFilePath;
    public int searchType = -1;
    public transient List<String> uidList;

    public SeriesParameters clone() {
        try {
            SeriesParameters seriesParameters = (SeriesParameters)super.clone();
            seriesParameters.uids = Arrays.copyOf(this.uids, this.uids.length);
            this.uidList = new ArrayList<String>(this.uidList);
            return seriesParameters;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw Throwables.propagate((Throwable)cloneNotSupportedException);
        }
    }

    public String toString() {
        try {
            return "SearchType: " + this.searchType + "\nName: " + this.name + "\nModality: " + this.modality + "\nStudyDate: " + this.studyDate + "\nContentDate: " + this.contentDate + "\nArchivePath: " + this.archivePath + "\nRefPath: " + this.referencingFilePath + "\nUids: " + this.uidList;
        }
        catch (Exception exception) {
            return "something broke in here";
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.uidList = Lists.newArrayList((Object[])this.uids);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.uids = this.uidList.toArray(new String[0]);
        objectOutputStream.defaultWriteObject();
    }
}

