/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.archive.remote.QueryResult;
import com.mimvista.cloud.shared.common.version.VersionNumberComparator;
import com.mimvista.d;
import com.mimvista.dicom.DcmSeriesReference;
import com.mimvista.dicom.SeriesReferenceCodec;
import com.mimvista.metabase.Series;
import com.mimvista.metabase.i;
import com.mimvista.metabase.o;
import com.mimvista.metabase.p;
import com.mimvista.metabase.r;
import com.mimvista.update.VersionNumber;
import com.mimvista.util.cn;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SeriesReferenceExtractor {
    public static void extractReferences(QueryResult queryResult, Series series, @d o o2) {
        SeriesReferenceExtractor.extractRefsFromSource(queryResult, series, o2, DcmSeriesReference.ReferenceSource.MimdataSpecialTag);
        SeriesReferenceExtractor.extractRefsFromSource(queryResult, series, o2, DcmSeriesReference.ReferenceSource.DocAndSRDerivedSeries);
        SeriesReferenceExtractor.extractRefsFromSource(queryResult, series, o2, DcmSeriesReference.ReferenceSource.ReferencedSeriesSequence);
        SeriesReferenceExtractor.extractRefsFromSource(queryResult, series, o2, DcmSeriesReference.ReferenceSource.ReferencedDoseSequence);
        SeriesReferenceExtractor.extractRefsFromSource(queryResult, series, o2, DcmSeriesReference.ReferenceSource.ReferencedFrameOfReferenceSequence);
        SeriesReferenceExtractor.extractRefsFromSource(queryResult, series, o2, DcmSeriesReference.ReferenceSource.ReferencedRTPlanSequence);
        SeriesReferenceExtractor.extractRefsFromSource(queryResult, series, o2, DcmSeriesReference.ReferenceSource.ReferencedStructureSetSequence);
    }

    private static void extractRefsFromSource(QueryResult queryResult, Series series, o o2, DcmSeriesReference.ReferenceSource referenceSource) {
        String string = SeriesReferenceCodec.encodeSeriesReferenceCollection(series.getSeriesReferences(referenceSource), o2);
        if (!cn.h(string)) {
            queryResult.attributes.put(referenceSource.toString().toLowerCase(), string);
        }
    }

    public static void addEmbeddedReferences(Series series, o o2, VersionNumber versionNumber) {
        VersionNumber versionNumber2 = new VersionNumber(6, 2, 0, "");
        boolean bl2 = versionNumber != null && VersionNumberComparator.b.d(versionNumber, versionNumber2);
        List<? extends r> list = series.getSeriesReferences(null);
        if (list != null && !list.isEmpty()) {
            int n2 = i.a(versionNumber);
            ArrayList arrayList = Lists.newArrayList();
            for (r r2 : list) {
                List<? extends Series> list2;
                if (r2.getSource() == DcmSeriesReference.ReferenceSource.SCORIS && !bl2 || (list2 = o2.a(r2)).isEmpty()) continue;
                LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
                linkedHashMap.put("source", r2.getSource().name());
                ArrayList arrayList2 = Lists.newArrayList();
                for (p p2 : r2.getUids()) {
                    LinkedHashMap linkedHashMap2 = Maps.newLinkedHashMap();
                    linkedHashMap2.put("tag", p2.b());
                    linkedHashMap2.put("uid", p2.a());
                    arrayList2.add(linkedHashMap2);
                }
                linkedHashMap.put("uids", arrayList2);
                linkedHashMap.put("reffedSeries", list2.get(0).asJsonMap(n2));
                arrayList.add(linkedHashMap);
            }
            Map map = (Map)series.asJsonMap(1).get("mimdata");
            map.put("refs", arrayList);
        }
    }
}

