/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.mimvista.archive.gui.SwingPatientList;
import com.mimvista.archive.remote.QueryClient;
import com.mimvista.archive.remote.RemoteQueryServer;
import com.mimvista.archive.search.RemoteSearchSource;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.SeriesStatusBundle;
import com.mimvista.dicom.SeriesStatusInfo;
import com.mimvista.metabase.s;
import com.mimvista.update.VersionNumber;
import com.mimvista.user.LoginChecker;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cb;
import java.awt.Component;
import java.awt.HeadlessException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;

public class SeriesStatusChecker {
    public static Messages props = Messages.a("PatientList");

    public static int isViewStatusSetByCurrentUser(List<SeriesStatusInfo> list, String string) {
        for (SeriesStatusInfo seriesStatusInfo : list) {
            if (!string.equals(seriesStatusInfo.getName())) continue;
            String string2 = seriesStatusInfo.getUserName();
            if (!(LoginChecker.getInstance().isUserLoggedIn() && LoginChecker.getInstance().isUseNetworkUsers() && LoginChecker.getInstance().currentUser().getLogin().equalsIgnoreCase(string2))) {
                return 0;
            }
            return 1;
        }
        return -1;
    }

    public static void updateStatuses(RemoteQueryServer remoteQueryServer, DcmSeries dcmSeries) throws RemoteException {
        SeriesStatusChecker.updateStatuses(remoteQueryServer, Collections.singletonList(dcmSeries));
    }

    public static void updateStatuses(RemoteQueryServer remoteQueryServer, List<DcmSeries> list) throws RemoteException {
        block13: {
            if (remoteQueryServer == null) {
                String string = "RemoteQueryServer is NULL in the Class DcmSeries when call updateStatuses().";
                ay.d((Object)string, SeriesStatusChecker.class);
                return;
            }
            if (list == null || list.isEmpty()) break block13;
            if (SeriesStatusChecker.isMultiStatusQuerySupported(remoteQueryServer)) {
                Object object;
                Object object2;
                ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
                for (DcmSeries object3 : list) {
                    object2 = object3.getRplName();
                    if (object2 == null || ((String)object2).length() == 0) {
                        object = "archiveAlias is NULL in the Class DcmSeries when call updateStatuses().";
                        ay.d(object, SeriesStatusChecker.class);
                        continue;
                    }
                    arrayListMultimap.put(object2, (Object)object3);
                }
                for (String string : arrayListMultimap.keySet()) {
                    object2 = arrayListMultimap.get((Object)string);
                    object = new ArrayList();
                    ArrayList<Long> arrayList = new ArrayList<Long>();
                    Object object3 = object2.iterator();
                    while (object3.hasNext()) {
                        DcmSeries dcmSeries = (DcmSeries)object3.next();
                        object.add(dcmSeries.getArchiveDir());
                        arrayList.add(dcmSeries.getPrimaryKey());
                    }
                    object3 = remoteQueryServer.getViewAndWorkflowStatuses(string, (List<String>)object, arrayList, LoginChecker.getInstance().currentCookieBox());
                    for (int list4 = 0; list4 < object3.size(); ++list4) {
                        DcmSeries dcmSeries = (DcmSeries)object2.get(list4);
                        SeriesStatusBundle seriesStatusBundle = (SeriesStatusBundle)object3.get(list4);
                        if (seriesStatusBundle != null) {
                            dcmSeries.setViewStatus(seriesStatusBundle.getViewStatus());
                            List<SeriesStatusInfo> list2 = seriesStatusBundle.getWfStatus();
                            if (list2.size() == 0) {
                                dcmSeries.setWorkflowStatus((SeriesStatusInfo)null);
                                continue;
                            }
                            dcmSeries.setWorkflowStatus(list2.get(0));
                            continue;
                        }
                        dcmSeries.setViewStatus(new ArrayList<SeriesStatusInfo>());
                        dcmSeries.setWorkflowStatus((SeriesStatusInfo)null);
                    }
                }
            } else {
                for (DcmSeries dcmSeries : list) {
                    String string;
                    String string2 = dcmSeries.getRplName();
                    if (string2 == null || string2.length() == 0) {
                        string = "archiveAlias is NULL in the Class DcmSeries when call updateStatuses().";
                        ay.d((Object)string, SeriesStatusChecker.class);
                        continue;
                    }
                    string = dcmSeries.getArchiveDir();
                    long l2 = dcmSeries.getPrimaryKey();
                    List<SeriesStatusInfo> list3 = remoteQueryServer.getStatuses(string2, string, l2, "View", LoginChecker.getInstance().currentCookieBox());
                    List<SeriesStatusInfo> list4 = remoteQueryServer.getStatuses(string2, string, l2, "Workflow", LoginChecker.getInstance().currentCookieBox());
                    dcmSeries.setViewStatus(list3);
                    if (list4.size() == 0) {
                        dcmSeries.setWorkflowStatus((SeriesStatusInfo)null);
                        continue;
                    }
                    dcmSeries.setWorkflowStatus(list4.get(0));
                }
            }
        }
    }

    private static boolean isMultiStatusQuerySupported(RemoteQueryServer remoteQueryServer) {
        block3: {
            try {
                String string = QueryClient.getServerVersion(remoteQueryServer);
                if (string != null) {
                    VersionNumber versionNumber = new VersionNumber(string);
                    VersionNumber versionNumber2 = new VersionNumber(6, 2, 0, "DB12-00");
                    return versionNumber.greaterThan(versionNumber2);
                }
            }
            catch (RemoteException remoteException) {
                if (cb.a(remoteException)) break block3;
                ay.d((Object)remoteException, SeriesStatusChecker.class);
            }
        }
        return false;
    }

    public static boolean isStatusCurrent(RemoteQueryServer remoteQueryServer, DcmSeries dcmSeries) throws RemoteException {
        return SeriesStatusChecker.areStatusesCurrent(remoteQueryServer, Collections.singletonList(dcmSeries));
    }

    public static boolean areStatusesCurrent(RemoteQueryServer remoteQueryServer, List<DcmSeries> list) throws RemoteException {
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)list.size());
        ArrayList arrayList2 = Lists.newArrayListWithCapacity((int)list.size());
        for (DcmSeries dcmSeries : list) {
            arrayList.add(dcmSeries.getViewStatusNames());
            arrayList2.add(dcmSeries.getWorkflowStatusName());
        }
        SeriesStatusChecker.updateStatuses(remoteQueryServer, list);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            DcmSeries dcmSeries;
            dcmSeries = list.get(i2);
            List list2 = (List)arrayList.get(i2);
            String string = (String)arrayList2.get(i2);
            List<String> list3 = dcmSeries.getViewStatusNames();
            String string2 = dcmSeries.getWorkflowStatusName();
            if (list2.size() != list3.size()) {
                return false;
            }
            if (!list2.containsAll(list3)) {
                return false;
            }
            if (string.equals(string2)) continue;
            return false;
        }
        return true;
    }

    public static boolean askUserAboutStatusUpdates(SearchSource searchSource, List<DcmSeries> list, Component component) {
        if (!(searchSource instanceof RemoteSearchSource)) {
            return true;
        }
        RemoteQueryServer remoteQueryServer = null;
        try {
            remoteQueryServer = s.a((RemoteSearchSource)searchSource);
            if (!remoteQueryServer.isMetabaseRunning()) {
                return true;
            }
        }
        catch (Exception exception) {
            ay.d((Object)"Error occured when trying to connect to remote server", (Throwable)exception, SeriesStatusChecker.class);
            return true;
        }
        boolean bl2 = false;
        try {
            bl2 = !SeriesStatusChecker.areStatusesCurrent(remoteQueryServer, list);
        }
        catch (RemoteException remoteException) {
            ay.d((Object)"Exception while updating status before opening series", (Throwable)remoteException, SeriesStatusChecker.class);
        }
        SeriesStatusChecker.updateStatusDisplay();
        if (bl2) {
            String string = props.getProperty("SWING_PL_CHANGED");
            Object[] objectArray = new Object[]{props.getProperty("SWING_PL_CONTINUE"), props.getProperty("SWING_PL_CANCEL")};
            int n2 = JOptionPane.showOptionDialog(component, string, props.getProperty("SWING_PL_OLD"), 0, 3, null, objectArray, objectArray[0]);
            if (n2 != 0) {
                return false;
            }
        }
        return true;
    }

    public static boolean areAnySeriesLockedByAnotherUser(SearchSource searchSource, List<DcmSeries> list) {
        if (!(searchSource instanceof RemoteSearchSource)) {
            return false;
        }
        LoginChecker loginChecker = LoginChecker.getInstance();
        boolean bl2 = loginChecker.isUserLoggedIn() && loginChecker.isUseNetworkUsers();
        String string = bl2 ? loginChecker.currentUser().getLogin() : "";
        for (DcmSeries dcmSeries : list) {
            for (SeriesStatusInfo seriesStatusInfo : dcmSeries.getViewStatus()) {
                if (!"Locked".equalsIgnoreCase(seriesStatusInfo.getName()) || bl2 && string.equalsIgnoreCase(seriesStatusInfo.getUserName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean askUserIfWeCanOpenLockedSeries(SearchSource searchSource, Component component) {
        block7: {
            if (!(searchSource instanceof RemoteSearchSource)) {
                return true;
            }
            boolean bl2 = false;
            RemoteQueryServer remoteQueryServer = null;
            try {
                remoteQueryServer = s.a((RemoteSearchSource)searchSource);
                bl2 = remoteQueryServer.isLockProhibitive();
            }
            catch (Exception exception) {
                ay.d((Object)"Error occured when trying to determine if the server has prohibitive locking turned on", (Throwable)exception, SeriesStatusChecker.class);
                return true;
            }
            try {
                String string = props.getProperty("SWING_PL_LOCKED");
                if (!bl2) {
                    String string2 = props.getProperty("SWING_PL_LOCKED_MSG");
                    Object[] objectArray = new Object[]{props.getProperty("SWING_PL_CONTINUE"), props.getProperty("SWING_PL_CANCEL")};
                    int n2 = JOptionPane.showOptionDialog(component, string2, string, 0, 3, null, objectArray, objectArray[0]);
                    if (n2 != 0) {
                        return false;
                    }
                    break block7;
                }
                String string3 = props.getProperty("SWING_PL_PROHIBIT_MSG");
                JOptionPane.showMessageDialog(component, string3, string, 2);
                return false;
            }
            catch (HeadlessException headlessException) {
                ay.b((Object)"Can't ask for user permission to open locked series when headless, so let's assume its ok", SeriesStatusChecker.class);
            }
        }
        return true;
    }

    private static void updateStatusDisplay() {
        SwingPatientList swingPatientList = SwingPatientList.c();
        if (swingPatientList != null) {
            swingPatientList.s().updateSeries();
        }
    }
}

