/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.google.common.collect.Lists;
import com.mimvista.dicom.JsonDicomSeriesViewTagFilter;
import com.mimvista.dicom.util.DicomTagParseException;
import com.mimvista.dicom.util.TagUtils;
import com.mimvista.internals.FrameNumber;
import com.mimvista.util.ay;
import com.mimvista.viewer.NMSeriesInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SimpleMapViewFilters {

    public static class NucMedEnergyWindowFilter
    extends JsonDicomSeriesViewTagFilter {
        private static final long serialVersionUID = 1L;
        private final int windowNum;
        private final int myNumberOfFrames;
        private final List<Integer> myWindowVector;

        public NucMedEnergyWindowFilter(int n2, NMSeriesInfo.b b2, List<FrameNumber> list) {
            super(0x280008, 5505041, 5505040, 5505042, 5505046, 930295819);
            this.windowNum = n2;
            this.myNumberOfFrames = list.size();
            Object[] objectArray = new Integer[this.myNumberOfFrames];
            Arrays.fill(objectArray, (Object)n2);
            this.myWindowVector = Lists.newArrayList((Object[])objectArray);
        }

        @Override
        public Object get(String string, Object object) {
            List list;
            int n2;
            try {
                n2 = TagUtils.parseTagValue(string);
            }
            catch (DicomTagParseException dicomTagParseException) {
                ay.d((Object)("Could not parse tag: " + string), (Throwable)dicomTagParseException, this);
                return object;
            }
            if (n2 == 0x280008) {
                return this.myNumberOfFrames;
            }
            if (n2 == 5505041) {
                return 1;
            }
            if (n2 == 5505040) {
                return this.myWindowVector;
            }
            if (n2 == 930295819) {
                return this.windowNum;
            }
            if (n2 == 5505042) {
                if (!(object instanceof List)) {
                    ay.d((Object)("EneryWindowInformationSequence Tag did not return a list: " + String.valueOf(object)), this);
                    return object;
                }
                list = (List)object;
                if (this.windowNum <= list.size()) {
                    ArrayList arrayList = new ArrayList(1);
                    arrayList.add(list.get(this.windowNum - 1));
                    return arrayList;
                }
                ay.d((Object)("Unable to acquire EnergyWindowInformationSequence for detector: " + this.windowNum + ", as initial list is only size " + list.size()), this);
            }
            if (n2 == 5505046) {
                if (!(object instanceof List)) {
                    ay.d((Object)("RadiopharmaceuticalInformationSequence Tag did not return a list: " + String.valueOf(object)), this);
                    return object;
                }
                list = (List)object;
                if (this.windowNum <= list.size()) {
                    ArrayList arrayList = new ArrayList(1);
                    arrayList.add(list.get(this.windowNum - 1));
                    return arrayList;
                }
                ay.d((Object)("Unable to acquire RadiopharmaceuticalInformationSequence for detector: " + this.windowNum + ", as initial list is only size " + list.size()), this);
            }
            return object;
        }
    }

    public static class NucMedDetectorFilter
    extends JsonDicomSeriesViewTagFilter {
        private static final long serialVersionUID = 1L;
        private final int detectorNum;
        private final int myNumberOfFrames;
        private final List<Integer> myDetectorVector;

        public NucMedDetectorFilter(int n2, NMSeriesInfo.a a2, List<FrameNumber> list) {
            super(0x280008, 5505057, 5505056, 5505058, 930295818);
            this.detectorNum = n2;
            this.myNumberOfFrames = list.size();
            Object[] objectArray = new Integer[this.myNumberOfFrames];
            Arrays.fill(objectArray, (Object)n2);
            this.myDetectorVector = Lists.newArrayList((Object[])objectArray);
        }

        @Override
        public Object get(String string, Object object) {
            int n2;
            try {
                n2 = TagUtils.parseTagValue(string);
            }
            catch (DicomTagParseException dicomTagParseException) {
                ay.d((Object)("Could not parse tag: " + string), (Throwable)dicomTagParseException, this);
                return object;
            }
            if (n2 == 0x280008) {
                return this.myNumberOfFrames;
            }
            if (n2 == 5505057) {
                return 1;
            }
            if (n2 == 5505056) {
                return this.myDetectorVector;
            }
            if (n2 == 930295818) {
                return this.detectorNum;
            }
            if (n2 == 5505058) {
                if (!(object instanceof List)) {
                    ay.d((Object)("DetectorInformationSequence Tag did not return a list: " + String.valueOf(object)), this);
                    return object;
                }
                List list = (List)object;
                if (this.detectorNum <= list.size()) {
                    ArrayList arrayList = new ArrayList(1);
                    arrayList.add(list.get(this.detectorNum - 1));
                    return arrayList;
                }
                ay.d((Object)("Unable to acquire DetectorInformationSequence for detector: " + this.detectorNum + ", as initial list is only size " + list.size()), this);
            }
            return object;
        }
    }
}

