/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom;

import com.google.common.collect.Lists;
import com.mimvista.archive.remote.QueryResult;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.DcmSeriesReference;
import com.mimvista.dicom.factories.DcmSeriesFactory;
import com.mimvista.util.ay;
import com.mimvista.util.d;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class SimpleSeriesReferenceCodec {
    static final String DELIMITER = "~!~";
    static final String REFERENCE_IDENTIFIER = "SeriesReference";
    static final String MATCHED_SERIES_IDENTIFIER = "MatchedSeries";

    public static Collection<DcmSeriesReference> decodeSeriesReferenceCollectionString(SearchSource searchSource, String string) {
        String[] stringArray = string.split(REFERENCE_IDENTIFIER);
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)stringArray.length);
        for (String string2 : stringArray) {
            Object object;
            int n2;
            String[] stringArray2;
            if (string2 == null || (stringArray2 = string2.split(DELIMITER)).length <= 2) continue;
            DcmSeriesReference dcmSeriesReference = new DcmSeriesReference();
            boolean bl2 = false;
            for (n2 = 2; n2 < stringArray2.length && MATCHED_SERIES_IDENTIFIER.equals(stringArray2[n2 - 1]); n2 += 2) {
                Object object2;
                object = stringArray2[n2];
                if (object != null && !((String)object).isEmpty()) {
                    object2 = SimpleSeriesReferenceCodec.decodeQueryResult((String)object);
                    DcmSeries dcmSeries = DcmSeriesFactory.getDcmSeriesWithInfoAdded(searchSource, (QueryResult)object2);
                    dcmSeriesReference.addReferencedDcmSeries(dcmSeries);
                    bl2 = true;
                    continue;
                }
                if (bl2) continue;
                object2 = Collections.emptySet();
                dcmSeriesReference.setReferencedDcmSeries((Collection<? extends DcmSeries>)object2);
            }
            while (n2 < stringArray2.length) {
                object = null;
                try {
                    object = DcmSeriesReference.ReferenceUidType.valueOf(stringArray2[n2 - 1]);
                }
                catch (Exception exception) {
                    ay.a((Object)"Unknown ReferenceUIDType in sequence", SimpleSeriesReferenceCodec.class);
                }
                if (object != null) {
                    dcmSeriesReference.addReference((DcmSeriesReference.ReferenceUidType)((Object)object), stringArray2[n2]);
                }
                n2 += 2;
            }
            arrayList.add(dcmSeriesReference);
        }
        return arrayList;
    }

    public static String encodeQueryResult(QueryResult queryResult) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(queryResult.path);
        stringBuilder.append(DELIMITER);
        for (Map.Entry<String, String> entry : queryResult.attributes.entrySet()) {
            stringBuilder.append(entry.getKey());
            stringBuilder.append(DELIMITER);
            if (entry.getValue() != null) {
                stringBuilder.append(d.a(entry.getValue().getBytes(Charset.forName("UTF-16"))));
            }
            stringBuilder.append(DELIMITER);
        }
        return d.a(stringBuilder.toString().getBytes(Charset.forName("UTF-16")));
    }

    public static QueryResult decodeQueryResult(String string) {
        QueryResult queryResult = new QueryResult();
        String string2 = new String(d.a(string), Charset.forName("UTF-16"));
        String[] stringArray = string2.split(DELIMITER);
        if (stringArray.length > 0) {
            queryResult.path = stringArray[0];
            for (int i2 = 2; i2 < stringArray.length; i2 += 2) {
                String string3 = stringArray[i2 - 1];
                String string4 = new String(d.a(stringArray[i2]), Charset.forName("UTF-16"));
                queryResult.attributes.put(string3, string4);
            }
        }
        return queryResult;
    }
}

