/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.binning;

import com.mimvista.dicom.UIDContainer;
import com.mimvista.dicom.binning.SlabInfo;
import com.mimvista.dicom.binning.SliceCache;
import com.mimvista.numerics.e;

public abstract class BinningCostFunction
implements e<short[], short[], Double> {
    public final e<SlabInfo, SlabInfo, Double> getEvaluator(SliceCache sliceCache) {
        return (slabInfo, slabInfo2) -> {
            short[] sArray = sliceCache.peekPrivateSliceData(new UIDContainer.SOPInstanceUID(slabInfo.getLast().sopInstanceUID));
            short[] sArray2 = sliceCache.peekPrivateSliceData(new UIDContainer.SOPInstanceUID(slabInfo2.getFirst().sopInstanceUID));
            return (Double)this.apply(sArray, sArray2);
        };
    }

    public static final BinningCostFunction getCorrelationCostFunction() {
        return new BinningCostFunction(){

            @Override
            public Double apply(short[] sArray, short[] sArray2) {
                double d2 = 0.0;
                double d3 = 0.0;
                for (int i2 = 0; i2 < sArray.length; ++i2) {
                    d2 += (double)sArray[i2];
                    d3 += (double)sArray2[i2];
                }
                d2 /= (double)sArray.length;
                d3 /= (double)sArray2.length;
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                for (int i3 = 0; i3 < sArray.length; ++i3) {
                    d4 += ((double)sArray[i3] - d2) * ((double)sArray2[i3] - d3);
                    d5 += ((double)sArray[i3] - d2) * ((double)sArray[i3] - d2);
                    d6 += ((double)sArray2[i3] - d3) * ((double)sArray2[i3] - d3);
                }
                return Math.sqrt(d5 * d6) / d4;
            }
        };
    }

    public static final BinningCostFunction getRMSResidualCostFunction() {
        return new BinningCostFunction(){

            @Override
            public Double apply(short[] sArray, short[] sArray2) {
                double d2 = 0.0;
                for (int i2 = 0; i2 < sArray.length; ++i2) {
                    d2 += (double)((sArray[i2] - sArray2[i2]) * (sArray[i2] - sArray2[i2]));
                }
                return Math.sqrt(d2 / (double)sArray.length);
            }
        };
    }
}

