/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.binning;

import com.google.common.collect.Lists;
import com.mimvista.dicom.binning.BinningTarget;
import com.mimvista.dicom.binning.RPMDicomMap;
import com.mimvista.dicom.binning.RPMLoader;
import com.mimvista.dicom.binning.TargetType;
import java.io.Serializable;
import java.util.List;

public class BinningParams
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final List<BinningTarget> targets;
    public final RPMLoader.RPMInfo rpmFile;
    public final boolean correction;
    public final TargetType mode;
    public RPMDicomMap dataMap;

    public BinningParams(BinningParams binningParams) {
        this(binningParams.targets, binningParams.rpmFile, binningParams.mode, binningParams.correction);
        this.dataMap = binningParams.dataMap;
    }

    public BinningParams(List<BinningTarget> list, RPMLoader.RPMInfo rPMInfo, TargetType targetType, boolean bl2) {
        this.targets = Lists.newArrayList(list);
        this.rpmFile = rPMInfo;
        this.mode = targetType;
        this.correction = bl2;
    }

    public RPMLoader.RPMInfo getRPM() {
        return this.dataMap == null ? this.rpmFile : this.dataMap.rpm;
    }

    public BinningTarget getTarget(int n2) {
        return this.targets.get(n2);
    }
}

