/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.binning;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mimvista.dicom.UIDContainer;
import com.mimvista.dicom.binning.BinningParams;
import com.mimvista.dicom.binning.BinningStateManager;
import com.mimvista.dicom.binning.BinningTarget;
import com.mimvista.dicom.binning.RPMDicomMap;
import com.mimvista.dicom.binning.SlabInfo;
import com.mimvista.dicom.binning.SlabRPM;
import com.mimvista.dicom.binning.SliceCache;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.VCRef;
import com.mimvista.internals.VolRef;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.util.ay;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.List;

public class BinningState
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final VCRef binned;
    public final BinningParams params;
    public final SliceCache cache;
    public final ImmutableMap<VolRef, ImmutableSet<UIDContainer.SOPInstanceUID>> originalSliceSelection;

    BinningState(VCRef vCRef, BinningParams binningParams, SliceCache sliceCache) {
        this.binned = vCRef;
        this.params = binningParams;
        this.cache = sliceCache;
        this.originalSliceSelection = BinningStateManager.getCurrentSliceSelection(vCRef);
    }

    public RPMDicomMap getDataMap() {
        return this.params.dataMap;
    }

    public BinningTarget getCurrentTarget() {
        int n2 = this.binned.b().cl();
        return this.params.getTarget(n2);
    }

    List<SlabInfo> getBinnedSlabs() {
        return this.getBinnedSlabs(this.binned.b().bh().cw());
    }

    List<SlabInfo> getBinnedSlabs(ImageVolumeShort imageVolumeShort) {
        if (imageVolumeShort.j().aT() != this.binned.b().aT()) {
            ay.d((Object)"Attempted to look up binning state for wrong volume", this);
            throw new IllegalArgumentException("This isn't the binned volume");
        }
        LinkedHashSet<SlabInfo> linkedHashSet = new LinkedHashSet<SlabInfo>();
        for (SliceInfo sliceInfo : imageVolumeShort.ab()) {
            SlabInfo slabInfo = this.getDataMap().getSlab(sliceInfo);
            linkedHashSet.add(slabInfo);
        }
        return Lists.newArrayList(linkedHashSet);
    }

    SlabRPM getInfoForSlice(SliceInfo sliceInfo) {
        return this.getDataMap().lookup(this.getDataMap().getSlab(sliceInfo));
    }
}

