/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.binning;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.commands.workflow.a;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.SeriesParameters;
import com.mimvista.dicom.UIDContainer;
import com.mimvista.dicom.binning.BinningParams;
import com.mimvista.dicom.binning.BinningState;
import com.mimvista.dicom.binning.BinningTarget;
import com.mimvista.dicom.binning.RPMDicomMap;
import com.mimvista.dicom.binning.SlabInfo;
import com.mimvista.dicom.binning.SlabRPM;
import com.mimvista.dicom.binning.SliceCache;
import com.mimvista.dicom.binning.TargetType;
import com.mimvista.dicom.read.LoaderDataProvider;
import com.mimvista.dicom.read.SeriesRef;
import com.mimvista.dicom.reffinder.ReferencedSeriesFinder;
import com.mimvista.internals.DynamicVolumeRef3D;
import com.mimvista.internals.FrameNumber;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.VCRef;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.VolRef;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.mui.Session;
import com.mimvista.mui.bm;
import com.mimvista.mui.bu;
import com.mimvista.mui.presenters.display.DisplaySidePanel;
import com.mimvista.state.SerializedSessionStateObject;
import com.mimvista.state.SessionStateObject;
import com.mimvista.state.VolumeRestorer;
import com.mimvista.state.f;
import com.mimvista.util.ay;
import com.mimvista.util.progress.o;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;

public class BinningStateManager
implements SerializedSessionStateObject<BinningStateManager>,
SessionStateObject {
    private static final long serialVersionUID = 1L;
    private final Map<VCRef, BinningState> states = Maps.newHashMap();

    public BinningStateManager(Session session) {
        this.listenTo(session);
    }

    public static BinningStateManager getInstance() {
        return BinningStateManager.getInstance(bm.b());
    }

    public static BinningStateManager getInstance(Session session) {
        return session.a(BinningStateManager.class);
    }

    public static BinningState getBinningState(ViewController viewController) {
        if (viewController == null || viewController.g() == null) {
            return null;
        }
        BinningStateManager binningStateManager = BinningStateManager.getInstance(viewController.g());
        if (binningStateManager == null) {
            return null;
        }
        return binningStateManager.getBinningState(BinningStateManager.getRef(viewController));
    }

    public static boolean hasBinningState(ViewController viewController) {
        return BinningStateManager.getBinningState(viewController) != null;
    }

    public static VCRef getRef(ViewController viewController) {
        return VCRef.a(viewController.aT());
    }

    public static ImmutableSet<UIDContainer.SOPInstanceUID> getOriginalSliceSelection(DynamicVolumeRef3D dynamicVolumeRef3D) {
        BinningState binningState = BinningStateManager.getBinningState(dynamicVolumeRef3D.e());
        return (ImmutableSet)binningState.originalSliceSelection.get((Object)new VolRef(dynamicVolumeRef3D.f()));
    }

    public static ImmutableSet<UIDContainer.SOPInstanceUID> getCurrentSliceSelection(DynamicVolumeRef3D dynamicVolumeRef3D) {
        return ImmutableSet.copyOf((Collection)Lists.transform(dynamicVolumeRef3D.f().ab(), sliceInfo -> new UIDContainer.SOPInstanceUID(sliceInfo.sopInstanceUID)));
    }

    public static ImmutableMap<VolRef, ImmutableSet<UIDContainer.SOPInstanceUID>> getCurrentSliceSelection(VCRef vCRef) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ViewController3D viewController3D = vCRef.b().bh();
        for (int i2 = 1; i2 <= viewController3D.cE().n(); ++i2) {
            FrameNumber frameNumber = new FrameNumber(i2);
            DynamicVolumeRef3D dynamicVolumeRef3D = new DynamicVolumeRef3D(viewController3D, frameNumber);
            builder.put((Object)new VolRef((ImageFrame)viewController3D.cE().a(frameNumber)), BinningStateManager.getCurrentSliceSelection(dynamicVolumeRef3D));
        }
        return builder.build();
    }

    public synchronized boolean createBinningState(ViewController viewController, BinningParams binningParams, SliceCache sliceCache) {
        VCRef vCRef = BinningStateManager.getRef(viewController);
        if (this.states.containsKey(vCRef)) {
            return false;
        }
        BinningState binningState = new BinningState(vCRef, binningParams, sliceCache);
        this.states.put(vCRef, binningState);
        return true;
    }

    public synchronized BinningState getBinningState(VCRef vCRef) {
        return this.states.get(vCRef);
    }

    public synchronized List<BinningState> getAllStates() {
        this.states.entrySet().removeIf(entry -> ((VCRef)entry.getKey()).b() == null);
        return ImmutableList.copyOf(this.states.values());
    }

    public SerializedSessionStateObject serialize() {
        return this;
    }

    @Override
    public void preventLambdas() {
    }

    @Override
    public BinningStateManager deserialize(Session session) {
        for (Map.Entry<VCRef, BinningState> entry : this.states.entrySet()) {
            ViewController viewController = entry.getKey().b();
            BinningState binningState = entry.getValue();
            RPMDicomMap rPMDicomMap = binningState.getDataMap();
            LoaderDataProvider loaderDataProvider = this.getDataProvider(viewController, binningState);
            TIntObjectHashMap tIntObjectHashMap = new TIntObjectHashMap();
            BinningState binningState2 = this.rebinSeries(viewController, binningState, loaderDataProvider);
            Iterable iterable = Iterables.concat(binningState2.getDataMap().getAllDicom());
            iterable.forEach(sliceInfo -> {
                SliceInfo cfr_ignored_0 = (SliceInfo)tIntObjectHashMap.putIfAbsent(sliceInfo.sliceNumber, sliceInfo);
            });
            Map<SlabInfo, SlabRPM> map = this.getRPMDicomBackingMap(binningState);
            map.keySet().forEach(slabInfo -> slabInfo.replaceAll(sliceInfo -> (SliceInfo)tIntObjectHashMap.get(sliceInfo.sliceNumber)));
            binningState.params.dataMap = new RPMDicomMap(map, rPMDicomMap.getRPMInfo());
            viewController.bh().cE().l().forEach(imageVolumeShort -> {
                List<SliceInfo> list = imageVolumeShort.ab();
                list.replaceAll(sliceInfo -> (SliceInfo)tIntObjectHashMap.get(sliceInfo.sliceNumber));
                ((SimpleImageVolume)imageVolumeShort).a(list);
            });
            binningState.cache.replace(binningState2.cache);
        }
        this.listenTo(session);
        f.a().a(() -> {
            DisplaySidePanel displaySidePanel = DisplaySidePanel.b();
            if (displaySidePanel != null) {
                displaySidePanel.c();
            }
        });
        return this;
    }

    private BinningState rebinSeries(ViewController viewController, BinningState binningState, LoaderDataProvider loaderDataProvider) {
        Session session = f.a().f();
        Session session2 = bm.a(session);
        BinningParams binningParams = new BinningParams(BinningTarget.getPhasePercentageBins(new float[]{0.0f}), binningState.params.getRPM(), TargetType.PHASE, false);
        a a2 = new a();
        a2.a(viewController);
        a2.a(loaderDataProvider);
        a2.a(session2);
        ViewController viewController2 = a2.a(binningParams, new o());
        return BinningStateManager.getBinningState(viewController2);
    }

    private Map<SlabInfo, SlabRPM> getRPMDicomBackingMap(BinningState binningState) {
        List<SlabInfo> list = binningState.getDataMap().getAllDicom();
        TreeMap treeMap = Maps.newTreeMap((slabInfo, slabInfo2) -> Integer.compare(System.identityHashCode(slabInfo), System.identityHashCode(slabInfo2)));
        list.forEach(slabInfo -> treeMap.put(slabInfo, binningState.getDataMap().lookup((SlabInfo)slabInfo)));
        HashSet hashSet = Sets.newHashSet();
        list.forEach(hashSet::addAll);
        return treeMap;
    }

    private LoaderDataProvider getDataProvider(ViewController viewController, BinningState binningState) {
        Object object;
        SeriesRef seriesRef = binningState.cache.getSeries();
        Optional<SearchSource> optional = Optional.ofNullable(viewController.bJ());
        if (optional.isPresent() && (object = this.pickProvider(Lists.newArrayList((Object[])new SearchSource[]{optional.get()}), seriesRef)) != null) {
            return object;
        }
        object = f.a().b();
        SearchSource searchSource = f.a().c();
        List<SearchSource> list = this.getSortedSources(searchSource, optional, (List<SearchSource>)object);
        LoaderDataProvider loaderDataProvider = this.pickProvider(list, seriesRef);
        return loaderDataProvider;
    }

    private List<SearchSource> getSortedSources(SearchSource searchSource2, Optional<SearchSource> optional, List<SearchSource> list) {
        Set<String> set = Collections.emptySet();
        Set<Integer> set2 = Collections.emptySet();
        optional.ifPresent(searchSource -> {
            set2.add(searchSource.I());
            Optional.ofNullable(searchSource.j()).ifPresent(set::add);
        });
        return VolumeRestorer.a(searchSource2, set, set2, list);
    }

    private LoaderDataProvider pickProvider(Iterable<SearchSource> iterable, SeriesRef seriesRef) {
        SeriesParameters seriesParameters = new SeriesParameters();
        seriesParameters.searchType = 7;
        seriesParameters.uidList = Lists.newArrayList((Object[])new String[]{seriesRef.seriesUID});
        for (SearchSource searchSource : iterable) {
            ReferencedSeriesFinder referencedSeriesFinder = new ReferencedSeriesFinder(searchSource, seriesParameters);
            referencedSeriesFinder.setThrowXcpIfNoResultsFound(false);
            try {
                List<DcmSeries> list;
                if (!referencedSeriesFinder.findReferencedSeries() || (list = referencedSeriesFinder.getSeriesFound()) == null || list.isEmpty()) continue;
                for (DcmSeries dcmSeries : list) {
                    if (!this.isCorrectSeries(dcmSeries, seriesRef)) continue;
                    return dcmSeries.getDataProvider();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                ay.c((Object)("source bungled the search: " + searchSource), this);
            }
        }
        return null;
    }

    private boolean isCorrectSeries(DcmSeries dcmSeries, SeriesRef seriesRef) {
        if (!seriesRef.seriesUID.equals(dcmSeries.getSeriesInstanceUID())) {
            return false;
        }
        List<UIDContainer.SOPInstanceUID> list = dcmSeries.getAllSopInstanceUids();
        if (list != null) {
            return list.containsAll((Collection<?>)seriesRef.sops);
        }
        return VolumeRestorer.a(dcmSeries, seriesRef.sops);
    }

    private void listenTo(Session session) {
        session.a(new bu(){

            @Override
            public void viewStateRemovedFromSession(ViewController viewController) {
                VCRef vCRef = VCRef.a(viewController);
                BinningStateManager.this.states.remove(vCRef);
            }
        });
    }
}

