/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.binning;

import com.google.common.collect.Lists;
import com.mimvista.dicom.binning.RPMLoader;
import com.mimvista.dicom.binning.SlabRPM;
import com.mimvista.preferencesNew.BinningPrefs;
import com.mimvista.util.NumberFormatFactory;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public abstract class BinningTarget
implements Serializable {
    private static final long serialVersionUID = 1L;

    public abstract double badness(SlabRPM var1);

    public abstract double getTargetValue();

    public abstract String getTargetDescription();

    public abstract double getBadnessThreshold();

    public SlabRPM selectBest(Iterable<SlabRPM> iterable) {
        double d2 = Double.MAX_VALUE;
        SlabRPM slabRPM = null;
        double d3 = Double.MAX_VALUE;
        SlabRPM slabRPM2 = null;
        for (SlabRPM slabRPM3 : iterable) {
            RPMLoader.Validity validity = slabRPM3.middle().validity;
            boolean bl2 = validity == RPMLoader.Validity.VALID | validity == RPMLoader.Validity.APERIODIC;
            double d4 = this.badness(slabRPM3);
            if (d4 < d2 && bl2) {
                slabRPM = slabRPM3;
                d2 = d4;
            }
            if (!(d4 < d3)) continue;
            slabRPM2 = slabRPM3;
            d3 = d4;
        }
        return slabRPM == null ? slabRPM2 : slabRPM;
    }

    static List<BinningTarget> getPhasePercentageBins(Float ... floatArray) {
        float[] fArray = new float[floatArray.length];
        for (int i2 = 0; i2 < floatArray.length; ++i2) {
            fArray[i2] = floatArray[i2].floatValue();
        }
        return BinningTarget.getPhasePercentageBins(fArray);
    }

    public static List<BinningTarget> getPhasePercentageBins(float ... fArray) {
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)fArray.length);
        for (float f2 : fArray) {
            arrayList.add(new PhasePercentageTarget(f2));
        }
        return arrayList;
    }

    public static List<BinningTarget> getAmplitudePercentageBins(RPMLoader.RPMInfo rPMInfo, Float ... floatArray) {
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)floatArray.length);
        Float[] floatArray2 = floatArray;
        int n2 = floatArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            float f2 = floatArray2[i2].floatValue();
            double d2 = Math.abs(f2);
            RPMLoader.Direction direction = f2 >= 0.0f ? RPMLoader.Direction.EXHALE : RPMLoader.Direction.INHALE;
            arrayList.add(new SemiDirectionalAmplitudeTarget(direction, d2, rPMInfo));
        }
        return arrayList;
    }

    static class SemiDirectionalAmplitudeTarget
    extends AmplitudeTarget {
        private static final long serialVersionUID = 1L;

        SemiDirectionalAmplitudeTarget(RPMLoader.Direction direction, double d2, RPMLoader.RPMInfo rPMInfo) {
            super(direction, d2, rPMInfo);
        }

        @Override
        public double badness(SlabRPM slabRPM) {
            double d2 = this.getAmplitudePercentage(slabRPM);
            double d3 = SemiDirectionalAmplitudeTarget.diff(d2, this.targetPercentage);
            return d3;
        }

        @Override
        public double getBadnessThreshold() {
            return (double)BinningPrefs.discrepancyThresholdAmplitude.getValue().floatValue() * Math.PI;
        }

        static double diff(double d2, double d3) {
            return PhasePercentageTarget.phaseDifference(d2 * Math.PI, d3 * Math.PI);
        }
    }

    static class DirectionyAmplitudeTarget
    extends AmplitudeTarget {
        private static final long serialVersionUID = 1L;

        public DirectionyAmplitudeTarget(RPMLoader.Direction direction, double d2, RPMLoader.RPMInfo rPMInfo) {
            super(direction, d2, rPMInfo);
        }

        @Override
        public double badness(SlabRPM slabRPM) {
            double d2 = this.getAmplitudePercentage(slabRPM);
            return this.targetPercentage == 0.0 || Math.signum(d2) == Math.signum(this.targetPercentage) ? Math.abs(d2 - this.targetPercentage) : Double.MAX_VALUE;
        }

        @Override
        public double getBadnessThreshold() {
            return BinningPrefs.discrepancyThresholdAmplitude.getValue().floatValue();
        }
    }

    static abstract class AmplitudeTarget
    extends BinningTarget {
        private static final long serialVersionUID = 1L;
        protected final double targetPercentage;
        protected final double min;
        protected final double max;

        AmplitudeTarget(double d2, double d3, double d4) {
            this.targetPercentage = d2;
            this.max = d4;
            this.min = d3;
        }

        @Override
        public double getTargetValue() {
            return this.targetPercentage;
        }

        @Override
        public String getTargetDescription() {
            return NumberFormatFactory.a().format(this.targetPercentage);
        }

        public AmplitudeTarget(RPMLoader.Direction direction, double d2, RPMLoader.RPMInfo rPMInfo) {
            double d3 = Double.MAX_VALUE;
            double d4 = -1.7976931348623157E308;
            for (RPMLoader.RPMInfo rPMInfo2 : rPMInfo.extractTTLSegments()) {
                for (RPMLoader.RPMPacket rPMPacket : rPMInfo2.data) {
                    if (rPMPacket.amplitude > d4) {
                        d4 = rPMPacket.amplitude;
                    }
                    if (!(rPMPacket.amplitude < d3)) continue;
                    d3 = rPMPacket.amplitude;
                }
            }
            this.min = d3;
            this.max = d4;
            this.targetPercentage = d2 * (double)(direction == RPMLoader.Direction.INHALE ? -1 : 1);
        }

        double getAmplitudePercentage(SlabRPM slabRPM) {
            RPMLoader.RPMPacket rPMPacket = slabRPM.middle();
            return (rPMPacket.amplitude - this.min) / (this.max - this.min) * (double)(rPMPacket.direction == RPMLoader.Direction.INHALE ? -1 : 1);
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            long l2 = Double.doubleToLongBits(this.max);
            n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
            l2 = Double.doubleToLongBits(this.min);
            n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
            l2 = Double.doubleToLongBits(this.targetPercentage);
            n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            AmplitudeTarget amplitudeTarget = (AmplitudeTarget)object;
            if (Double.doubleToLongBits(this.max) != Double.doubleToLongBits(amplitudeTarget.max)) {
                return false;
            }
            if (Double.doubleToLongBits(this.min) != Double.doubleToLongBits(amplitudeTarget.min)) {
                return false;
            }
            return Double.doubleToLongBits(this.targetPercentage) == Double.doubleToLongBits(amplitudeTarget.targetPercentage);
        }
    }

    public static class PhasePercentageTarget
    extends BinningTarget {
        private static final long serialVersionUID = 1L;
        private static final DecimalFormat format = new DecimalFormat("###.##%");
        private final double targetPercentage;

        PhasePercentageTarget(double d2) {
            if (!(0.0 <= d2) || !(d2 <= 1.0)) {
                throw new IllegalArgumentException("phase percentage must be in [0, 1]");
            }
            this.targetPercentage = d2;
        }

        @Override
        public double badness(SlabRPM slabRPM) {
            return PhasePercentageTarget.phaseDifference(this.targetPercentage * 2.0 * Math.PI, slabRPM.middle().phase);
        }

        @Override
        public double getBadnessThreshold() {
            return (double)(BinningPrefs.discrepancyThresholdPhase.getValue().floatValue() * 2.0f) * Math.PI;
        }

        @Override
        public double getTargetValue() {
            return this.targetPercentage;
        }

        @Override
        public String getTargetDescription() {
            return format.format(this.targetPercentage);
        }

        static double phaseDifference(double d2, double d3) {
            double d4 = Math.abs(d2 - d3) % (Math.PI * 2);
            return d4 <= Math.PI ? d4 : Math.PI * 2 - d4;
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            long l2 = Double.doubleToLongBits(this.targetPercentage);
            n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            PhasePercentageTarget phasePercentageTarget = (PhasePercentageTarget)object;
            return Double.doubleToLongBits(this.targetPercentage) == Double.doubleToLongBits(phasePercentageTarget.targetPercentage);
        }
    }
}

