/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.binning;

import com.google.common.collect.Lists;
import com.mimvista.dicom.UIDContainer;
import com.mimvista.dicom.binning.BinningCostFunction;
import com.mimvista.dicom.binning.BinningParams;
import com.mimvista.dicom.binning.BinningTarget;
import com.mimvista.dicom.binning.OptimalVolumeBinner;
import com.mimvista.dicom.binning.RPMDicomMap;
import com.mimvista.dicom.binning.SimpleVolumeBinner;
import com.mimvista.dicom.binning.SliceCache;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.numerics.ImageCube;
import com.mimvista.viewer.SeriesInfo;
import java.util.ArrayList;
import java.util.List;

public abstract class DynamicVolumeBinner {
    final BinningParams params;

    DynamicVolumeBinner(BinningParams binningParams) {
        this.params = binningParams;
    }

    public static DynamicVolumeBinner create(SliceCache sliceCache, BinningParams binningParams) {
        return binningParams.correction ? DynamicVolumeBinner.getGraphyBinner(sliceCache, binningParams) : new SimpleVolumeBinner(binningParams);
    }

    abstract List<List<SliceInfo>> bin(RPMDicomMap var1, Iterable<BinningTarget> var2);

    public List<ImageVolumeShort> bin(SliceCache sliceCache) {
        this.params.dataMap = RPMDicomMap.build(sliceCache, this.params.rpmFile);
        List<List<SliceInfo>> list = this.bin(this.params.dataMap, this.params.targets);
        ArrayList arrayList = Lists.newArrayList();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ImageVolumeShort imageVolumeShort = this.makeVol(sliceCache, list.get(i2));
            SeriesInfo seriesInfo = imageVolumeShort.getUncopiedMutableInfo();
            seriesInfo.binnedInMIM = true;
            seriesInfo.seriesNumber = String.valueOf(i2);
            seriesInfo.binNum = i2 + 1;
            seriesInfo.numOfBins = list.size();
            seriesInfo.frameDesc = seriesInfo.binDesc = this.params.targets.get(i2).getTargetDescription();
            seriesInfo.seriesDesc = "[" + this.params.mode.toString() + (this.params.correction ? " * ] " : "] ");
            arrayList.add(imageVolumeShort);
        }
        return arrayList;
    }

    private ImageVolumeShort makeVol(SliceCache sliceCache, List<SliceInfo> list) {
        ImageVolumeShort imageVolumeShort = sliceCache.makeVol();
        SliceInfo sliceInfo = list.get(0);
        int[] nArray = new int[]{sliceInfo.width, sliceInfo.height, list.size()};
        imageVolumeShort.a(ImageCube.ImageCubeShort.a(nArray, 0));
        for (SliceInfo sliceInfo2 : list) {
            ((ImageCube.ImageCubeShort)imageVolumeShort.ad()).a(sliceCache.getSliceData(new UIDContainer.SeriesUID(imageVolumeShort.I().ag()), new UIDContainer.SOPInstanceUID(sliceInfo2.sopInstanceUID)));
        }
        ((SimpleImageVolume)imageVolumeShort).a(Lists.newArrayList(list));
        return imageVolumeShort;
    }

    private static OptimalVolumeBinner getGraphyBinner(SliceCache sliceCache, BinningParams binningParams) {
        BinningCostFunction binningCostFunction = BinningCostFunction.getCorrelationCostFunction();
        return new OptimalVolumeBinner(binningParams, binningCostFunction.getEvaluator(sliceCache));
    }
}

