/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.binning;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mimvista.dicom.binning.BinningParams;
import com.mimvista.dicom.binning.BinningTarget;
import com.mimvista.dicom.binning.DynamicVolumeBinner;
import com.mimvista.dicom.binning.RPMDicomMap;
import com.mimvista.dicom.binning.SlabInfo;
import com.mimvista.dicom.binning.SlabRPM;
import com.mimvista.internals.SliceInfo;
import com.mimvista.numerics.AStar;
import com.mimvista.numerics.ap;
import com.mimvista.numerics.e;
import com.mimvista.numerics.v;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OptimalVolumeBinner
extends DynamicVolumeBinner {
    public static final boolean allowHoles = false;
    private final e<SlabInfo, SlabInfo, Double> costFunction;

    public OptimalVolumeBinner(BinningParams binningParams, e<SlabInfo, SlabInfo, Double> e2) {
        super(binningParams);
        this.costFunction = e2;
    }

    @Override
    List<List<SliceInfo>> bin(RPMDicomMap rPMDicomMap, Iterable<BinningTarget> iterable) {
        ArrayList arrayList = Lists.newArrayList();
        for (BinningTarget binningTarget : iterable) {
            v<SlabInfo> v2 = this.buildGraphFor(rPMDicomMap, binningTarget, iterable);
            arrayList.add(this.getBestVol(v2));
        }
        return arrayList;
    }

    private List<SliceInfo> getBestVol(v<SlabInfo> v2) {
        SlabInfo slabInfo = new SlabInfo();
        SlabInfo slabInfo2 = new SlabInfo();
        for (SlabInfo arrayList2 : v2.a()) {
            v2.a(slabInfo);
            v2.a(slabInfo, arrayList2, 0.1);
        }
        for (SlabInfo slabInfo3 : v2.b()) {
            v2.a(slabInfo2);
            v2.a(slabInfo3, slabInfo2, 0.1);
        }
        Iterable<SlabInfo> iterable = v2.a(slabInfo, slabInfo2, new AStar());
        v2.b(slabInfo);
        v2.b(slabInfo2);
        ArrayList arrayList = Lists.newArrayList((Iterable)iterable);
        ArrayList arrayList2 = Lists.newArrayList();
        for (SlabInfo slabInfo4 : arrayList.subList(1, arrayList.size() - 1)) {
            arrayList2.addAll(slabInfo4);
        }
        return arrayList2;
    }

    private v<SlabInfo> buildGraphFor(RPMDicomMap rPMDicomMap, BinningTarget binningTarget, Iterable<BinningTarget> iterable) {
        ap<SlabInfo> ap2 = ap.a(this.costFunction);
        Set<SlabInfo> set = this.getAcquisitionsForTarget(rPMDicomMap, binningTarget, iterable);
        HashMap hashMap = Maps.newHashMap();
        ArrayList arrayList = Lists.newArrayList(rPMDicomMap.getAcquisitionNumbers());
        ArrayList arrayList2 = Lists.newArrayListWithCapacity((int)arrayList.size());
        for (Integer n2 : arrayList) {
            Sets.SetView setView = Sets.intersection(set, rPMDicomMap.getDicomForAcquisitionNumber(n2));
            if (setView.isEmpty()) {
                throw new IllegalStateException("Can't be having holes when we aren't allowing holes.  Shouldn't be possible anyways.");
            }
            arrayList2.add(setView);
        }
        for (int i2 = 0; i2 < arrayList.size() - 1; ++i2) {
            boolean bl2 = hashMap.containsKey(arrayList.get(i2)) || hashMap.containsKey(arrayList.get(i2 + 1));
            for (List list : Sets.cartesianProduct((Set[])new Set[]{(Set)arrayList2.get(i2), (Set)arrayList2.get(i2 + 1)})) {
                ap2.a((SlabInfo)list.get(0));
                ap2.a((SlabInfo)list.get(1));
                if (bl2) {
                    ap2.a((SlabInfo)list.get(0), (SlabInfo)list.get(1), 0.1);
                    continue;
                }
                ap2.b((SlabInfo)list.get(0), (SlabInfo)list.get(1));
            }
        }
        return ap2;
    }

    private Set<SlabInfo> getAcquisitionsForTarget(RPMDicomMap rPMDicomMap, BinningTarget binningTarget, Iterable<BinningTarget> iterable) {
        HashSet hashSet = Sets.newHashSet();
        for (Integer n2 : rPMDicomMap.getAcquisitionNumbers()) {
            for (SlabInfo slabInfo : rPMDicomMap.getDicomForAcquisitionNumber(n2)) {
                if (binningTarget != this.getBestTarget(iterable, rPMDicomMap.lookup(slabInfo))) continue;
                hashSet.add(slabInfo);
            }
            SlabRPM slabRPM = binningTarget.selectBest(rPMDicomMap.getRPMForAcquisitionNumber(n2));
            hashSet.add(rPMDicomMap.lookup(slabRPM));
        }
        return hashSet;
    }

    private BinningTarget getBestTarget(Iterable<BinningTarget> iterable, SlabRPM slabRPM) {
        double d2 = Double.MAX_VALUE;
        BinningTarget binningTarget = null;
        for (BinningTarget binningTarget2 : iterable) {
            double d3;
            double d4 = binningTarget2.badness(slabRPM);
            if (!(d3 < d2)) continue;
            d2 = d4;
            binningTarget = binningTarget2;
        }
        return binningTarget;
    }
}

