/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.binning;

import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.mimvista.dicom.binning.BadRPMException;
import com.mimvista.dicom.binning.BadTTLException;
import com.mimvista.dicom.binning.RPMLoader;
import com.mimvista.dicom.binning.SlabInfo;
import com.mimvista.dicom.binning.SlabRPM;
import com.mimvista.dicom.binning.SliceCache;
import com.mimvista.internals.SliceInfo;
import com.mimvista.util.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class RPMDicomMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    final ImmutableBiMap<SlabInfo, SlabRPM> map;
    final ImmutableMap<SliceInfo, SlabInfo> dicomMap;
    final ImmutableMultimap<RPMLoader.RPMPacket, SlabRPM> rpmMap;
    final RPMLoader.RPMInfo rpm;

    public static RPMDicomMap build(SliceCache sliceCache, RPMLoader.RPMInfo rPMInfo) {
        List<SliceInfo> list = sliceCache.getAllInfos();
        ArrayListMultimap<Integer, SlabInfo> arrayListMultimap = RPMDicomMap.separateAcquisitions(list);
        ImmutableList<RPMLoader.RPMInfo> immutableList = rPMInfo.extractTTLSegments();
        ArrayList arrayList = Lists.newArrayList((Iterable)arrayListMultimap.keySet());
        Collections.sort(arrayList);
        int n2 = arrayList.size();
        if (n2 != immutableList.size()) {
            rPMInfo = RPMDicomMap.correctRPMChunks(n2, rPMInfo);
            immutableList = rPMInfo.extractTTLSegments();
        }
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = (Integer)arrayList.get(i2);
            List list2 = arrayListMultimap.get((Object)n3);
            long l2 = Long.parseLong(sliceCache.getExposureTime());
            List<SlabRPM> list3 = ((RPMLoader.RPMInfo)immutableList.get(i2)).splitImages(list2.size(), l2);
            if (list2.size() != list3.size()) {
                throw new BadRPMException("RPM failed to match");
            }
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                SlabRPM slabRPM = new SlabRPM(Lists.newArrayList((Iterable)list3.get(i3)));
                if (linkedHashMap.put(list2.get(i3), slabRPM) == null) continue;
                throw new IllegalArgumentException("Can't re-add slices");
            }
        }
        return new RPMDicomMap(linkedHashMap, rPMInfo);
    }

    @Deprecated
    public RPMDicomMap(Map<SlabInfo, SlabRPM> map, RPMLoader.RPMInfo rPMInfo) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableMultimap.Builder builder2 = ImmutableMultimap.builder();
        for (Map.Entry<SlabInfo, SlabRPM> entry : map.entrySet()) {
            for (Serializable serializable : entry.getKey()) {
                builder.put((Object)serializable, (Object)entry.getKey());
            }
            for (Serializable serializable : entry.getValue()) {
                builder2.put((Object)serializable, (Object)entry.getValue());
            }
        }
        this.map = ImmutableBiMap.copyOf(map);
        this.dicomMap = builder.build();
        this.rpmMap = builder2.build();
        this.rpm = rPMInfo;
    }

    public RPMDicomMap reverseSlabs() {
        HashMap hashMap = Maps.newHashMap();
        for (Map.Entry entry : this.map.entrySet()) {
            SlabInfo slabInfo = new SlabInfo(Lists.reverse((List)((List)entry.getKey())));
            SlabRPM slabRPM = (SlabRPM)entry.getValue();
            hashMap.put(slabInfo, slabRPM);
        }
        return new RPMDicomMap(hashMap, this.rpm);
    }

    public Set<SlabInfo> getDicomForAcquisitionNumber(final int n2) {
        ImmutableSet immutableSet = this.map.keySet();
        return Collections.unmodifiableSet(Sets.filter((Set)immutableSet, (Predicate)new Predicate<SlabInfo>(){

            public boolean apply(SlabInfo slabInfo) {
                return slabInfo.getAcquisitionNumber() == n2;
            }
        }));
    }

    public Set<SlabRPM> getRPMForAcquisitionNumber(final int n2) {
        BiMap biMap = Maps.filterKeys(this.map, (Predicate)new Predicate<SlabInfo>(){

            public boolean apply(SlabInfo slabInfo) {
                return slabInfo.getAcquisitionNumber() == n2;
            }
        });
        return Collections.unmodifiableSet(biMap.values());
    }

    public List<SlabInfo> getAllDicom() {
        ArrayList arrayList = Lists.newArrayList((Iterable)this.map.keySet());
        Collections.sort(arrayList, new Comparator<SlabInfo>(){

            @Override
            public int compare(SlabInfo slabInfo, SlabInfo slabInfo2) {
                return slabInfo.getFirst().sliceNumber - slabInfo2.getFirst().sliceNumber;
            }
        });
        return Collections.unmodifiableList(arrayList);
    }

    public List<SlabRPM> getAllRPM() {
        ArrayList arrayList = Lists.newArrayList((Iterable)this.map.values());
        Collections.sort(arrayList, Comparator.comparing(slabRPM -> slabRPM.start().time));
        return Collections.unmodifiableList(arrayList);
    }

    public RPMLoader.RPMInfo getRPMInfo() {
        return this.rpm;
    }

    public SortedSet<Integer> getAcquisitionNumbers() {
        TreeSet treeSet = Sets.newTreeSet();
        for (SlabInfo slabInfo : this.map.keySet()) {
            treeSet.add(slabInfo.getAcquisitionNumber());
        }
        return Collections.unmodifiableSortedSet(treeSet);
    }

    public SlabRPM lookup(SlabInfo slabInfo) {
        return (SlabRPM)this.map.get((Object)slabInfo);
    }

    public SlabInfo lookup(SlabRPM slabRPM) {
        return (SlabInfo)this.map.inverse().get((Object)slabRPM);
    }

    public SlabInfo getSlab(SliceInfo sliceInfo) {
        return (SlabInfo)this.dicomMap.get((Object)sliceInfo);
    }

    public ImmutableList<SlabRPM> getSlabs(RPMLoader.RPMPacket rPMPacket) {
        return this.rpmMap.get((Object)rPMPacket).asList();
    }

    public int getAcquisitionNumber(RPMLoader.RPMPacket rPMPacket) {
        SlabRPM slabRPM = (SlabRPM)this.rpmMap.get((Object)rPMPacket).iterator().next();
        return ((SlabInfo)this.map.inverse().get((Object)slabRPM)).getAcquisitionNumber();
    }

    private static RPMLoader.RPMInfo correctRPMChunks(int n2, RPMLoader.RPMInfo rPMInfo) {
        ImmutableList<RPMLoader.RPMInfo> immutableList = rPMInfo.extractTTLSegments();
        Pair<Integer, Integer> pair = RPMDicomMap.getMinMaxChunkSizes(immutableList);
        RPMLoader.RPMInfo rPMInfo2 = rPMInfo.mergeChunksSeparatedByAtMost(1);
        ImmutableList<RPMLoader.RPMInfo> immutableList2 = rPMInfo2.extractTTLSegments();
        Pair<Integer, Integer> pair2 = RPMDicomMap.getMinMaxChunkSizes(immutableList2);
        if ((Integer)pair2.y - (Integer)pair.y < 5 && (Integer)pair2.y - (Integer)pair2.x < 5 && n2 == immutableList2.size()) {
            return rPMInfo2;
        }
        throw new BadTTLException("Uncorrectable TTL");
    }

    private static Pair<Integer, Integer> getMinMaxChunkSizes(List<RPMLoader.RPMInfo> list) {
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            int n4 = list.get((int)i2).data.size();
            n2 = Math.max(n4, n2);
            n3 = Math.min(n4, n3);
        }
        return Pair.get(n3, n2);
    }

    private static ArrayListMultimap<Integer, SlabInfo> separateAcquisitions(Iterable<SliceInfo> iterable) {
        ImmutableListMultimap immutableListMultimap = Multimaps.index(iterable, sliceInfo -> Integer.parseInt(sliceInfo.acquisitionNumber));
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        for (Map.Entry entry : immutableListMultimap.asMap().entrySet()) {
            List list = Ordering.natural().onResultOf(sliceInfo -> Integer.valueOf(sliceInfo.sliceNumber)).sortedCopy((Iterable)entry.getValue());
            List<SlabInfo> list2 = RPMDicomMap.buildSlabs(list);
            arrayListMultimap.putAll(entry.getKey(), list2);
        }
        return arrayListMultimap;
    }

    private static List<SlabInfo> buildSlabs(List<SliceInfo> list) {
        ArrayList arrayList = Lists.newArrayList();
        SlabInfo slabInfo = new SlabInfo(list.get(0));
        boolean bl2 = list.get((int)0).slicePosition < list.get((int)1).slicePosition;
        for (int i2 = 1; i2 < list.size(); ++i2) {
            if (list.get((int)i2).slicePosition < list.get((int)(i2 - 1)).slicePosition ^ bl2) {
                slabInfo.add(list.get(i2));
                continue;
            }
            arrayList.add(slabInfo);
            slabInfo = new SlabInfo(list.get(i2));
        }
        arrayList.add(slabInfo);
        return arrayList;
    }
}

