/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.binning;

import com.google.common.base.Charsets;
import com.google.common.base.Enums;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.io.Files;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import com.mimvista.dicom.binning.BadRPMException;
import com.mimvista.dicom.binning.BadTimingException;
import com.mimvista.dicom.binning.SlabRPM;
import com.mimvista.numerics.MathUtils;
import com.mimvista.util.ay;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RPMLoader {
    private static final double sampleRateTolerance = 0.03;
    private static final double studyDurationTolerance = 0.03;
    private static final double samplePeriodTolerance = 1.0;

    public static RPMInfo load(File file) {
        String string = null;
        try {
            if (RPMLoader.isGoodToGo(file)) {
                Object object;
                Iterator<String> iterator = Files.readLines((File)file, (Charset)Charsets.UTF_8).iterator();
                ArrayList arrayList = Lists.newArrayList();
                RPMHeaderInfo rPMHeaderInfo = new RPMHeaderInfo(iterator);
                ImmutableMap<RPMDataTag, Integer> immutableMap = rPMHeaderInfo.getDataLayout();
                String string2 = null;
                try {
                    while (iterator.hasNext()) {
                        string = iterator.next();
                        object = new RPMPacket.Builder();
                        String[] stringArray = string.split(",");
                        if (stringArray.length != immutableMap.size()) {
                            if (stringArray.length < 5 && !iterator.hasNext()) continue;
                            throw new BadRPMException("Malformed RPM: data doesn't match header for line: " + string);
                        }
                        ((RPMPacket.Builder)object).setAmplitude(Double.parseDouble(stringArray[(Integer)immutableMap.get((Object)RPMDataTag.amplitude)]) * rPMHeaderInfo.getScaleFactorInCM());
                        ((RPMPacket.Builder)object).setPhase(Double.parseDouble(stringArray[(Integer)immutableMap.get((Object)RPMDataTag.phase)]));
                        ((RPMPacket.Builder)object).setTime((long)Double.parseDouble(stringArray[(Integer)immutableMap.get((Object)RPMDataTag.timestamp)]));
                        ((RPMPacket.Builder)object).setValid(Validity.from(Integer.parseInt(stringArray[(Integer)immutableMap.get((Object)RPMDataTag.validflag)])));
                        ((RPMPacket.Builder)object).setTTLin(Integer.parseInt(stringArray[(Integer)immutableMap.get((Object)RPMDataTag.ttlin)]) == 0);
                        String string3 = stringArray[(Integer)immutableMap.get((Object)RPMDataTag.mark)];
                        if (!string3.isEmpty()) {
                            string2 = string3;
                        }
                        ((RPMPacket.Builder)object).setDirection(Direction.from(string2));
                        arrayList.add(((RPMPacket.Builder)object).build());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new BadRPMException("Malformed RPM: malformed data on line: " + string);
                }
                object = new RPMInfo(arrayList, rPMHeaderInfo);
                return object;
            }
            throw new BadRPMException("invalid rpm");
        }
        catch (BadRPMException badRPMException) {
            throw badRPMException;
        }
        catch (Exception exception) {
            throw new BadRPMException(exception);
        }
    }

    public static boolean matchesSeriesInfo(Date date, String string, File file) {
        try {
            Iterator<String> iterator = Files.readLines((File)file, (Charset)Charsets.UTF_8).iterator();
            RPMHeaderInfo rPMHeaderInfo = new RPMHeaderInfo(iterator);
            Date date2 = rPMHeaderInfo.getDate();
            String string2 = rPMHeaderInfo.getPatientID();
            return string2.equals(string) && date2.getYear() == date.getYear() && date2.getMonth() == date.getMonth() && date2.getDate() == date.getDate();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isGoodToGo(File file) {
        return file.canRead() && "vxp".equalsIgnoreCase(Files.getFileExtension((String)file.getName()));
    }

    public static class RPMPacket
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final long time;
        public final Validity validity;
        public final Direction direction;
        public final double frame;
        public final boolean ttl;
        public final double amplitude;
        public final double phase;

        private RPMPacket(long l2, Validity validity, Direction direction, double d2, boolean bl2, double d3, double d4) {
            this.time = l2;
            this.validity = validity;
            this.direction = direction;
            this.frame = d2;
            this.ttl = bl2;
            this.amplitude = d3;
            this.phase = d4;
        }

        RPMPacket flipTTL() {
            return new RPMPacket(this.time, this.validity, this.direction, this.frame, !this.ttl, this.amplitude, this.phase);
        }

        static RPMPacket interpolate(RPMPacket rPMPacket, RPMPacket rPMPacket2, float f2) {
            long l2 = rPMPacket.time + (long)(f2 * (float)(rPMPacket2.time - rPMPacket.time));
            Validity validity = rPMPacket.validity == rPMPacket2.validity ? rPMPacket.validity : null;
            Direction direction = f2 < 0.5f ? rPMPacket.direction : rPMPacket2.direction;
            double d2 = rPMPacket.frame == rPMPacket2.frame ? rPMPacket.frame : Double.NaN;
            boolean bl2 = rPMPacket.ttl ^ rPMPacket2.ttl ? false : rPMPacket.ttl;
            double d3 = rPMPacket.amplitude + (double)f2 * (rPMPacket2.amplitude - rPMPacket.amplitude);
            double d4 = (rPMPacket.phase + (double)f2 * (rPMPacket2.phase > rPMPacket.phase ? rPMPacket2.phase - rPMPacket.phase : Math.PI * 2 + rPMPacket2.phase - rPMPacket.phase)) % (Math.PI * 2);
            return new RPMPacket(l2, validity, direction, d2, bl2, d3, d4);
        }

        static RPMPacket average(RPMPacket ... rPMPacketArray) {
            return RPMPacket.average(Arrays.asList(rPMPacketArray));
        }

        static RPMPacket average(List<RPMPacket> list) {
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            boolean bl2 = true;
            for (RPMPacket rPMPacket : list) {
                d3 += Math.cos(rPMPacket.phase);
                d2 += Math.sin(rPMPacket.phase);
                d4 += rPMPacket.amplitude;
                bl2 &= rPMPacket.validity == Validity.VALID;
            }
            double d5 = (Math.PI * 2 + Math.atan2(d2 /= (double)list.size(), d3 /= (double)list.size())) % (Math.PI * 2);
            long l2 = list.get((int)(list.size() - 1)).time - list.get((int)0).time;
            long l3 = list.get((int)0).time + l2 / 2L;
            return new RPMPacket(l3, bl2 ? Validity.VALID : Validity.LOST, null, Double.NaN, false, d4 /= (double)list.size(), d5);
        }

        static double getSecondsBetween(RPMPacket rPMPacket, RPMPacket rPMPacket2) {
            return (double)(rPMPacket2.time - rPMPacket.time) * 0.001;
        }

        static class Builder {
            private long time = -1L;
            private Validity valid = null;
            private Direction direction = null;
            private double frame = Double.NaN;
            private boolean ttl = false;
            private double amplitude = Double.NaN;
            private double phase = Double.NaN;

            Builder() {
            }

            public Builder setTime(long l2) {
                this.time = l2;
                return this;
            }

            public Builder setValid(Validity validity) {
                this.valid = validity;
                return this;
            }

            public Builder setDirection(Direction direction) {
                this.direction = direction;
                return this;
            }

            public Builder setFrame(double d2) {
                this.frame = d2;
                return this;
            }

            public Builder setTTLin(boolean bl2) {
                this.ttl = bl2;
                return this;
            }

            public Builder setAmplitude(double d2) {
                this.amplitude = d2;
                return this;
            }

            public Builder setPhase(double d2) {
                this.phase = d2;
                return this;
            }

            public RPMPacket build() {
                return new RPMPacket(this.time, this.valid, this.direction, this.frame, this.ttl, this.amplitude, this.phase);
            }
        }
    }

    public static class RPMInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final ImmutableList<RPMPacket> data;
        public final RPMHeaderInfo header;

        public RPMInfo(List<RPMPacket> list, RPMHeaderInfo rPMHeaderInfo) {
            this.data = ImmutableList.builder().addAll((Iterable)Ordering.natural().onResultOf(rPMPacket -> Long.valueOf(rPMPacket.time)).sortedCopy(list)).build();
            this.header = rPMHeaderInfo;
        }

        public RPMPacket getClosestPacketOrNothing(long l2, long l3) {
            RPMPacket rPMPacket = this.getClosestPacket(l2);
            if (Math.abs(rPMPacket.time - l2) <= l3) {
                return rPMPacket;
            }
            return null;
        }

        public RPMPacket getClosestPacket(long l2) {
            return (RPMPacket)this.data.get(this.getClosestIndex(l2));
        }

        private int getClosestIndex(long l2) {
            int n2 = 0;
            int n3 = this.data.size() - 1;
            while (n3 >= n2) {
                int n4 = n2 + (n3 - n2) / 2;
                if (((RPMPacket)this.data.get((int)n4)).time == l2) {
                    return n4;
                }
                if (((RPMPacket)this.data.get((int)n4)).time < l2) {
                    n2 = n4 + 1;
                    continue;
                }
                if (((RPMPacket)this.data.get((int)n4)).time <= l2) continue;
                n3 = n4 - 1;
            }
            if (n3 < 0) {
                return 0;
            }
            if (n2 >= this.data.size()) {
                return this.data.size() - 1;
            }
            return ((RPMPacket)this.data.get((int)n2)).time - l2 < l2 - ((RPMPacket)this.data.get((int)n3)).time ? n2 : n3;
        }

        public ImmutableList<RPMInfo> extractBadTrackingSegments() {
            return this.extractSegments(new Predicate<RPMPacket>(){

                public boolean apply(RPMPacket rPMPacket) {
                    return rPMPacket.validity != Validity.VALID;
                }
            });
        }

        public ImmutableList<RPMInfo> extractTTLSegments() {
            return this.extractSegments(new Predicate<RPMPacket>(){

                public boolean apply(RPMPacket rPMPacket) {
                    return rPMPacket.ttl;
                }
            });
        }

        private ImmutableList<RPMInfo> extractSegments(Predicate<RPMPacket> predicate) {
            ImmutableList.Builder builder = ImmutableList.builder();
            ArrayList arrayList = Lists.newArrayList();
            for (RPMPacket rPMPacket : this.data) {
                if (predicate.apply((Object)rPMPacket)) {
                    arrayList.add(rPMPacket);
                    continue;
                }
                if (arrayList.isEmpty()) continue;
                builder.add((Object)new RPMInfo(arrayList, this.header));
                arrayList = Lists.newArrayList();
            }
            if (!arrayList.isEmpty()) {
                builder.add((Object)new RPMInfo(arrayList, this.header));
            }
            return builder.build();
        }

        public RPMPacket getFirstPacket() {
            return (RPMPacket)this.data.get(0);
        }

        public RPMPacket getLastPacket() {
            return (RPMPacket)this.data.get(this.data.size() - 1);
        }

        public RPMInfo mergeChunksSeparatedByAtMost(int n2) {
            Object object;
            ArrayList arrayList = Lists.newArrayList();
            ImmutableList<RPMInfo> immutableList = this.extractTTLSegments();
            for (int i2 = 0; i2 < immutableList.size() - 1; ++i2) {
                object = (RPMInfo)immutableList.get(i2);
                RPMInfo rPMInfo = (RPMInfo)immutableList.get(i2 + 1);
                int n3 = this.data.indexOf(((RPMInfo)object).data.get(((RPMInfo)object).data.size() - 1));
                int n4 = this.data.indexOf(rPMInfo.data.get(0));
                if (n4 - n3 > 1 + n2) continue;
                arrayList.add(this.data.indexOf(rPMInfo.data.get(0)) - 1);
            }
            ArrayList arrayList2 = Lists.newArrayList(this.data);
            object = arrayList.iterator();
            while (object.hasNext()) {
                int n5 = (Integer)object.next();
                arrayList2.set(n5, ((RPMPacket)arrayList2.get(n5)).flipTTL());
            }
            return new RPMInfo(arrayList2, this.header);
        }

        public List<SlabRPM> splitImages(int n2, long l2) {
            double d2 = ((RPMPacket)this.data.get((int)(this.data.size() - 1))).time;
            double d3 = ((RPMPacket)this.data.get((int)0)).time;
            double d4 = (d2 - d3 - (double)l2) / (double)(n2 - 1);
            if (d4 <= 0.0) {
                ay.d((Object)"Attempt to ignore inconsistent RPM timing has failed.  Aborting binning", this);
                throw new BadTimingException("RPM timing error cannot be ignored.");
            }
            ArrayList arrayList = Lists.newArrayListWithCapacity((int)n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = this.getClosestIndex(Math.round(d3 + d4 * (double)i2));
                int n4 = this.getClosestIndex(Math.round(d3 + d4 * (double)i2 + (double)l2));
                RPMPacket rPMPacket = this.getClosestPacket(Math.round(d3 + d4 * (double)i2 + 0.5 * (double)l2));
                SlabRPM slabRPM = new SlabRPM((Collection<RPMPacket>)this.data.subList(n3, n4 + 1));
                slabRPM.nominate(rPMPacket);
                arrayList.add(slabRPM);
            }
            return arrayList;
        }

        public void validate() throws BadTimingException {
            double d2 = this.header.getSamplesPerSecond();
            double d3 = this.header.getStudyDuration() * 1000.0;
            int n2 = this.data.size();
            double d4 = this.getLastPacket().time - this.getFirstPacket().time;
            if (!MathUtils.a(d4, d3, 0.03)) {
                ay.d((Object)String.format("RPM header inconsistent. Actual study duration = %f (s); expected %f (s)", d4, d3), this);
                throw new BadTimingException("Study duration doesn't match sample timestamps");
            }
            double d5 = (double)n2 / d4 * 1000.0;
            if (!MathUtils.a(d5, d2, 0.03)) {
                ay.d((Object)String.format("RPM header inconsistent. Actual sample rate = %f; expected %f", d5, d2), this);
                throw new BadTimingException("Study duration doesn't match sample rate and count");
            }
            double d6 = 1000.0 / d2;
            ImmutableList<RPMInfo> immutableList = this.extractTTLSegments();
            for (int i2 = this.data.indexOf((Object)((RPMInfo)immutableList.get(0)).getFirstPacket()); i2 < this.data.indexOf((Object)((RPMInfo)Iterables.getLast(immutableList)).getLastPacket()); ++i2) {
                if (!((double)(((RPMPacket)this.data.get((int)i2)).time - ((RPMPacket)this.data.get((int)(i2 - 1))).time) > d6 * 2.0)) continue;
                ay.d((Object)("RPM sample rate fluctuation exceeds tolerance at time " + ((RPMPacket)this.data.get((int)i2)).time), this);
                throw new BadTimingException("Excessive sample rate variation");
            }
        }
    }

    static class RPMHeaderInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final ImmutableMap<RPMHeaderTag, String> fullHeader;

        public RPMHeaderInfo(Iterator<String> iterator) {
            this.fullHeader = ImmutableMap.copyOf(this.readHeader(iterator));
            this.validate();
        }

        public ImmutableMap<RPMDataTag, Integer> getDataLayout() {
            EnumMap enumMap = Maps.newEnumMap(RPMDataTag.class);
            int n2 = -1;
            for (String string : ((String)this.fullHeader.get((Object)RPMHeaderTag.Data_layout)).split(",")) {
                enumMap.put(RPMDataTag.valueOf(string), ++n2);
            }
            return Maps.immutableEnumMap((Map)enumMap);
        }

        public RPMType getVersion() {
            String string = (String)this.fullHeader.get((Object)RPMHeaderTag.Version);
            if ("1.6".equals(string)) {
                return RPMType.VXP_1_6;
            }
            if ("1.5".equals(string)) {
                return RPMType.VXP_1_5;
            }
            if ("3.2A(GE)".equals(string)) {
                return RPMType.Anzai;
            }
            return null;
        }

        public String getPatientID() {
            return (String)this.fullHeader.get((Object)RPMHeaderTag.Patient_ID);
        }

        public long getCRC() {
            return Longs.tryParse((String)((String)this.fullHeader.get((Object)RPMHeaderTag.CRC)));
        }

        public double getSamplesPerSecond() {
            return Doubles.tryParse((String)((String)this.fullHeader.get((Object)RPMHeaderTag.Samples_per_second)));
        }

        public double getStudyDuration() {
            return Doubles.tryParse((String)((String)this.fullHeader.get((Object)RPMHeaderTag.Total_study_time)));
        }

        public Date getDate() {
            try {
                return new SimpleDateFormat("MM-dd-yyyy").parse((String)this.fullHeader.get((Object)RPMHeaderTag.Date));
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException(parseException);
            }
        }

        public double getScaleFactorInCM() {
            return Double.valueOf((String)this.fullHeader.get((Object)RPMHeaderTag.Scale_factor)) / 10.0;
        }

        private Map<RPMHeaderTag, String> readHeader(Iterator<String> iterator) {
            String[] stringArray;
            String string;
            EnumMap enumMap = Maps.newEnumMap(RPMHeaderTag.class);
            int n2 = 0;
            if (!"[Header]".equalsIgnoreCase(iterator.next())) {
                throw new BadRPMException("Malformed RPM header: header doesn't start");
            }
            while (!"[Data]".equalsIgnoreCase(string = iterator.next())) {
                if (++n2 > 10) {
                    throw new BadRPMException("Malformed RPM header: header fails to end");
                }
                stringArray = string.split("=", 2);
                Optional optional = Enums.getIfPresent(RPMHeaderTag.class, (String)stringArray[0]);
                if (stringArray.length != 2 || !optional.isPresent()) {
                    throw new BadRPMException("Malformed RPM header: header contains invalid line");
                }
                enumMap.put(optional.get(), stringArray[1]);
            }
            stringArray = Lists.newArrayList((Object[])RPMHeaderTag.values());
            stringArray.remove(RPMHeaderTag.CRC);
            if (!enumMap.keySet().containsAll((Collection<?>)stringArray)) {
                throw new BadRPMException("Malformed RPM header: header incomplete");
            }
            return enumMap;
        }

        private void validate() {
            try {
                this.getDate();
                this.getScaleFactorInCM();
                this.getVersion();
                this.getDataLayout();
                this.getSamplesPerSecond();
                this.getStudyDuration();
            }
            catch (Exception exception) {
                throw new BadRPMException("Malformed RPM header: header contains invalid line");
            }
            ArrayList arrayList = Lists.newArrayList((Object[])RPMDataTag.values());
            arrayList.remove((Object)RPMDataTag.ttlout);
            if (!this.getDataLayout().keySet().containsAll((Collection)arrayList)) {
                throw new BadRPMException("Malformed RPM header: header incomplete");
            }
        }
    }

    static enum RPMType {
        VXP_1_5,
        VXP_1_6,
        Anzai;

    }

    static enum RPMDataTag {
        amplitude,
        phase,
        timestamp,
        validflag,
        ttlin,
        mark,
        ttlout;

    }

    static enum RPMHeaderTag implements Serializable
    {
        CRC,
        Version,
        Data_layout,
        Patient_ID,
        Date,
        Total_study_time,
        Samples_per_second,
        Scale_factor;

    }

    static enum GateType {
        AMPLITUDE,
        PHASE;

    }

    public static enum Direction {
        INHALE,
        EXHALE;


        public static Direction from(String string) {
            if ("Z".equals(string)) {
                return EXHALE;
            }
            if ("P".equals(string)) {
                return INHALE;
            }
            return null;
        }
    }

    public static enum Validity {
        VALID,
        LOST,
        APERIODIC;


        public static Validity from(int n2) {
            switch (n2) {
                case -2: {
                    return APERIODIC;
                }
                case -1: {
                    return LOST;
                }
            }
            return VALID;
        }
    }
}

