/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.binning;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mimvista.dicom.UIDContainer;
import com.mimvista.dicom.binning.BinningState;
import com.mimvista.dicom.binning.BinningStateManager;
import com.mimvista.dicom.binning.RPMLoader;
import com.mimvista.dicom.binning.SlabInfo;
import com.mimvista.dicom.binning.SlabRPM;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.VolRef;
import com.mimvista.internals.linking.ViewLink;
import com.mimvista.internals.p;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.mui.layout.CustomView;
import com.mimvista.mui.layout.CustomViewPanel;
import com.mimvista.mui.mouse.mode.g;
import com.mimvista.mui.p;
import com.mimvista.mui.presenters.ViewPort;
import com.mimvista.mui.presenters.companion.CompanionControl;
import com.mimvista.mui.presenters.companion.b;
import com.mimvista.mui.presenters.companion.f;
import com.mimvista.mui.presenters.companion.h;
import com.mimvista.preferencesNew.BinningPrefs;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Paint;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYImageAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.TextAnchor;

public class RespiratoryTraceCustomViewPanel
extends CustomViewPanel {
    private static final Color background = MIMLookAndFeel.E();
    private static final Color ctHighlight = MIMLookAndFeel.x();
    private static final Color activeCTHighlight = MIMLookAndFeel.a(ctHighlight, Color.WHITE, 0.85f);
    private static final Color badctHighlight = MIMLookAndFeel.a(ctHighlight, Color.YELLOW, 0.8f);
    private static final Color badActiveCTHighlight = MIMLookAndFeel.a(badctHighlight, Color.WHITE, 0.85f);
    private static final Color origHighlight = MIMLookAndFeel.a(ctHighlight, Color.CYAN.brighter(), 0.85f);
    private static final Color alteredHighlight = MIMLookAndFeel.a(ctHighlight, Color.CYAN.brighter(), 0.65f);
    private static final Color previewHighlight = MIMLookAndFeel.a(ctHighlight, Color.CYAN.brighter(), 0.5f);
    private static final Color textColor = MIMLookAndFeel.i();
    private static final Color amplitudeTraceColor = Color.RED;
    private static final Color phaseTraceColor = Color.BLUE.brighter();
    private final BinningState binning;
    private final List<ChartPanel> panels;
    private final JScrollPane scrolly;
    private ActionListener localizeListener = null;
    private p frameListener = null;
    private final Style style = BinningPrefs.tracePlotsCombined.getValue() != false ? Style.COMBINED_PLOT : Style.MULTI_PLOT;
    private final ViewState viewState = new ViewState();

    public RespiratoryTraceCustomViewPanel(CustomView customView) {
        super(customView, true);
        this.binning = this.getBinningState(customView);
        this.panels = Lists.newArrayList();
        this.scrolly = new JScrollPane();
        this.buildUI(this.generateXYSeries(this.binning.params.getRPM()));
        this.addListeners();
    }

    private void buildUI(XYSeriesCollection xYSeriesCollection) {
        this.setLayout(new BorderLayout());
        JPanel jPanel = this.style.buildPanels(this.panels, this.binning, xYSeriesCollection, this.viewState);
        this.updateMarkers();
        jPanel.setPreferredSize(new Dimension(this.binning.params.getRPM().data.size(), 0));
        this.scrolly.setViewportView(jPanel);
        this.scrolly.setHorizontalScrollBarPolicy(30);
        this.scrolly.setVerticalScrollBarPolicy(21);
        this.scrolly.setPreferredSize(new Dimension(1024, 700));
        this.add((Component)this.scrolly, "Center");
        SwingUtilities.invokeLater(() -> this.scrollTo(g.a(this.getView().n())));
    }

    private void addListeners() {
        this.localizeListener = actionEvent -> {
            ViewController viewController = (ViewController)actionEvent.getSource();
            this.relocalize(viewController);
        };
        this.frameListener = new p(){

            @Override
            public void frameChanged() {
                RespiratoryTraceCustomViewPanel.this.updateMarkers();
            }
        };
        this.getView().n().a(this.localizeListener, true, ViewLink.ViewEvent.a);
        this.getView().n().bh().cE().a(this.frameListener);
        for (final ChartPanel chartPanel : this.panels) {
            chartPanel.addChartMouseListener(new ChartMouseListener(){

                public void chartMouseClicked(ChartMouseEvent chartMouseEvent) {
                    if (chartMouseEvent.getTrigger().getClickCount() == 1) {
                        this.handleLocalize(chartMouseEvent);
                    }
                    if (chartMouseEvent.getTrigger().getClickCount() == 1 && chartMouseEvent.getTrigger().isControlDown() && RespiratoryTraceCustomViewPanel.this.isAdjusting()) {
                        this.handleSlabSwap(chartMouseEvent);
                    }
                }

                public void chartMouseMoved(ChartMouseEvent chartMouseEvent) {
                }

                private SlabRPM getClickedRPMSlab(ChartMouseEvent chartMouseEvent) {
                    JFreeChart jFreeChart = (JFreeChart)chartMouseEvent.getSource();
                    XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
                    Point2D point2D = chartPanel.translateScreenToJava2D(chartMouseEvent.getTrigger().getPoint());
                    double d2 = xYPlot.getDomainAxis().java2DToValue(point2D.getX(), chartPanel.getScreenDataArea(), xYPlot.getDomainAxisEdge());
                    RPMLoader.RPMInfo rPMInfo = ((RespiratoryTraceCustomViewPanel)RespiratoryTraceCustomViewPanel.this).binning.params.getRPM();
                    long l2 = ((RPMLoader.RPMPacket)rPMInfo.data.get((int)0)).time;
                    RPMLoader.RPMPacket rPMPacket = rPMInfo.getClosestPacket(l2 + (long)(d2 * 1000.0));
                    ImmutableList<SlabRPM> immutableList = RespiratoryTraceCustomViewPanel.this.binning.getDataMap().getSlabs(rPMPacket);
                    SlabRPM slabRPM = (SlabRPM)immutableList.get(0);
                    for (SlabRPM slabRPM2 : immutableList) {
                        if (Math.abs(slabRPM2.middle().time - rPMPacket.time) >= Math.abs(slabRPM.middle().time - rPMPacket.time)) continue;
                        slabRPM = slabRPM2;
                    }
                    return slabRPM;
                }

                private List<SlabInfo> getSortedInfosAtPosition(int n2) {
                    ArrayList arrayList = Lists.newArrayList(RespiratoryTraceCustomViewPanel.this.binning.getDataMap().getDicomForAcquisitionNumber(n2));
                    Collections.sort(arrayList, new Comparator<SlabInfo>(){

                        @Override
                        public int compare(SlabInfo slabInfo, SlabInfo slabInfo2) {
                            return Integer.compare(slabInfo.getFirst().sliceNumber, slabInfo2.getFirst().sliceNumber);
                        }
                    });
                    return arrayList;
                }

                private void handleSlabSwap(ChartMouseEvent chartMouseEvent) {
                    SlabRPM slabRPM = this.getClickedRPMSlab(chartMouseEvent);
                    SlabInfo slabInfo = RespiratoryTraceCustomViewPanel.this.binning.getDataMap().lookup(slabRPM);
                    int n2 = slabInfo.getAcquisitionNumber();
                    List<SlabInfo> list = this.getSortedInfosAtPosition(n2);
                    ViewController3D viewController3D = RespiratoryTraceCustomViewPanel.this.getView().n().bh();
                    List<SliceInfo> list2 = viewController3D.cw().ab();
                    for (SlabInfo slabInfo2 : list) {
                        if (slabInfo2 == slabInfo || !list2.contains(slabInfo2.getFirst())) continue;
                        g g2 = (g)com.mimvista.mui.p.a().g();
                        g2.b(viewController3D).a(viewController3D.cw(), slabInfo2, slabInfo);
                        break;
                    }
                }

                private void handleLocalize(ChartMouseEvent chartMouseEvent) {
                    SlabRPM slabRPM = this.getClickedRPMSlab(chartMouseEvent);
                    SlabInfo slabInfo2 = RespiratoryTraceCustomViewPanel.this.binning.getDataMap().lookup(slabRPM);
                    ViewController viewController = RespiratoryTraceCustomViewPanel.this.getView().n();
                    Set<SlabInfo> set = RespiratoryTraceCustomViewPanel.this.binning.getDataMap().getDicomForAcquisitionNumber(slabInfo2.getAcquisitionNumber());
                    ImageVolumeShort imageVolumeShort = viewController.bh().cw();
                    g.a(imageVolumeShort, set).ifPresent(slabInfo -> g.a(viewController, slabInfo));
                }
            });
        }
    }

    private void relocalize(ViewController viewController) {
        this.scrollTo(g.a(viewController));
        this.updateMarkers();
    }

    private void scrollTo(SlabInfo slabInfo) {
        JScrollBar jScrollBar = this.scrolly.getHorizontalScrollBar();
        int n2 = jScrollBar.getMinimum();
        int n3 = jScrollBar.getMaximum() - jScrollBar.getVisibleAmount();
        ImmutableList<RPMLoader.RPMInfo> immutableList = this.binning.params.getRPM().extractTTLSegments();
        SlabRPM slabRPM = this.binning.getInfoForSlice(slabInfo.getFirst());
        RPMLoader.RPMInfo rPMInfo2 = (RPMLoader.RPMInfo)Iterables.find(immutableList, rPMInfo -> rPMInfo.data.contains((Object)slabRPM.iterator().next()));
        double d2 = ((RPMLoader.RPMPacket)((RPMLoader.RPMInfo)immutableList.get((int)0)).data.get((int)0)).time;
        double d3 = ((RPMLoader.RPMPacket)((RPMLoader.RPMInfo)immutableList.get((int)(immutableList.size() - 1))).data.get((int)(((RPMLoader.RPMInfo)immutableList.get((int)(immutableList.size() - 1))).data.size() - 1))).time;
        double d4 = (rPMInfo2.getLastPacket().time + rPMInfo2.getFirstPacket().time) / 2L;
        this.scrolly.getHorizontalScrollBar().setValue((int)((d4 - d2) / (d3 - d2) * (double)(n3 - n2)));
    }

    private XYSeriesCollection generateXYSeries(RPMLoader.RPMInfo rPMInfo) {
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        XYSeries xYSeries = new XYSeries((Comparable)((Object)Trace.AMPLITUDE));
        XYSeries xYSeries2 = new XYSeries((Comparable)((Object)Trace.PHASE));
        ImmutableList<RPMLoader.RPMInfo> immutableList = this.binning.params.getRPM().extractTTLSegments();
        RPMLoader.RPMPacket rPMPacket = (RPMLoader.RPMPacket)this.binning.params.getRPM().data.get(0);
        for (int i2 = rPMInfo.data.indexOf((Object)((RPMLoader.RPMInfo)immutableList.get(0)).getFirstPacket()); i2 <= rPMInfo.data.indexOf((Object)((RPMLoader.RPMInfo)immutableList.get(immutableList.size() - 1)).getLastPacket()); ++i2) {
            RPMLoader.RPMPacket rPMPacket2 = (RPMLoader.RPMPacket)rPMInfo.data.get(i2);
            double d2 = RPMLoader.RPMPacket.getSecondsBetween(rPMPacket, rPMPacket2);
            xYSeries.add(d2, rPMPacket2.amplitude);
            xYSeries2.add(d2, rPMPacket2.phase);
        }
        xYSeriesCollection.addSeries(xYSeries);
        xYSeriesCollection.addSeries(xYSeries2);
        return xYSeriesCollection;
    }

    public void updateMarkers() {
        for (JFreeChart jFreeChart : Iterables.transform(this.panels, ChartPanel::getChart)) {
            jFreeChart.getXYPlot().clearDomainMarkers();
            jFreeChart.getXYPlot().clearAnnotations();
            for (int i2 = 0; i2 < jFreeChart.getXYPlot().getRendererCount(); ++i2) {
                jFreeChart.getXYPlot().getRenderer(i2).removeAnnotations();
            }
            this.addAcquisitionHighlight(jFreeChart);
            this.addSliceSelectionHighlight(jFreeChart);
            if (this.viewState.showEditPreviews) {
                this.addEditPreviewHighlights(jFreeChart);
            }
            if (!this.viewState.showOrigSelection) continue;
            this.addOriginalSelectionMarkers(jFreeChart);
        }
    }

    private void addAcquisitionHighlight(JFreeChart jFreeChart) {
        ImmutableList<RPMLoader.RPMInfo> immutableList = this.binning.params.getRPM().extractTTLSegments();
        RPMLoader.RPMPacket rPMPacket = (RPMLoader.RPMPacket)this.binning.params.getRPM().data.get(0);
        SlabInfo slabInfo = g.a(this.getView().n());
        for (RPMLoader.RPMInfo rPMInfo : immutableList) {
            boolean bl2 = this.binning.getDataMap().getAcquisitionNumber(rPMInfo.getFirstPacket()) == slabInfo.getAcquisitionNumber().intValue();
            Color color = bl2 ? activeCTHighlight : ctHighlight;
            IntervalMarker intervalMarker = new IntervalMarker(RPMLoader.RPMPacket.getSecondsBetween(rPMPacket, rPMInfo.getFirstPacket()), RPMLoader.RPMPacket.getSecondsBetween(rPMPacket, rPMInfo.getLastPacket()), (Paint)color);
            jFreeChart.getXYPlot().addDomainMarker((Marker)intervalMarker, Layer.BACKGROUND);
            for (RPMLoader.RPMInfo rPMInfo2 : rPMInfo.extractBadTrackingSegments()) {
                double d2 = RPMLoader.RPMPacket.getSecondsBetween(rPMPacket, rPMInfo2.getFirstPacket());
                double d3 = RPMLoader.RPMPacket.getSecondsBetween(rPMPacket, rPMInfo2.getLastPacket());
                intervalMarker = new IntervalMarker(d2, d3, (Paint)(bl2 ? badActiveCTHighlight : badctHighlight));
                jFreeChart.getXYPlot().addDomainMarker((Marker)intervalMarker, Layer.BACKGROUND);
            }
        }
    }

    private void addSliceSelectionHighlight(JFreeChart jFreeChart) {
        RPMLoader.RPMPacket rPMPacket = (RPMLoader.RPMPacket)this.binning.params.getRPM().data.get(0);
        for (SlabInfo slabInfo : this.binning.getBinnedSlabs()) {
            SlabRPM slabRPM = this.binning.getDataMap().lookup(slabInfo);
            double d2 = RPMLoader.RPMPacket.getSecondsBetween(rPMPacket, slabRPM.start());
            double d3 = RPMLoader.RPMPacket.getSecondsBetween(rPMPacket, slabRPM.end());
            Color color = this.getHighlightColor(slabInfo);
            jFreeChart.getXYPlot().addDomainMarker((Marker)new IntervalMarker(d2, d3, (Paint)color), Layer.BACKGROUND);
        }
    }

    private void addEditPreviewHighlights(JFreeChart jFreeChart) {
        SlabInfo slabInfo2 = g.a(this.getView().n());
        Optional<SlabInfo> optional = this.getPreviewedSlab(slabInfo2);
        optional.ifPresent(slabInfo -> {
            RPMLoader.RPMPacket rPMPacket = (RPMLoader.RPMPacket)this.binning.params.getRPM().data.get(0);
            SlabRPM slabRPM = this.binning.getDataMap().lookup((SlabInfo)slabInfo);
            double d2 = RPMLoader.RPMPacket.getSecondsBetween(rPMPacket, slabRPM.start());
            double d3 = RPMLoader.RPMPacket.getSecondsBetween(rPMPacket, slabRPM.end());
            Color color = previewHighlight;
            jFreeChart.getXYPlot().addDomainMarker((Marker)new IntervalMarker(d2, d3, (Paint)color), Layer.BACKGROUND);
        });
    }

    private void addOriginalSelectionMarkers(JFreeChart jFreeChart) {
        VolRef volRef = new VolRef(this.binning.binned.b().aw());
        HashMap hashMap = Maps.newHashMap();
        this.binning.getDataMap().getAllDicom().forEach(slabInfo -> slabInfo.forEach(sliceInfo -> hashMap.put(new UIDContainer.SOPInstanceUID(sliceInfo.sopInstanceUID), slabInfo)));
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet((Iterable)Iterables.transform((Iterable)((Iterable)this.binning.originalSliceSelection.get((Object)volRef)), hashMap::get));
        RPMLoader.RPMPacket rPMPacket = (RPMLoader.RPMPacket)this.binning.params.getRPM().data.get(0);
        BufferedImage bufferedImage = ImageManipulator.d("arrow_up", 15, 10);
        for (SlabInfo slabInfo2 : linkedHashSet) {
            SlabRPM slabRPM = this.binning.getDataMap().lookup(slabInfo2);
            double d2 = RPMLoader.RPMPacket.getSecondsBetween(rPMPacket, slabRPM.middle());
            this.addImageAnnotations(jFreeChart, d2, bufferedImage);
        }
    }

    private void addImageAnnotations(JFreeChart jFreeChart, double d2, Image image) {
        int n2 = 0;
        XYDataset xYDataset = jFreeChart.getXYPlot().getDataset();
        boolean bl2 = xYDataset.getSeriesKey(n2) == Trace.AMPLITUDE && this.viewState.invertAmplitude;
        ValueAxis valueAxis = jFreeChart.getXYPlot().getRangeAxis(n2);
        double d3 = bl2 ? valueAxis.getRange().getUpperBound() : valueAxis.getRange().getLowerBound();
        for (int i2 = 0; i2 < xYDataset.getItemCount(n2); ++i2) {
            if (!(xYDataset.getXValue(0, i2) >= d2)) continue;
            XYImageAnnotation xYImageAnnotation = new XYImageAnnotation(d2, d3, image, RectangleAnchor.BOTTOM);
            jFreeChart.getXYPlot().getRenderer(0).addAnnotation((XYAnnotation)xYImageAnnotation);
            break;
        }
    }

    private Color getHighlightColor(SlabInfo slabInfo) {
        boolean bl2;
        VolRef volRef = new VolRef(this.binning.binned.b().aw());
        boolean bl3 = bl2 = !((ImmutableSet)this.binning.originalSliceSelection.get((Object)volRef)).containsAll((Collection)Lists.transform((List)slabInfo, sliceInfo -> new UIDContainer.SOPInstanceUID(sliceInfo.sopInstanceUID)));
        if (this.viewState.showSliceSelectionEdits && bl2) {
            return alteredHighlight;
        }
        return origHighlight;
    }

    private Optional<SlabInfo> getPreviewedSlab(SlabInfo slabInfo) {
        if (!this.isAdjusting()) {
            return Optional.empty();
        }
        g.b b2 = ((g)com.mimvista.mui.p.a().g()).b(this.binning.binned.b());
        if (this.isNextSliceHovered()) {
            return Optional.of(b2.a(slabInfo, true));
        }
        if (this.isPrevSliceHovered()) {
            return Optional.of(b2.a(slabInfo, false));
        }
        return Optional.empty();
    }

    private BinningState getBinningState(CustomView customView) {
        ViewController viewController = customView.n();
        return BinningStateManager.getBinningState(viewController);
    }

    private boolean isAdjusting() {
        return com.mimvista.mui.p.a().g() instanceof g;
    }

    private boolean isNextSliceHovered() {
        return this.isSliceSelectionControlFocused(true);
    }

    private boolean isPrevSliceHovered() {
        return this.isSliceSelectionControlFocused(false);
    }

    private boolean isSliceSelectionControlFocused(boolean bl2) {
        if (!this.isAdjusting()) {
            return false;
        }
        p.a a2 = com.mimvista.mui.p.a().c();
        if (a2.u == null || a2.p == null) {
            return false;
        }
        if (a2.p.getID() == 505 || a2.p.getID() == 503) {
            return false;
        }
        ViewPort viewPort = a2.u.am();
        if (viewPort == null) {
            return false;
        }
        for (CompanionControl companionControl : f.e(viewPort)) {
            for (h h2 : companionControl.G()) {
                if (h2.a() != a2.p.getSource() || !(h2 instanceof b.b)) continue;
                return ((b.b)h2).a == bl2;
            }
        }
        return false;
    }

    static /* synthetic */ Color access$500() {
        return amplitudeTraceColor;
    }

    static /* synthetic */ Color access$600() {
        return phaseTraceColor;
    }

    static enum Trace {
        AMPLITUDE("TRACE_AMPLITUDE", RespiratoryTraceCustomViewPanel.access$500()),
        PHASE("TRACE_PHASE", RespiratoryTraceCustomViewPanel.access$600());

        private final String key;
        private final Color color;

        private Trace(String string2, Color color) {
            this.key = string2;
            this.color = color;
        }

        public String getLabel() {
            return Messages.a("Modes", this.key);
        }

        public Color getColor() {
            return this.color;
        }
    }

    static enum Style {
        COMBINED_PLOT((list, binningState, xYSeriesCollection) -> {
            Trace trace;
            JFreeChart jFreeChart = ChartFactory.createXYLineChart(null, null, null, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
            for (int i2 = 0; i2 < xYSeriesCollection.getSeriesCount(); ++i2) {
                trace = (Trace)((Object)((Object)xYSeriesCollection.getSeriesKey(i2)));
                XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer(true, false);
                xYLineAndShapeRenderer.setSeriesPaint(0, (Paint)trace.getColor());
                NumberAxis numberAxis = new NumberAxis(trace.getLabel());
                numberAxis.setAutoRangeIncludesZero(false);
                numberAxis.setAutoRange(true);
                jFreeChart.getXYPlot().setDataset(i2, (XYDataset)new XYSeriesCollection(xYSeriesCollection.getSeries(i2)));
                jFreeChart.getXYPlot().setRenderer(i2, (XYItemRenderer)xYLineAndShapeRenderer);
                jFreeChart.getXYPlot().setRangeAxis(i2, (ValueAxis)numberAxis);
                jFreeChart.getXYPlot().mapDatasetToRangeAxis(i2, i2);
            }
            JPanel jPanel = new JPanel(new BorderLayout());
            trace = new ChartPanel(jFreeChart);
            list.add(trace);
            jPanel.add((Component)((Object)trace), "Center");
            return jPanel;
        }),
        MULTI_PLOT((list, binningState, xYSeriesCollection) -> {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            ImmutableList<RPMLoader.RPMInfo> immutableList = binningState.params.getRPM().extractTTLSegments();
            RPMLoader.RPMPacket rPMPacket = (RPMLoader.RPMPacket)binningState.params.getRPM().data.get(0);
            for (int i2 = 0; i2 < xYSeriesCollection.getSeriesCount(); ++i2) {
                Trace trace = (Trace)((Object)((Object)xYSeriesCollection.getSeriesKey(i2)));
                JFreeChart jFreeChart = ChartFactory.createXYLineChart(null, (String)(i2 == 0 ? null : Messages.a("Modes", "TRACE_TIME")), (String)trace.getLabel(), (XYDataset)new XYSeriesCollection(xYSeriesCollection.getSeries(i2)), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
                XYPlot xYPlot = jFreeChart.getXYPlot();
                xYPlot.getRenderer().setSeriesPaint(0, (Paint)trace.getColor());
                for (RPMLoader.RPMInfo rPMInfo : immutableList) {
                    double d2 = RPMLoader.RPMPacket.getSecondsBetween(rPMPacket, rPMInfo.getFirstPacket());
                    XYTextAnnotation xYTextAnnotation = new XYTextAnnotation(MIMFormat.a(Messages.a("Modes", "TRACE_POSITION_LABEL"), binningState.params.dataMap.getAcquisitionNumber(rPMInfo.getFirstPacket())), d2, xYSeriesCollection.getSeries(i2).getMaxY());
                    xYTextAnnotation.setPaint((Paint)textColor.darker());
                    xYTextAnnotation.setTextAnchor(TextAnchor.BOTTOM_LEFT);
                    xYPlot.addAnnotation((XYAnnotation)xYTextAnnotation);
                }
                ChartPanel chartPanel = new ChartPanel(jFreeChart);
                gridBagConstraints.insets.top = i2 == 0 ? 0 : 10;
                jPanel.add((Component)chartPanel, gridBagConstraints);
                ++gridBagConstraints.gridy;
                list.add(chartPanel);
            }
            return jPanel;
        });

        private final Builder panelBuilder;

        private Style(Builder builder) {
            this.panelBuilder = builder;
        }

        JPanel buildPanels(List<ChartPanel> list, BinningState binningState, XYSeriesCollection xYSeriesCollection, ViewState viewState) {
            JPanel jPanel = this.panelBuilder.build(list, binningState, xYSeriesCollection);
            for (ChartPanel chartPanel : list) {
                chartPanel.getChart().setBackgroundPaint((Paint)background);
                XYPlot xYPlot = chartPanel.getChart().getXYPlot();
                xYPlot.setBackgroundPaint((Paint)background);
                xYPlot.getDomainAxis().setTickLabelPaint((Paint)textColor);
                xYPlot.getDomainAxis().setLabelPaint((Paint)textColor);
                for (int i2 = 0; i2 < xYPlot.getDatasetCount(); ++i2) {
                    XYSeriesCollection xYSeriesCollection2 = (XYSeriesCollection)xYPlot.getDataset(i2);
                    for (XYSeries xYSeries : xYSeriesCollection2.getSeries()) {
                        Trace trace = (Trace)((Object)xYSeries.getKey());
                        NumberAxis numberAxis = (NumberAxis)xYPlot.getRangeAxisForDataset(i2);
                        numberAxis.setLabelPaint((Paint)textColor);
                        numberAxis.setTickLabelPaint((Paint)textColor);
                        numberAxis.setNumberFormatOverride((NumberFormat)new DecimalFormat("###.00##"));
                        if (!viewState.invertAmplitude || trace != Trace.AMPLITUDE) continue;
                        numberAxis.setInverted(true);
                    }
                }
                chartPanel.setMaximumDrawWidth(2 * binningState.params.getRPM().data.size());
            }
            return jPanel;
        }

        @FunctionalInterface
        private static interface Builder {
            public JPanel build(List<ChartPanel> var1, BinningState var2, XYSeriesCollection var3);
        }
    }

    private static class ViewState {
        boolean showSliceSelectionEdits = BinningPrefs.traceShowEdits.getValue();
        boolean showOrigSelection = BinningPrefs.traceShowOrigSelection.getValue();
        boolean showEditPreviews = BinningPrefs.tracePreviewEdits.getValue();
        boolean invertAmplitude = BinningPrefs.traceInvertAmplitude.getValue();

        private ViewState() {
        }
    }
}

