/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.binning;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.dicom.binning.BinningState;
import com.mimvista.dicom.binning.BinningStateManager;
import com.mimvista.dicom.binning.RespiratoryTraceCustomViewPanel;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.internals.ViewController;
import com.mimvista.license.LicenseTransformer;
import com.mimvista.mui.Session;
import com.mimvista.mui.layout.CustomView;
import com.mimvista.mui.layout.CustomViewPanel;
import com.mimvista.mui.layout.CustomViewSignature;
import com.mimvista.mui.mouse.mode.g;
import com.mimvista.mui.presenters.ProtocolMenu;
import com.mimvista.mui.presenters.ProtocolPage;
import com.mimvista.mui.presenters.c;
import com.mimvista.util.Messages;
import com.mimvista.util.serialize.XmlConvertor;
import com.mimvista.util.serialize.XmlSerializationWrapper;
import com.mimvista.viewer.f;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class RespiratoryTraceViewConstructor
extends c {
    public static final String CONSTRUCTOR_ID = "respiratory_trace";
    private static final String versionKey = "version";
    private static final String versionID = "1.0";

    @Override
    public String getConstructorId() {
        return CONSTRUCTOR_ID;
    }

    @Override
    public CustomView constructCustomView(ProtocolPage protocolPage, CustomViewSignature customViewSignature) {
        CustomView customView = customViewSignature.e();
        if (protocolPage == null) {
            customView.a(protocolPage, this.buildErrorPage(customView));
            return customView;
        }
        if (customViewSignature.b() == null || customViewSignature.b().a().isEmpty()) {
            customView.a(protocolPage, this.buildMappingPage(customView, protocolPage));
            return customView;
        }
        List<ViewController> list = customViewSignature.b().a();
        if (list.size() == 1 && BinningStateManager.hasBinningState((ViewController)Iterables.getOnlyElement(list))) {
            this.finishMapping(protocolPage, customView, (ViewController)Iterables.getOnlyElement(list));
            return customView;
        }
        customView.a(protocolPage, this.buildErrorPage(customView));
        return customView;
    }

    private void finishMapping(ProtocolPage protocolPage, CustomView customView, ViewController viewController) {
        customView.a(() -> viewController);
        customView.b(viewController);
        customView.a(protocolPage, new RespiratoryTraceCustomViewPanel(customView));
    }

    public XmlConvertor<Map<String, String>> getConvertor() {
        return new XmlSerializationWrapper.MapXmlConvertor();
    }

    @Override
    public String getDisplayName(Session session, CustomViewSignature customViewSignature) {
        return Messages.a("Modes", "TRACE_TITLE");
    }

    @Override
    public List<CustomViewSignature> getAvailableSigs(ViewController viewController) {
        if (!LicenseTransformer.isLicensedForMIMFeature(g.a.class)) {
            return Collections.emptyList();
        }
        BinningStateManager binningStateManager = viewController.g().b(BinningStateManager.class);
        if (binningStateManager == null || BinningStateManager.getBinningState(viewController) == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])new CustomViewSignature[]{this.makeSig(viewController)});
    }

    @Override
    public List<CustomViewSignature> getAvailableSigs(Session session) {
        if (!LicenseTransformer.isLicensedForMIMFeature(g.a.class)) {
            return Collections.emptyList();
        }
        BinningStateManager binningStateManager = session.b(BinningStateManager.class);
        if (binningStateManager == null || binningStateManager.getAllStates().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList arrayList = Lists.newArrayList();
        for (BinningState binningState : binningStateManager.getAllStates()) {
            arrayList.add(this.makeSig(binningState.binned.b()));
        }
        return arrayList;
    }

    private CustomViewSignature makeSig(ViewController viewController) {
        HashMap hashMap = Maps.newHashMap();
        hashMap.put(versionKey, versionID);
        CustomViewSignature customViewSignature = new CustomViewSignature(CONSTRUCTOR_ID, new XmlSerializationWrapper<Map<String, String>>(hashMap, this.getConvertor()));
        customViewSignature.a(viewController);
        return customViewSignature;
    }

    private CustomViewPanel buildErrorPage(CustomView customView) {
        CustomViewPanel customViewPanel = new CustomViewPanel(customView, new GridLayout(1, 1));
        customViewPanel.add(new JLabel(ImageManipulator.c("x_red", 100, 100)));
        return customViewPanel;
    }

    private CustomViewPanel buildMappingPage(final CustomView customView, final ProtocolPage protocolPage) {
        CustomViewPanel customViewPanel = new CustomViewPanel(customView, new GridBagLayout());
        BufferedImage bufferedImage = ImageManipulator.d("box_vit_man", 90, 90);
        final JButton jButton = new JButton(new ImageIcon(bufferedImage));
        jButton.setFocusable(false);
        jButton.setOpaque(false);
        jButton.setSize(100, 100);
        jButton.setMinimumSize(new Dimension(100, 100));
        jButton.setMaximumSize(new Dimension(100, 100));
        JPopupMenu jPopupMenu = new JPopupMenu();
        Session session = protocolPage.b();
        for (final ViewController viewController : session.af()) {
            if (viewController.aR() != null || !BinningStateManager.hasBinningState(viewController)) continue;
            JMenuItem jMenuItem = new JMenuItem(f.c(viewController));
            jPopupMenu.add(jMenuItem);
            jMenuItem.setIcon(new ImageIcon(ProtocolMenu.a(viewController, ProtocolMenu.b)));
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RespiratoryTraceViewConstructor.this.finishMapping(customView.h(), customView, viewController);
                    protocolPage.e();
                }
            });
        }
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                jButton.getComponentPopupMenu().show(jButton, mouseEvent.getX(), mouseEvent.getY());
            }
        });
        jButton.setComponentPopupMenu(jPopupMenu);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        customViewPanel.add((Component)jButton, gridBagConstraints);
        return customViewPanel;
    }
}

