/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.binning;

import com.google.common.collect.Lists;
import com.mimvista.internals.SliceInfo;
import java.util.ArrayList;
import java.util.Collection;

public class SlabInfo
extends ArrayList<SliceInfo> {
    private static final long serialVersionUID = 1L;
    private Integer acquisitionNumber = null;

    public SlabInfo(Collection<SliceInfo> collection) {
        super(collection);
        for (SliceInfo sliceInfo : collection) {
            this.checkAcqNum(sliceInfo);
        }
    }

    public SlabInfo(SliceInfo sliceInfo) {
        this(Lists.newArrayList((Object[])new SliceInfo[]{sliceInfo}));
    }

    public SlabInfo() {
    }

    public Integer getAcquisitionNumber() {
        return this.acquisitionNumber;
    }

    @Override
    public SliceInfo getFirst() {
        return (SliceInfo)this.get(0);
    }

    @Override
    public SliceInfo getLast() {
        return (SliceInfo)this.get(this.size() - 1);
    }

    @Override
    public boolean add(SliceInfo sliceInfo) {
        this.checkAcqNum(sliceInfo);
        return super.add(sliceInfo);
    }

    @Override
    public boolean addAll(Collection<? extends SliceInfo> collection) {
        for (SliceInfo sliceInfo : collection) {
            this.checkAcqNum(sliceInfo);
        }
        return super.addAll(collection);
    }

    @Override
    public boolean addAll(int n2, Collection<? extends SliceInfo> collection) {
        for (SliceInfo sliceInfo : collection) {
            this.checkAcqNum(sliceInfo);
        }
        return super.addAll(n2, collection);
    }

    private void checkAcqNum(SliceInfo sliceInfo) {
        Integer n2 = Integer.parseInt(sliceInfo.acquisitionNumber);
        if (this.acquisitionNumber == null) {
            this.acquisitionNumber = n2;
        } else if (n2 != this.acquisitionNumber) {
            throw new IllegalArgumentException("Inconsistent acqusition numbers");
        }
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }
}

