/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.binning;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.mimvista.dicom.binning.RPMLoader;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class SlabRPM
implements Serializable,
Iterable<RPMLoader.RPMPacket> {
    private static final long serialVersionUID = 1L;
    private final List<RPMLoader.RPMPacket> list = Lists.newArrayList();
    private RPMLoader.RPMPacket nominal = null;

    public SlabRPM(Collection<RPMLoader.RPMPacket> collection) {
        this.list.addAll(collection);
    }

    public RPMLoader.RPMPacket average() {
        return RPMLoader.RPMPacket.average(this.list);
    }

    public void nominate(RPMLoader.RPMPacket rPMPacket) {
        this.nominal = rPMPacket;
    }

    public RPMLoader.RPMPacket middle() {
        int n2;
        if (this.nominal != null) {
            return this.nominal;
        }
        float f2 = (float)(this.list.size() - 1) / 2.0f;
        int n3 = (int)Math.floor(f2);
        return n3 == (n2 = (int)Math.ceil(f2)) ? this.list.get(n3) : RPMLoader.RPMPacket.interpolate(this.list.get(n3), this.list.get(n2), f2 - (float)n3);
    }

    public RPMLoader.RPMPacket start() {
        return this.list.get(0);
    }

    public RPMLoader.RPMPacket end() {
        return this.list.get(this.list.size() - 1);
    }

    @Override
    public Iterator<RPMLoader.RPMPacket> iterator() {
        return Iterators.unmodifiableIterator(this.list.iterator());
    }
}

