/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.binning;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.dicom.UIDContainer;
import com.mimvista.dicom.binning.SliceSelectionEdit;
import com.mimvista.dicom.read.SeriesRef;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.o;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.ImageSlice;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

public class SliceCache
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean SHARED_CACHE = true;
    private final transient Map<UIDContainer.SOPInstanceUID, SliceSelectionEdit.LoadedSlice> sliceData;
    private final SeriesRef seriesID;
    private transient o series;

    public SliceCache(o o2) {
        this.series = o2;
        this.sliceData = Maps.newHashMap();
        Iterable iterable = Iterables.concat((Iterable)Lists.transform(o2.l(), SimpleImageVolume::ab));
        this.seriesID = new SeriesRef(iterable);
        for (ImageVolumeShort imageVolumeShort : o2.l()) {
            List<SliceInfo> list = imageVolumeShort.ab();
            for (int i2 = 0; i2 < imageVolumeShort.a()[2]; ++i2) {
                SliceInfo sliceInfo = list.get(i2);
                UIDContainer.SOPInstanceUID sOPInstanceUID = new UIDContainer.SOPInstanceUID(sliceInfo.sopInstanceUID);
                short[] sArray = (short[])((ImageSlice.ImageSliceShort)((ImageCube.ImageCubeShort)imageVolumeShort.ad()).f((int)i2)).data;
                this.sliceData.put(sOPInstanceUID, new SliceSelectionEdit.LoadedSlice(sliceInfo, sArray));
            }
        }
    }

    public short[] getSliceData(UIDContainer.SeriesUID seriesUID, UIDContainer.SOPInstanceUID sOPInstanceUID) {
        if (!seriesUID.equals(this.seriesID.seriesUID)) {
            throw new NoSuchElementException("No data for series");
        }
        short[] sArray = this.peekPrivateSliceData(sOPInstanceUID);
        return sArray;
    }

    public List<SliceInfo> getAllInfos() {
        return this.sliceData.values().stream().map(SliceSelectionEdit.LoadedSlice::getInfo).collect(Collectors.toList());
    }

    public SeriesRef getSeries() {
        return this.seriesID;
    }

    public String getExposureTime() {
        return this.series.e().I().exposureTime;
    }

    protected short[] peekPrivateSliceData(UIDContainer.SOPInstanceUID sOPInstanceUID) {
        SliceSelectionEdit.LoadedSlice loadedSlice = this.sliceData.get(sOPInstanceUID);
        if (loadedSlice == null) {
            throw new NoSuchElementException("Missing data for slice " + sOPInstanceUID);
        }
        return loadedSlice.getData();
    }

    protected SliceSelectionEdit.LoadedSlice peek(UIDContainer.SOPInstanceUID sOPInstanceUID) {
        SliceSelectionEdit.LoadedSlice loadedSlice = this.sliceData.get(sOPInstanceUID);
        if (loadedSlice == null) {
            throw new NoSuchElementException("Missing data for slice " + sOPInstanceUID);
        }
        return loadedSlice;
    }

    protected void replace(SliceCache sliceCache) {
        if (!sliceCache.seriesID.equals(this.seriesID)) {
            throw new IllegalArgumentException("Can't update cache with different series");
        }
        this.sliceData.clear();
        this.sliceData.putAll(sliceCache.sliceData);
        this.series = sliceCache.series;
    }

    protected ImageVolumeShort makeVol() {
        return (ImageVolumeShort)this.series.e().e();
    }

    public ImageVolumeShort getFirstFrame() {
        return this.series == null ? null : this.series.e();
    }

    private void readObject(ObjectInputStream objectInputStream) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        Field field = SliceCache.class.getDeclaredField("sliceData");
        field.setAccessible(true);
        field.set(this, Maps.newHashMap());
        field.setAccessible(false);
    }
}

