/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.binning;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.commands.workflow.Bin4DCTCommand;
import com.mimvista.dicom.UIDContainer;
import com.mimvista.dicom.binning.BinningStateManager;
import com.mimvista.dicom.binning.RespiratoryTraceCustomViewPanel;
import com.mimvista.dicom.binning.SlabInfo;
import com.mimvista.dicom.binning.SliceCache;
import com.mimvista.internals.DynamicVolumeRef3D;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.statistics.OverlayStatistician;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.mui.bm;
import com.mimvista.mui.overlays.ae;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.ImageSlice;
import com.mimvista.util.state.AbstractState;
import com.mimvista.util.state.MIMUndoableEdit;
import com.mimvista.viewer.SeriesInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;

public class SliceSelectionEdit
extends MIMUndoableEdit {
    private static final long serialVersionUID = 7098031324784492145L;

    public SliceSelectionEdit(DynamicVolumeRef3D dynamicVolumeRef3D, SlabInfo slabInfo, SlabInfo slabInfo2) {
        this(dynamicVolumeRef3D, SliceSelectionEdit.buildChangeMap(slabInfo, slabInfo2));
    }

    public SliceSelectionEdit(DynamicVolumeRef3D dynamicVolumeRef3D, Map<UIDContainer.SOPInstanceUID, UIDContainer.SOPInstanceUID> map) {
        SliceSelectionState sliceSelectionState = new SliceSelectionState(dynamicVolumeRef3D);
        SliceSelectionState sliceSelectionState2 = new SliceSelectionState(dynamicVolumeRef3D);
        sliceSelectionState2.sliceSelection.replaceAll(sOPInstanceUID -> map.getOrDefault(sOPInstanceUID, (UIDContainer.SOPInstanceUID)sOPInstanceUID));
        this.oldStates.add(sliceSelectionState);
        this.newStates.add(sliceSelectionState2);
        sliceSelectionState2.stamp();
    }

    private static final Map<UIDContainer.SOPInstanceUID, UIDContainer.SOPInstanceUID> buildChangeMap(SlabInfo slabInfo, SlabInfo slabInfo2) {
        HashMap hashMap = Maps.newHashMap();
        for (int i2 = 0; i2 < Math.max(slabInfo.size(), slabInfo2.size()); ++i2) {
            hashMap.put(new UIDContainer.SOPInstanceUID(((SliceInfo)slabInfo.get((int)i2)).sopInstanceUID), new UIDContainer.SOPInstanceUID(((SliceInfo)slabInfo2.get((int)i2)).sopInstanceUID));
        }
        return hashMap;
    }

    public static class LoadedSlice {
        private final SliceInfo info;
        private final short[] data;

        public LoadedSlice(SliceInfo sliceInfo, short[] sArray) {
            this.info = sliceInfo;
            this.data = sArray;
        }

        public SliceInfo getInfo() {
            return this.info;
        }

        public short[] getData() {
            return this.data;
        }
    }

    public static class SliceSelectionState
    extends AbstractState {
        private static final long serialVersionUID = 4448457185848144139L;
        DynamicVolumeRef3D vol;
        List<UIDContainer.SOPInstanceUID> sliceSelection;

        SliceSelectionState(DynamicVolumeRef3D dynamicVolumeRef3D) {
            this.vol = dynamicVolumeRef3D;
            this.sliceSelection = dynamicVolumeRef3D.f().ab().stream().map(sliceInfo -> sliceInfo.sopInstanceUID).map(UIDContainer.SOPInstanceUID::new).collect(Collectors.toList());
        }

        SliceSelectionState(DynamicVolumeRef3D dynamicVolumeRef3D, List<UIDContainer.SOPInstanceUID> list) {
            this.vol = dynamicVolumeRef3D;
            this.sliceSelection = Lists.newArrayList(list);
        }

        @Override
        public void stamp() {
            SwingUtilities.invokeLater(() -> {
                this.updateVolume();
                this.vol.a().Q();
            });
        }

        private void updateVolume() {
            ViewController3D viewController3D = this.vol.e();
            SliceCache sliceCache = BinningStateManager.getBinningState((ViewController)viewController3D).cache;
            List<SliceInfo> list = this.vol.f().ab();
            List list2 = this.sliceSelection.stream().map(sliceCache::peek).collect(Collectors.toList());
            boolean bl2 = false;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                LoadedSlice loadedSlice = (LoadedSlice)list2.get(i2);
                if (Objects.equal((Object)list.get(i2), (Object)loadedSlice.info)) continue;
                ImageCube.ImageCubeShort imageCubeShort = (ImageCube.ImageCubeShort)this.vol.f().ad();
                ImageSlice.ImageSliceShort imageSliceShort = (ImageSlice.ImageSliceShort)imageCubeShort.f(i2);
                ImageSlice.ImageSliceShort imageSliceShort2 = new ImageSlice.ImageSliceShort(loadedSlice.data, imageSliceShort.width, imageSliceShort.height);
                imageCubeShort.a(i2, imageSliceShort2);
                bl2 = true;
            }
            if (bl2) {
                ((SimpleImageVolume)this.vol.f()).a(list2.stream().map(LoadedSlice::getInfo).collect(Collectors.toList()));
                SliceSelectionState.markDirty(this.vol.f());
            }
        }

        private static void markDirty(ImageVolumeShort imageVolumeShort) {
            SeriesInfo seriesInfo = imageVolumeShort.getUncopiedMutableInfo();
            seriesInfo.k(null);
            seriesInfo.forceNewSeriesUidOnNextSave = true;
            seriesInfo.volumeHasBeenSaved = false;
            Set<String> set = seriesInfo.ai();
            set.clear();
            set.add(seriesInfo.ag());
            for (ae ae2 : imageVolumeShort.n().a(ae.class, true, true)) {
                OverlayStatistician<?> overlayStatistician = ae2.bg_();
                overlayStatistician.e().forEach(e2 -> overlayStatistician.d(e2.u()));
            }
            List<ViewController> list = bm.b(imageVolumeShort);
            list.forEach(ViewController::bC);
            imageVolumeShort.w().s().stream().flatMap(a2 -> a2.g().stream()).filter(customView -> list.contains(customView.n())).filter(customView -> customView.f() instanceof RespiratoryTraceCustomViewPanel).forEach(customView -> ((RespiratoryTraceCustomViewPanel)customView.f()).updateMarkers());
            bm.a(imageVolumeShort).stream().map(viewController -> viewController.aT().bh()).distinct().forEach(Bin4DCTCommand::generateUID);
        }
    }
}

