/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.binning;

import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.mimvista.dicom.binning.BinningTarget;
import com.mimvista.dicom.binning.RPMLoader;
import com.mimvista.preferencesNew.BinningPrefs;
import com.mimvista.preferencesNew.MIMPref;
import com.mimvista.util.Messages;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.apache.commons.lang3.Range;

public enum TargetType implements Serializable
{
    PHASE((MIMPref)BinningPrefs.phasePercentTargets, BinningPrefs.ModePref.b, "BINNING_MODE_PHASE"){

        @Override
        public List<BinningTarget> correctTargets(List<BinningTarget> list, Consumer<String> consumer) {
            return TargetType.correctTargetsWithParams(list, true, (Range<Double>)Range.between((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)), consumer);
        }

        @Override
        List<BinningTarget> makeTargets(RPMLoader.RPMInfo rPMInfo, Float[] floatArray) {
            return BinningTarget.getPhasePercentageBins(floatArray);
        }
    }
    ,
    AMPLITUDE((MIMPref)BinningPrefs.amplitudePercentTargets, BinningPrefs.ModePref.a, "BINNING_MODE_AMPLITUDE"){

        @Override
        public List<BinningTarget> correctTargets(List<BinningTarget> list, Consumer<String> consumer) {
            return TargetType.correctTargetsWithParams(list, false, (Range<Double>)Range.between((Comparable)Double.valueOf(-1.0), (Comparable)Double.valueOf(1.0)), consumer);
        }

        @Override
        public List<BinningTarget> makeTargets(RPMLoader.RPMInfo rPMInfo, Float[] floatArray) {
            return BinningTarget.getAmplitudePercentageBins(rPMInfo, floatArray);
        }
    };

    private MIMPref<Float[]> vals;
    private BinningPrefs.ModePref pref;
    private String key;

    private TargetType(MIMPref<Float[]> mIMPref, BinningPrefs.ModePref modePref, String string2) {
        this.vals = mIMPref;
        this.pref = modePref;
        this.key = string2;
    }

    public String toString() {
        return this.pref.toString();
    }

    public abstract List<BinningTarget> correctTargets(List<BinningTarget> var1, Consumer<String> var2);

    abstract List<BinningTarget> makeTargets(RPMLoader.RPMInfo var1, Float[] var2);

    public List<BinningTarget> getTargetsFromPrefs(RPMLoader.RPMInfo rPMInfo) {
        return this.makeTargets(rPMInfo, this.vals.getValue());
    }

    public static TargetType getForPref(BinningPrefs.ModePref modePref) {
        for (TargetType targetType : TargetType.values()) {
            if (modePref != targetType.pref) continue;
            return targetType;
        }
        throw new NoSuchElementException("Bad pref");
    }

    private static List<BinningTarget> correctTargetsWithParams(List<BinningTarget> list, boolean bl2, Range<Double> range, Consumer<String> consumer) {
        ArrayList arrayList = Lists.newArrayList(list);
        List list2 = Lists.transform((List)arrayList, BinningTarget::getTargetValue);
        boolean bl3 = list2.removeIf(d2 -> !range.contains(d2));
        boolean bl4 = !Ordering.natural().isOrdered((Iterable)list2);
        boolean bl5 = list2.removeIf(d2 -> list2.indexOf(d2) != list2.lastIndexOf(d2));
        if (bl4 && bl2) {
            Collections.sort(arrayList, Comparator.comparingDouble(BinningTarget::getTargetValue));
        }
        boolean bl6 = false;
        for (int i2 = 2; bl2 && i2 < arrayList.size(); ++i2) {
            double d3 = ((BinningTarget)arrayList.get(i2)).getTargetValue();
            double d4 = ((BinningTarget)arrayList.get(i2 - 1)).getTargetValue();
            double d5 = ((BinningTarget)arrayList.get(0)).getTargetValue();
            double d6 = ((BinningTarget)arrayList.get(1)).getTargetValue();
            if (!(Math.abs(d3 - d4 - (d6 - d5)) > (double)1.0E-4f)) continue;
            bl6 = true;
            break;
        }
        if (bl5 || bl3 || bl2 && (bl4 || bl6)) {
            consumer.accept(TargetType.getMemo(bl2 && bl4, bl3, bl5, bl2 && bl6));
        }
        return arrayList;
    }

    MIMPref<Float[]> getPref() {
        return this.vals;
    }

    private static String getMemo(boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        String string = Messages.a("Commands", "BIN4DCT_WARN_BASE") + "\n";
        if (bl2) {
            string = string + "\n" + Messages.a("Commands", "BIN4DCT_WARN_ORDER") + "\n";
        }
        if (bl3) {
            string = string + "\n" + Messages.a("Commands", "BIN4DCT_WARN_RANGE") + "\n";
        }
        if (bl4) {
            string = string + "\n" + Messages.a("Commands", "BIN4DCT_WARN_UNIQUENESS") + "\n";
        }
        if (bl5) {
            string = string + "\n" + Messages.a("Commands", "BIN4DCT_WARN_SPACING") + "\n";
        }
        return string;
    }
}

