/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.config;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class Configuration
extends Properties {
    private static final long serialVersionUID = 1L;

    private static String replace(String string, String string2, String string3) {
        return string2.equals(string) ? string3 : string;
    }

    public Configuration(String string) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            this.load(fileInputStream);
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not load configuration from " + string, exception);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Configuration(URL uRL) {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            this.load(inputStream);
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not load configuration from " + uRL, exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getProperty(String string, String string2, String string3, String string4) {
        return Configuration.replace(this.getProperty(string, string2), string3, string4);
    }

    public List<String> tokenize(String string, List<String> list) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("$")) {
                this.tokenize(this.getProperty(string2.substring(1), ""), list);
                continue;
            }
            list.add(string2);
        }
        return list;
    }

    public String[] tokenize(String string) {
        if (string == null) {
            return null;
        }
        List<String> list = this.tokenize(string, new LinkedList<String>());
        return list.toArray(new String[list.size()]);
    }
}

