/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.devices.dump.gui;

import com.mimvista.dicom.devices.dump.gui.DumpGuiFrame;
import com.mimvista.dicom.devices.dump.gui.UpdateInterface;
import com.mimvista.dicom.devices.dump.newDump.FocusOwner;
import com.mimvista.dicom.devices.dump.util.Dump2FileUtil;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.c;
import com.mimvista.mui.MIMFileDialog;
import com.mimvista.properties.ab;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.dcm4che2.data.DicomObject;

class ButtonsPanel
extends JPanel
implements UpdateInterface,
FocusOwner {
    private boolean allowSaving;
    private static String cachedSaveDestination = null;
    private JButton saveButton = this.button("BUTTONS_SAVE", "save");
    private JButton expandButton = this.button("BUTTONS_EXPAND_SEQ", "add");
    private JButton collapseButton = this.button("BUTTONS_COLLAPSE_SEQ", "subtract");
    private JLabel filterLabel = this.label("BUTTONS_FILTER", "");
    private JTextField filterText = new JTextField("");
    private JButton showAllButton = new JButton(DumpGuiFrame.props.getProperty("BUTTONS_SHOW_ALL"));
    private JRadioButton filterNameButton = this.radioButton("BUTTONS_FILTER_NAME", true);
    private JRadioButton filterValueButton = this.radioButton("BUTTONS_FILTER_VALUE", false);
    private JCheckBox hidePrivateCheckBox = this.checkBox("ATTRIB_HIDE_PRIVATE");
    private JCheckBox imageCheckBox = this.checkBox("IMAGE_ON");
    private DumpGuiFrame ownerFrame;

    public ButtonsPanel(DumpGuiFrame dumpGuiFrame, boolean bl2) {
        this.ownerFrame = dumpGuiFrame;
        this.ownerFrame.add(this);
        this.allowSaving = bl2;
        this.build();
    }

    @Override
    public void setFocus() {
        this.filterText.requestFocusInWindow();
    }

    @Override
    public void updateFiles(File[] fileArray) {
        this.setSingleFileButtonsVisible(fileArray.length == 1);
        this.ownerFrame.validate();
        this.ownerFrame.repaint();
    }

    private void build() {
        this.addButtons();
        this.addButtonListeners();
    }

    private void addButtonListeners() {
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ButtonsPanel.this.ownerFrame.getTableManager().isSavable()) {
                    MIMFileDialog mIMFileDialog = MIMFileDialog.a(ButtonsPanel.this.ownerFrame, DumpGuiFrame.props.getProperty("BUTTONS_SELECT_FOLDER"), MIMFileDialog.FileDialogType.b, true);
                    mIMFileDialog.b(ButtonsPanel.this.getDefaultDirectory());
                    mIMFileDialog.a(ButtonsPanel.this.getSaveFileName());
                    mIMFileDialog.a(true);
                    String string = mIMFileDialog.a();
                    if (string != null) {
                        cachedSaveDestination = new File(string).getParent();
                        if (!Dump2FileUtil.saveToFile(string, ButtonsPanel.this.ownerFrame.getTableManager().getFile())) {
                            JOptionPane.showMessageDialog(ButtonsPanel.this.ownerFrame, DumpGuiFrame.props.getProperty("BUTTONS_SAVE_FAIL"));
                        }
                    }
                }
            }
        });
        this.expandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ButtonsPanel.this.filterText.setText("");
                ButtonsPanel.this.ownerFrame.getTableManager().setCollapsed(false);
            }
        });
        this.collapseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ButtonsPanel.this.filterText.setText("");
                ButtonsPanel.this.ownerFrame.getTableManager().setCollapsed(true);
            }
        });
        this.hidePrivateCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ButtonsPanel.this.ownerFrame.getTableManager().setPrivateVisible(ButtonsPanel.this.hidePrivateCheckBox.isSelected());
            }
        });
        this.imageCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ButtonsPanel.this.ownerFrame.getTablePanel().setImageVisible(ButtonsPanel.this.imageCheckBox.isSelected());
            }
        });
        this.filterText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.filterAction();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.filterAction();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.filterAction();
            }

            private void filterAction() {
                ButtonsPanel.this.ownerFrame.getTableManager().filter(ButtonsPanel.this.filterText.getText(), ButtonsPanel.this.filterNameButton.isSelected());
            }
        });
        this.showAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ButtonsPanel.this.filterText.setText("");
                ButtonsPanel.this.showAllButton.setSelected(false);
            }
        });
        this.filterNameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ButtonsPanel.this.filterText.setText(ButtonsPanel.this.filterText.getText());
            }
        });
        this.filterValueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ButtonsPanel.this.filterText.setText(ButtonsPanel.this.filterText.getText());
            }
        });
    }

    private void setSingleFileButtonsVisible(boolean bl2) {
        this.saveButton.setVisible(bl2);
    }

    private void addButtons() {
        this.setLayout(new FlowLayout(0));
        this.add(this.expandButton);
        this.add(this.collapseButton);
        this.saveButton.setEnabled(this.allowSaving);
        this.add(this.saveButton);
        this.add(new JLabel("   "));
        this.add(this.filterLabel);
        this.add(this.filterText);
        this.filterText.setPreferredSize(new Dimension(250, 26));
        this.add(this.showAllButton);
        this.add(this.filterNameButton);
        this.add(this.filterValueButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.filterNameButton);
        buttonGroup.add(this.filterValueButton);
        this.add(this.hidePrivateCheckBox);
        this.add(this.imageCheckBox);
    }

    private String getDefaultDirectory() {
        return cachedSaveDestination == null ? ab.m() : cachedSaveDestination;
    }

    private String getSaveFileName() {
        return this.getSavePrefix(this.ownerFrame.getTableManager().getFile()) + "dicom.txt";
    }

    private String getSavePrefix(File file) {
        DicomObject dicomObject = DicomReader.readFileIntoDicomObject(file);
        if (dicomObject == null) {
            return "";
        }
        String string = dicomObject.getString(0x100010);
        String string2 = dicomObject.getString(0x100020);
        String string3 = dicomObject.getString(524384);
        String string4 = dicomObject.getString(524320);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        simpleDateFormat.applyPattern("yyMMddHHmmssSSS");
        String string5 = simpleDateFormat.format(System.currentTimeMillis());
        return string + "_" + string2 + "_" + string3 + "_" + string4 + "_" + string5 + "_";
    }

    private JButton button(String string, String string2) {
        return c.a(DumpGuiFrame.props.getProperty(string), "", string2);
    }

    private JLabel label(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return new JLabel(DumpGuiFrame.props.getProperty(string));
        }
        return new JLabel(DumpGuiFrame.props.getProperty(string), ImageManipulator.c(string2, 50, 50), 4);
    }

    private JRadioButton radioButton(String string, boolean bl2) {
        return new JRadioButton(DumpGuiFrame.props.getProperty(string), bl2);
    }

    private JCheckBox checkBox(String string) {
        return new JCheckBox(DumpGuiFrame.props.getProperty(string));
    }
}

