/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.devices.dump.gui;

import com.mimvista.dicom.devices.dump.gui.ButtonsPanel;
import com.mimvista.dicom.devices.dump.gui.GlobalNavigatorPanel;
import com.mimvista.dicom.devices.dump.gui.HistoryNavigatorPanel;
import com.mimvista.dicom.devices.dump.gui.SeriesNavigatorPanel;
import com.mimvista.dicom.devices.dump.gui.SeriesViewPanel;
import com.mimvista.dicom.devices.dump.gui.TableManager;
import com.mimvista.dicom.devices.dump.gui.TablePanel;
import com.mimvista.dicom.devices.dump.gui.UpdateInterface;
import com.mimvista.dicom.devices.dump.newDump.FocusOwner;
import com.mimvista.dicom.devices.dump.util.DcmFileUtil;
import com.mimvista.file.MIMFile;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.mui.toolbar.SidePanelManager;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFrame;

public class DumpGuiFrame
extends JFrame {
    private boolean allowSaving;
    private TablePanel tablePanel;
    private FocusOwner focusOwner;
    private List<UpdateInterface> observers = new ArrayList<UpdateInterface>();
    private File remoteSeriesInTemp = null;
    public static final Messages props = Messages.a("Dump");

    public DumpGuiFrame(String string, File file) {
        this(string, file, true);
    }

    public DumpGuiFrame(String string, File file, boolean bl2) {
        super(MIMFormat.a(props.getProperty("DICOM_INFORMATION"), DcmFileUtil.getPatientName(file)));
        this.allowSaving = bl2;
        ImageManipulator.a(this);
        this.build();
        this.update(new File[]{file}, this);
        this.display();
    }

    public void add(UpdateInterface updateInterface) {
        this.observers.add(updateInterface);
    }

    public void update(File[] fileArray, Object object) {
        for (UpdateInterface updateInterface : this.observers) {
            if (updateInterface == object) continue;
            updateInterface.updateFiles(fileArray);
        }
    }

    public void setremoteSeriesInTemp(File file) {
        this.remoteSeriesInTemp = file;
    }

    public TablePanel getTablePanel() {
        return this.tablePanel;
    }

    public TableManager getTableManager() {
        return this.getTablePanel().getTableManager();
    }

    private void build() {
        this.addButtonsPanel();
        this.addTablePanel();
        this.addNavigatorPanels();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                this.clearTempForRemote();
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                this.clearTempForRemote();
            }

            private void clearTempForRemote() {
                if (DumpGuiFrame.this.remoteSeriesInTemp != null) {
                    new MIMFile(DumpGuiFrame.this.remoteSeriesInTemp).delete();
                }
            }
        });
    }

    private void addButtonsPanel() {
        ButtonsPanel buttonsPanel = new ButtonsPanel(this, this.allowSaving);
        this.add((Component)buttonsPanel, "First");
        this.focusOwner = buttonsPanel;
    }

    private void addTablePanel() {
        this.tablePanel = new TablePanel(this);
        this.add((Component)this.tablePanel, "Center");
    }

    private void addNavigatorPanels() {
        SidePanelManager sidePanelManager = new SidePanelManager(true);
        sidePanelManager.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        sidePanelManager.a(false);
        this.add((Component)sidePanelManager, "West");
        GlobalNavigatorPanel globalNavigatorPanel = new GlobalNavigatorPanel(this);
        globalNavigatorPanel.setPreferredSize(new Dimension(200, 0));
        sidePanelManager.b(globalNavigatorPanel);
        SeriesNavigatorPanel seriesNavigatorPanel = new SeriesNavigatorPanel(this);
        seriesNavigatorPanel.setPreferredSize(new Dimension(200, 0));
        sidePanelManager.b(seriesNavigatorPanel);
        HistoryNavigatorPanel historyNavigatorPanel = new HistoryNavigatorPanel(this);
        historyNavigatorPanel.setPreferredSize(new Dimension(200, 0));
        sidePanelManager.b(historyNavigatorPanel);
        SeriesViewPanel seriesViewPanel = new SeriesViewPanel(this);
        seriesViewPanel.setPreferredSize(new Dimension(200, 0));
        sidePanelManager.a(seriesViewPanel, seriesViewPanel.getButtonActionListener());
    }

    private void display() {
        this.pack();
        this.setExtendedState(6);
        this.setVisible(true);
        this.focusOwner.setFocus();
    }
}

