/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.devices.dump.gui;

import com.mimvista.dicom.devices.dump.gui.DumpTableCellInterface;
import com.mimvista.proui.MIMLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class DumpTableCellRenderer
extends DefaultTableCellRenderer {
    public static final Color EVEN_ROW_BG_COLOR = MIMLookAndFeel.c();
    public static final Color ODD_ROW_BG_COLOR = MIMLookAndFeel.b();
    public static final Color SELECTED_ROW_BG_COLOR = new Color(50, 50, 0);

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
        Component component = super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
        if (bl2) {
            component.setBackground(SELECTED_ROW_BG_COLOR);
        } else if (object instanceof DumpTableCellInterface && ((DumpTableCellInterface)object).getBackgroundColor() != null) {
            component.setBackground(((DumpTableCellInterface)object).getBackgroundColor());
        } else if (n2 % 2 == 0) {
            component.setBackground(EVEN_ROW_BG_COLOR);
        } else {
            component.setBackground(ODD_ROW_BG_COLOR);
        }
        if (object instanceof DumpTableCellInterface) {
            DumpTableCellInterface dumpTableCellInterface = (DumpTableCellInterface)object;
            if (dumpTableCellInterface.hasTip()) {
                ((JComponent)component).setToolTipText(dumpTableCellInterface.getTip());
            } else {
                String string = dumpTableCellInterface.getPlainText();
                FontMetrics fontMetrics = component.getFontMetrics(component.getFont());
                int n4 = jTable.getColumnModel().getColumn(n3).getWidth();
                if (fontMetrics.stringWidth(string) > n4) {
                    ((JComponent)component).setToolTipText(object.toString());
                } else {
                    ((JComponent)component).setToolTipText(null);
                }
            }
        }
        return component;
    }
}

