/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.devices.dump.gui;

import com.mimvista.dicom.devices.dump.gui.DumpGuiFrame;
import com.mimvista.dicom.devices.dump.gui.NavigatorPanel;
import com.mimvista.dicom.devices.dump.newDump.NodeData;
import com.mimvista.dicom.devices.dump.newDump.TreeNodeData;
import com.mimvista.file.Path;
import com.mimvista.util.ay;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class GlobalNavigatorPanel
extends NavigatorPanel {
    private TreePath aPath = null;

    public GlobalNavigatorPanel(DumpGuiFrame dumpGuiFrame) {
        super(dumpGuiFrame);
    }

    @Override
    public String getConfigIdentifier() {
        return DumpGuiFrame.props.getProperty("GLOBAL_NAVIGATOR");
    }

    @Override
    protected TreeNode createDirectoryRoot(File file) {
        File[] fileArray;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new TreeNodeData("My Computer"));
        for (File file2 : fileArray = File.listRoots()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new TreeNodeData(file2));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode());
        }
        try {
            File securityException = new File(Path.getWindowsDesktopPath());
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new TreeNodeData(securityException));
            defaultMutableTreeNode.add(defaultMutableTreeNode3);
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode());
        }
        catch (SecurityException noSuchMethodException) {
            ay.d((Object)"Create desktop node failed!", (Throwable)noSuchMethodException, GlobalNavigatorPanel.class);
            noSuchMethodException.printStackTrace();
        }
        catch (NoSuchMethodException exception) {
            ay.d((Object)"Create desktop node failed!", (Throwable)exception, GlobalNavigatorPanel.class);
            exception.printStackTrace();
        }
        catch (Exception exception) {
            ay.d((Object)"Create desktop node failed!", (Throwable)exception, GlobalNavigatorPanel.class);
            exception.printStackTrace();
        }
        return defaultMutableTreeNode;
    }

    @Override
    protected void expandDirectoryTree(File[] fileArray) {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        for (File file : fileArray) {
            arrayList.add(this.openDirectoryTreeWithoutSelection(file));
        }
        this.isWillExpandEnabled = false;
        Serializable[] serializableArray = arrayList.toArray(new TreePath[0]);
        this.muteSetSelectionPaths((TreePath[])serializableArray);
        this.directoryTree.scrollPathToVisible((TreePath)serializableArray[serializableArray.length - 1]);
        this.isWillExpandEnabled = true;
    }

    private TreePath openDirectoryTreeWithoutSelection(File file) {
        ArrayList<File> arrayList = this.getAncestors(file);
        TreeNode treeNode = (TreeNode)this.directoryTree.getModel().getRoot();
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode2 = enumeration.nextElement();
            NodeData nodeData = (NodeData)((DefaultMutableTreeNode)treeNode2).getUserObject();
            if (nodeData == null) continue;
            File file2 = nodeData.getFile();
            try {
                if (!file2.getCanonicalFile().equals(arrayList.get(0).getCanonicalFile())) continue;
                arrayList.remove(0);
                this.expandDirectoryList(treeNode2, arrayList);
                break;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return this.aPath;
    }

    private void expandDirectoryList(TreeNode treeNode, ArrayList<File> arrayList) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode;
        if (!this.hasBeenExpanded(defaultMutableTreeNode)) {
            try {
                this.directoryTree.fireTreeWillExpand(new TreePath(this.model.getPathToRoot(treeNode)));
            }
            catch (ExpandVetoException expandVetoException) {
                expandVetoException.printStackTrace();
            }
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode2 = enumeration.nextElement();
            NodeData nodeData = (NodeData)((DefaultMutableTreeNode)treeNode2).getUserObject();
            if (nodeData == null) continue;
            if (arrayList.size() <= 0) break;
            File file = nodeData.getFile();
            try {
                if (!file.getCanonicalFile().equals(arrayList.get(0).getCanonicalFile())) continue;
                arrayList.remove(0);
                TreePath treePath = new TreePath(this.model.getPathToRoot(treeNode2));
                this.directoryTree.fireTreeExpanded(treePath);
                this.aPath = treePath;
                this.expandDirectoryList(treeNode2, arrayList);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private boolean hasBeenExpanded(DefaultMutableTreeNode defaultMutableTreeNode) {
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            File file;
            TreeNode treeNode = enumeration.nextElement();
            NodeData nodeData = (NodeData)((DefaultMutableTreeNode)treeNode).getUserObject();
            if (nodeData == null || (file = nodeData.getFile()) == null) continue;
            return true;
        }
        return false;
    }

    private ArrayList<File> getAncestors(File file) {
        File file2 = file;
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(file2);
        while (file2.getParentFile() != null) {
            file2 = file2.getParentFile();
            arrayList.add(0, file2);
        }
        return arrayList;
    }

    @Override
    protected File[] getSelectedFiles(File[] fileArray) {
        return fileArray;
    }
}

