/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.devices.dump.gui;

import com.mimvista.dicom.devices.dump.gui.DumpGuiFrame;
import com.mimvista.dicom.devices.dump.gui.UpdateInterface;
import com.mimvista.dicom.devices.dump.newDump.ListNodeData;
import com.mimvista.dicom.devices.dump.newDump.NodeData;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.mui.toolbar.SidePanel;
import com.mimvista.preferencesNew.DicomDumpHistoryPrefs;
import com.mimvista.preferencesNew.MIMPref;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class HistoryNavigatorPanel
extends SidePanel
implements UpdateInterface {
    public static final int HISTORY_CAPACITY = 20;
    private static final Messages props = Messages.a("Dump");
    private DumpGuiFrame ownerFrame;
    private DefaultListModel historyModel = new DefaultListModel();
    private JList historyList = new JList(this.historyModel);
    private JScrollPane scroll;

    public HistoryNavigatorPanel(DumpGuiFrame dumpGuiFrame) {
        this.ownerFrame = dumpGuiFrame;
        dumpGuiFrame.add(this);
        this.setName(this.getConfigIdentifier());
        this.setShowTitle(true);
        this.setIcon(ImageManipulator.a(Messages.a("PatientList").getProperty("GO_ICON"), 22));
        this.build();
        this.historyList.setSelectionMode(0);
        this.loadHistory();
    }

    @Override
    public void onShow() {
        int n2 = this.historyList.getWidth();
        this.loadHistory();
        Rectangle rectangle = new Rectangle(n2 - 1, 0, 1, 1);
        this.historyList.scrollRectToVisible(rectangle);
    }

    @Override
    public String getConfigIdentifier() {
        return props.getProperty("HISTORY_NAVIGATOR");
    }

    @Override
    public void updateFiles(File[] fileArray) {
        ListSelectionListener[] listSelectionListenerArray = this.removeSelectionListeners();
        for (File file : fileArray) {
            ListNodeData listNodeData = new ListNodeData(file);
            this.remove(listNodeData);
            this.historyModel.insertElementAt(listNodeData, 0);
            if (this.historyModel.size() <= 20) continue;
            this.historyModel.remove(20);
        }
        this.addSelectionListeners(listSelectionListenerArray);
        this.saveHistory();
    }

    private void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.weightx = 100.0;
        this.scroll = new JScrollPane(this.historyList);
        this.add((Component)this.scroll, gridBagConstraints);
        this.historyList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Object[] objectArray = HistoryNavigatorPanel.this.historyList.getSelectedValues();
                if (objectArray == null || objectArray.length == 0) {
                    return;
                }
                File[] fileArray = new File[objectArray.length];
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    fileArray[i2] = ((NodeData)objectArray[i2]).getFile();
                }
                HistoryNavigatorPanel.this.ownerFrame.update(fileArray, HistoryNavigatorPanel.this);
            }
        });
        this.setListRenderer();
    }

    private void setListRenderer() {
        DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n2, bl2, bl3);
                if (((NodeData)object).tooLong()) {
                    ((JComponent)component).setToolTipText(((NodeData)object).fullString());
                } else {
                    ((JComponent)component).setToolTipText(null);
                }
                return component;
            }
        };
        this.historyList.setCellRenderer(defaultListCellRenderer);
    }

    private void remove(NodeData nodeData) {
        for (int i2 = this.historyModel.size() - 1; i2 >= 0; --i2) {
            NodeData nodeData2 = (NodeData)this.historyModel.get(i2);
            if (!nodeData2.equals(nodeData)) continue;
            this.historyModel.removeElementAt(i2);
        }
    }

    private void saveHistory() {
        for (int i2 = 0; i2 < this.historyModel.getSize(); ++i2) {
            File file = ((ListNodeData)this.historyModel.getElementAt(i2)).getFile();
            try {
                DicomDumpHistoryPrefs.history.b(i2).setValue(file.getCanonicalPath());
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void loadHistory() {
        try {
            Collection collection = DicomDumpHistoryPrefs.history.c();
            this.historyModel.removeAllElements();
            for (MIMPref mIMPref : collection) {
                ListNodeData listNodeData = new ListNodeData(new File((String)mIMPref.getValue()));
                this.historyModel.addElement(listNodeData);
                if (this.historyModel.size() <= 20) continue;
                this.historyModel.remove(20);
            }
        }
        catch (Exception exception) {
            ay.c((Object)"unable to load dicom dump history", this);
        }
    }

    private void addSelectionListeners(ListSelectionListener[] listSelectionListenerArray) {
        for (ListSelectionListener listSelectionListener : listSelectionListenerArray) {
            this.historyList.addListSelectionListener(listSelectionListener);
        }
    }

    private ListSelectionListener[] removeSelectionListeners() {
        ListSelectionListener[] listSelectionListenerArray;
        for (ListSelectionListener listSelectionListener : listSelectionListenerArray = this.historyList.getListSelectionListeners()) {
            this.historyList.removeListSelectionListener(listSelectionListener);
        }
        return listSelectionListenerArray;
    }
}

