/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.devices.dump.gui;

import com.mimvista.dicom.DicomImageConverter;
import com.mimvista.dicom.devices.dump.gui.UpdateInterface;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.dicom.util.jpeg.DicomJpegDecompressor;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.media.FileMetaInformation;

public class ImageInternalFrame
extends JInternalFrame
implements UpdateInterface {
    private static final int IMAGE_HEIGHT = 200;
    private File[] files;
    private BufferedImage[] images = new BufferedImage[2];

    public ImageInternalFrame(File[] fileArray) {
        super("", true, false, true, true);
        this.updateFiles(fileArray);
        this.add(new ImagePanel());
        this.setSize(this.getImageFrameWidth(), this.getImageFrameHeight());
    }

    @Override
    public void updateFiles(File[] fileArray) {
        this.setTitle(ImageInternalFrame.getTitle(fileArray));
        this.files = fileArray;
        this.renewImages();
    }

    private int getImageFrameWidth() {
        int n2 = 0;
        for (BufferedImage bufferedImage : this.images) {
            if (bufferedImage == null || bufferedImage.getHeight() == 0) continue;
            int n3 = 200 * bufferedImage.getWidth() / bufferedImage.getHeight();
            n2 += n3;
        }
        return n2 + 20;
    }

    private int getImageFrameHeight() {
        return 240;
    }

    private static String getTitle(File[] fileArray) {
        if (fileArray.length == 1) {
            return ImageInternalFrame.getOneUserTitle(fileArray[0]);
        }
        String string = ImageInternalFrame.getOneUserTitle(fileArray[0]);
        String string2 = ImageInternalFrame.getOneUserTitle(fileArray[1]);
        if (string.length() != 0 && string2.length() != 0) {
            return string + " : " + string2;
        }
        return "";
    }

    private static String getOneUserTitle(File file) {
        DicomObject dicomObject = DicomReader.readFileIntoDicomObject(file, new DicomReader.FilteredTagInputHandler(new int[]{0x100010, 2097171}, DicomReader.FilteredTagInputHandler.FilterMode.INCLUDE));
        if (dicomObject == null) {
            return "";
        }
        String string = dicomObject.getString(0x100010);
        String string2 = dicomObject.getString(2097171);
        String string3 = "";
        if (string != null && string.length() != 0) {
            string3 = string2 != null && string2.length() != 0 ? string + "_" + string2 : string;
        } else if (string2 != null && string2.length() != 0) {
            string3 = string2;
        }
        return string3;
    }

    private void renewImages() {
        int n2;
        for (n2 = 0; n2 < this.images.length; ++n2) {
            this.images[n2] = null;
        }
        for (n2 = 0; n2 < this.files.length; ++n2) {
            File file = this.files[n2];
            if (file == null) continue;
            DicomObject dicomObject = DicomReader.readFileIntoDicomObject(file, new DicomReader.StopBeforeContentInputHandler(2145386513));
            if (dicomObject == null) {
                this.images[n2] = null;
                continue;
            }
            String string = new FileMetaInformation(dicomObject).getTransferSyntaxUID();
            if (string != null && DicomJpegDecompressor.isJpegCompressed(string)) {
                dicomObject = DicomJpegDecompressor.decompressFileToDicomObject(file.getAbsolutePath());
            }
            if (dicomObject == null) {
                this.images[n2] = null;
                continue;
            }
            try {
                this.images[n2] = DicomImageConverter.toBufferedImage(dicomObject);
                continue;
            }
            catch (RuntimeException runtimeException) {
                this.images[n2] = null;
            }
        }
    }

    class ImagePanel
    extends JPanel {
        ImagePanel() {
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.myPaint(graphics);
        }

        private void myPaint(Graphics graphics) {
            int n2 = 0;
            for (BufferedImage bufferedImageArray : ImageInternalFrame.this.images) {
                if (bufferedImageArray == null || bufferedImageArray.getHeight() == 0) continue;
                ++n2;
            }
            if (n2 == 0 || this.getHeight() == 0) {
                return;
            }
            int n3 = this.getWidth() / n2;
            int n4 = this.getHeight();
            int n5 = 0;
            for (BufferedImage bufferedImage : ImageInternalFrame.this.images) {
                int n6 = 0;
                int n7 = 0;
                if (bufferedImage == null || bufferedImage.getHeight() == 0) continue;
                if (n3 * bufferedImage.getHeight() > bufferedImage.getWidth() * n4) {
                    n6 = bufferedImage.getWidth() * n4 / bufferedImage.getHeight();
                    n7 = n4;
                } else {
                    n6 = n3;
                    n7 = bufferedImage.getHeight() * n3 / bufferedImage.getWidth();
                }
                graphics.drawImage(bufferedImage, n5, 0, n6, n7, this);
                n5 += n3;
            }
        }
    }
}

