/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.devices.dump.gui;

import com.mimvista.dicom.devices.dump.gui.DumpGuiFrame;
import com.mimvista.dicom.devices.dump.newDump.NodeData;
import com.mimvista.dicom.devices.dump.newDump.TreeNodeData;
import com.mimvista.dicom.devices.dump.util.DcmFileUtil;
import com.mimvista.dicom.read.FileExcluder;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.mui.toolbar.SidePanel;
import com.mimvista.osdep.GetOSPath;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class NavigatorPanel
extends SidePanel {
    private JScrollPane scrollPane;
    protected JTree directoryTree;
    protected DefaultTreeModel model;
    protected boolean isWillExpandEnabled = true;
    private TreePath primaryPath;
    private DumpGuiFrame dumpGuiFrame;

    public NavigatorPanel(DumpGuiFrame dumpGuiFrame) {
        this.dumpGuiFrame = dumpGuiFrame;
        this.setName(this.getConfigIdentifier());
        this.setShowTitle(true);
        this.setIcon(ImageManipulator.a(Messages.a("PatientList").getProperty("GO_ICON"), 22));
    }

    @Override
    public void onShow() {
        File[] fileArray = this.dumpGuiFrame.getTableManager().getFiles();
        File[] fileArray2 = this.getSelectedFiles(fileArray);
        this.build(fileArray2[0]);
        this.expandDirectoryTree(fileArray2);
        this.dumpGuiFrame.validate();
        this.dumpGuiFrame.repaint();
    }

    private void update(File[] fileArray) {
        if (fileArray == null) {
            return;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : fileArray) {
            if (!file.exists()) {
                this.warn(file);
                continue;
            }
            arrayList.add(file);
        }
        this.dumpGuiFrame.update(arrayList.toArray(new File[0]), this);
    }

    private void build(File file) {
        this.removeAll();
        TreeNode treeNode = this.createDirectoryRoot(file);
        this.model = new DefaultTreeModel(treeNode);
        this.directoryTree = new JTree(this.model);
        this.directoryTree.setRootVisible(false);
        this.directoryTree.setEditable(false);
        this.directoryTree.setExpandsSelectedPaths(true);
        this.directoryTree.getSelectionModel().setSelectionMode(4);
        ToolTipManager.sharedInstance().registerComponent(this.directoryTree);
        this.setTreeRenderer();
        this.scrollPane = new JScrollPane(this.directoryTree);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.weightx = 100.0;
        this.add((Component)this.scrollPane, gridBagConstraints);
        this.addListeners();
    }

    private void addListeners() {
        this.directoryTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                if (!NavigatorPanel.this.isWillExpandEnabled) {
                    return;
                }
                TreePath treePath = treeExpansionEvent.getPath();
                if (treePath == null) {
                    return;
                }
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                NodeData nodeData = (NodeData)defaultMutableTreeNode.getUserObject();
                File file = nodeData.getFile();
                if (file == null) {
                    return;
                }
                File[] fileArray = file.listFiles(new FileExcluder().getFilenameFilter());
                if (fileArray == null || fileArray.length == 0) {
                    return;
                }
                defaultMutableTreeNode.removeAllChildren();
                for (File file2 : fileArray) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new TreeNodeData(file2));
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                    if (!file2.isDirectory()) continue;
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode());
                }
                NavigatorPanel.this.model.reload(defaultMutableTreeNode);
            }
        });
        this.directoryTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            }
        });
        this.directoryTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                TreePath treePath = NavigatorPanel.this.directoryTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath == null) {
                    return;
                }
                if (this.multiSelectValid(mouseEvent)) {
                    NavigatorPanel.this.directoryTree.setSelectionPaths(new TreePath[]{NavigatorPanel.this.primaryPath, treePath});
                } else {
                    NavigatorPanel.this.primaryPath = treePath;
                    NavigatorPanel.this.directoryTree.setSelectionPaths(new TreePath[]{treePath});
                }
            }

            private boolean multiSelectValid(MouseEvent mouseEvent) {
                if (GetOSPath.isMacOs()) {
                    return this.commandPressed(mouseEvent) || this.shiftPressed(mouseEvent);
                }
                return this.ctrlPressed(mouseEvent) || this.shiftPressed(mouseEvent);
            }

            private boolean ctrlPressed(MouseEvent mouseEvent) {
                return (mouseEvent.getModifiersEx() & 0x80) != 0;
            }

            private boolean shiftPressed(MouseEvent mouseEvent) {
                int n2 = 64;
                return (mouseEvent.getModifiersEx() & n2) != 0;
            }

            private boolean commandPressed(MouseEvent mouseEvent) {
                return (mouseEvent.getModifiersEx() & 0x100) != 0;
            }
        });
        this.directoryTree.addKeyListener(new KeyAdapter(){
            TreePath[] paths = null;

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                this.paths = NavigatorPanel.this.directoryTree.getSelectionPaths();
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                this.paths = NavigatorPanel.this.directoryTree.getSelectionPaths();
                int n2 = keyEvent.getKeyCode();
                if (n2 == 38 || n2 == 40) {
                    if (this.paths.length == 1) {
                        int n3 = NavigatorPanel.this.directoryTree.getRowForPath(NavigatorPanel.this.primaryPath);
                        if (n2 == 38 && n3 >= 1) {
                            NavigatorPanel.this.primaryPath = NavigatorPanel.this.directoryTree.getPathForRow(n3 - 1);
                            NavigatorPanel.this.directoryTree.setSelectionPath(NavigatorPanel.this.primaryPath);
                            NavigatorPanel.this.directoryTree.scrollRowToVisible(n3 - 1);
                        } else if (n2 == 40 && n3 < NavigatorPanel.this.directoryTree.getRowCount() - 1) {
                            NavigatorPanel.this.primaryPath = NavigatorPanel.this.directoryTree.getPathForRow(n3 + 1);
                            NavigatorPanel.this.directoryTree.setSelectionPath(NavigatorPanel.this.primaryPath);
                            NavigatorPanel.this.directoryTree.scrollRowToVisible(n3 + 1);
                        }
                    } else if (this.paths.length == 2) {
                        TreePath treePath = null;
                        for (TreePath treePath2 : this.paths) {
                            if (treePath2.equals(NavigatorPanel.this.primaryPath)) continue;
                            treePath = treePath2;
                            break;
                        }
                        int n4 = NavigatorPanel.this.directoryTree.getRowForPath(NavigatorPanel.this.primaryPath);
                        int n5 = NavigatorPanel.this.directoryTree.getRowForPath(treePath);
                        if (n2 == 38 && n5 >= 1) {
                            NavigatorPanel.this.directoryTree.setSelectionRows(new int[]{n4, n5 - 1});
                            NavigatorPanel.this.directoryTree.scrollRowToVisible(n5 - 1);
                        } else if (n2 == 40 && n5 < NavigatorPanel.this.directoryTree.getRowCount() - 1) {
                            NavigatorPanel.this.directoryTree.setSelectionRows(new int[]{n4, n5 + 1});
                            NavigatorPanel.this.directoryTree.scrollRowToVisible(n5 + 1);
                        }
                    }
                }
                keyEvent.consume();
            }
        });
        this.directoryTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath[] treePathArray = this.getSelectedDcmPaths();
                if (treePathArray == null) {
                    return;
                }
                if (treePathArray.length == 1) {
                    File file = NavigatorPanel.this.getFile(treePathArray[0]);
                    NavigatorPanel.this.update(new File[]{file});
                } else if (treePathArray.length == 2) {
                    TreePath treePath = null;
                    for (TreePath treePath2 : treePathArray) {
                        if (treePath2.equals(NavigatorPanel.this.primaryPath)) continue;
                        treePath = treePath2;
                        break;
                    }
                    File file = NavigatorPanel.this.getFile(NavigatorPanel.this.primaryPath);
                    File file2 = NavigatorPanel.this.getFile(treePath);
                    NavigatorPanel.this.update(new File[]{file, file2});
                }
            }

            private TreePath[] getSelectedDcmPaths() {
                TreePath[] treePathArray = NavigatorPanel.this.directoryTree.getSelectionPaths();
                if (treePathArray == null) {
                    return null;
                }
                ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
                for (TreePath treePath : treePathArray) {
                    if (!DcmFileUtil.isDcmFile(NavigatorPanel.this.getFile(treePath))) continue;
                    arrayList.add(treePath);
                }
                treePathArray = arrayList.toArray(new TreePath[0]);
                if (treePathArray.length == 0) {
                    treePathArray = null;
                }
                return treePathArray;
            }
        });
    }

    protected synchronized void muteSetSelectionPaths(TreePath[] treePathArray) {
        TreeSelectionListener[] treeSelectionListenerArray = this.removeSelectionListeners();
        this.directoryTree.setSelectionPaths(treePathArray);
        this.primaryPath = treePathArray[0];
        this.addSelectionListeners(treeSelectionListenerArray);
    }

    private void addSelectionListeners(TreeSelectionListener[] treeSelectionListenerArray) {
        for (TreeSelectionListener treeSelectionListener : treeSelectionListenerArray) {
            this.directoryTree.addTreeSelectionListener(treeSelectionListener);
        }
    }

    private TreeSelectionListener[] removeSelectionListeners() {
        TreeSelectionListener[] treeSelectionListenerArray;
        for (TreeSelectionListener treeSelectionListener : treeSelectionListenerArray = this.directoryTree.getTreeSelectionListeners()) {
            this.directoryTree.removeTreeSelectionListener(treeSelectionListener);
        }
        return treeSelectionListenerArray;
    }

    private File getFile(TreePath treePath) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        NodeData nodeData = (NodeData)defaultMutableTreeNode.getUserObject();
        File file = nodeData.getFile();
        return file;
    }

    private void setTreeRenderer() {
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
                Component component = super.getTreeCellRendererComponent(jTree, object, bl2, bl3, bl4, n2, bl5);
                Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
                if (object2 == null) {
                    this.setIcon(null);
                } else if (((NodeData)object2).tooLong()) {
                    ((JComponent)component).setToolTipText(((NodeData)object2).fullString());
                } else {
                    ((JComponent)component).setToolTipText(null);
                }
                return component;
            }
        };
        this.directoryTree.setCellRenderer(defaultTreeCellRenderer);
    }

    private void warn(File file) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setSize(500, 400);
        jTextArea.setText(MIMFormat.a(DumpGuiFrame.props.getProperty("DIRECTORY_PANEL_NOT_FOUND"), file.getAbsolutePath()));
        jTextArea.setEditable(false);
        JOptionPane.showMessageDialog(this.getParent(), jTextArea);
    }

    protected abstract File[] getSelectedFiles(File[] var1);

    protected abstract void expandDirectoryTree(File[] var1);

    protected abstract TreeNode createDirectoryRoot(File var1);
}

