/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.devices.dump.gui;

import com.mimvista.dicom.devices.dump.gui.DumpGuiFrame;
import com.mimvista.dicom.devices.dump.newDump.Attribute;
import com.mimvista.dicom.devices.dump.newDump.AttributeExtractor;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.mui.MIMFileDialog;
import com.mimvista.properties.ab;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.DefaultTableModel;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.util.StringUtils;

public class PixelDataDialog
extends JDialog {
    public static final int CHARS_PER_ROW = 150;
    private DumpGuiFrame sourceFrame;
    private DefaultTableModel model;
    private HorizontalBarTable table;
    private JButton saveButton = new JButton(DumpGuiFrame.props.getProperty("PIXEL_SAVE"), ImageManipulator.c("save", 18));
    private JButton closeButton = new JButton(DumpGuiFrame.props.getProperty("PIXEL_CLOSE"), ImageManipulator.c("x_red", 18));
    private Attribute attr;
    private static String outputFolderName;

    public PixelDataDialog(DumpGuiFrame dumpGuiFrame, Attribute attribute) {
        super(dumpGuiFrame, attribute.getName(), false);
        this.sourceFrame = dumpGuiFrame;
        this.attr = attribute;
        this.model = new DefaultTableModel(0, 1);
        this.setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PixelDataDialog.this.model = null;
                PixelDataDialog.this.removeAll();
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                PixelDataDialog.this.model = null;
                PixelDataDialog.this.removeAll();
            }
        });
        this.open();
    }

    private void open() {
        this.table = new HorizontalBarTable(this.model);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(1000);
        this.add(new JScrollPane(this.table), 1, 100, 100, 0, 0);
        PixelDataButtonsPanel pixelDataButtonsPanel = new PixelDataButtonsPanel();
        this.add(pixelDataButtonsPanel, 0, 0, 0, 0, 1);
        this.pack();
        Point point = this.sourceFrame.getLocation();
        Dimension dimension = this.sourceFrame.getSize();
        Dimension dimension2 = this.getSize();
        this.setLocation(point.x + (dimension.width - dimension2.width) / 2, point.y + (dimension.height - dimension2.height) / 2);
        this.setVisible(true);
        final DicomElement dicomElement = this.attr.getDcmElement();
        new Thread(){

            @Override
            public void run() {
                if (!PixelDataDialog.this.isVisible()) {
                    return;
                }
                OutputWriterToTable outputWriterToTable = new OutputWriterToTable();
                try {
                    PixelDataDialog.this.updateStringsToWriter(dicomElement, outputWriterToTable);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }.start();
    }

    private void saveFile(final String string) {
        final DicomElement dicomElement = this.attr.getDcmElement();
        new Thread(){

            @Override
            public void run() {
                File file = new File(string);
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                    OutputWriterToFile outputWriterToFile = new OutputWriterToFile(bufferedWriter);
                    PixelDataDialog.this.updateStringsToWriter(dicomElement, outputWriterToFile);
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(PixelDataDialog.this, DumpGuiFrame.props.getProperty("PIXEL_ERROR"), "", 2);
                    iOException.printStackTrace();
                }
            }
        }.start();
    }

    private void updateStringsToWriter(DicomElement dicomElement, OutputWriter outputWriter) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(StringUtils.join((String[])AttributeExtractor.getFullValues(dicomElement), (char)'\\'));
        while (stringBuffer.length() > 150) {
            outputWriter.write(stringBuffer.substring(0, 150));
            stringBuffer.replace(0, 150, "");
        }
        outputWriter.write(stringBuffer.toString());
    }

    private void add(Component component, int n2, int n3, int n4, int n5, int n6) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (n2 != -100) {
            gridBagConstraints.fill = n2;
        }
        if (n3 != -100) {
            gridBagConstraints.weightx = n3;
        }
        if (n4 != -100) {
            gridBagConstraints.weighty = n4;
        }
        if (n5 != -100) {
            gridBagConstraints.gridx = n5;
        }
        if (n6 != -100) {
            gridBagConstraints.gridy = n6;
        }
        this.add(component, gridBagConstraints);
    }

    private String getSaveFileName() {
        String string = this.getSavePrefix(this.attr.getFile()) + this.attr.getName() + ".txt";
        string = string.replaceAll("\\s", "");
        return string;
    }

    private String getSavePrefix(File file) {
        DicomObject dicomObject = DicomReader.readFileIntoDicomObject(file);
        if (dicomObject == null) {
            return "";
        }
        String string = dicomObject.getString(0x100010);
        String string2 = dicomObject.getString(0x100020);
        String string3 = dicomObject.getString(524384);
        String string4 = dicomObject.getString(524320);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        simpleDateFormat.applyPattern("yyMMddHHmmssSSS");
        String string5 = simpleDateFormat.format(System.currentTimeMillis());
        return string + "_" + string2 + "_" + string3 + "_" + string4 + "_" + string5 + "_";
    }

    private File getDefaultFolder() {
        return new File(ab.m());
    }

    class HorizontalBarTable
    extends JTable {
        public HorizontalBarTable(DefaultTableModel defaultTableModel) {
            super(defaultTableModel);
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            if (this.autoResizeMode != 0 && this.getParent() instanceof JViewport) {
                return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
            }
            return false;
        }
    }

    private class OutputWriterToFile
    extends OutputWriter {
        private Writer writer;

        public OutputWriterToFile(Writer writer) {
            this.writer = writer;
        }

        @Override
        protected void write(String string) throws IOException {
            this.writer.write(string);
        }
    }

    private class OutputWriterToTable
    extends OutputWriter {
        private OutputWriterToTable() {
        }

        @Override
        protected void write(String string) {
            Vector<String> vector = new Vector<String>();
            vector.add(string);
            if (PixelDataDialog.this.model != null) {
                PixelDataDialog.this.model.addRow(vector);
            }
        }
    }

    private abstract class OutputWriter {
        private OutputWriter() {
        }

        protected abstract void write(String var1) throws IOException;
    }

    class PixelDataButtonsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public PixelDataButtonsPanel() {
            this.setLayout(new FlowLayout(2));
            this.add(PixelDataDialog.this.saveButton);
            this.add(PixelDataDialog.this.closeButton);
            PixelDataDialog.this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PixelDataDialog.this.dispose();
                }
            });
            PixelDataDialog.this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MIMFileDialog mIMFileDialog = MIMFileDialog.a(PixelDataDialog.this.sourceFrame, DumpGuiFrame.props.getProperty("PIXEL_SAVE_ATTRIBUTE"), MIMFileDialog.FileDialogType.b, true);
                    if (outputFolderName == null || outputFolderName.trim().equals("")) {
                        mIMFileDialog.b(PixelDataDialog.this.getDefaultFolder().getAbsolutePath());
                    } else {
                        mIMFileDialog.b(outputFolderName);
                    }
                    mIMFileDialog.a(PixelDataDialog.this.getSaveFileName());
                    mIMFileDialog.a(true);
                    String string = mIMFileDialog.a();
                    if (string == null) {
                        return;
                    }
                    outputFolderName = new File(string).getParent();
                    PixelDataDialog.this.saveFile(string);
                    PixelDataDialog.this.dispose();
                }
            });
        }
    }
}

