/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.devices.dump.gui;

import com.mimvista.dicom.devices.dump.gui.DumpCopyMenuItemHandler;
import com.mimvista.dicom.devices.dump.gui.DumpGuiFrame;
import com.mimvista.dicom.devices.dump.gui.DumpTableCellRenderer;
import com.mimvista.dicom.devices.dump.gui.SeriesTablePanel;
import com.mimvista.dicom.devices.dump.gui.TableColumnAdjuster;
import com.mimvista.dicom.devices.dump.gui.TableCopyHandler;
import com.mimvista.dicom.devices.dump.newDump.Attribute;
import com.mimvista.dicom.devices.dump.newDump.AttributeSeriesViewTableItem;
import com.mimvista.dicom.devices.dump.newDump.HeaderTableItem;
import com.mimvista.dicom.devices.dump.newDump.SeriesDifferenceExtractor;
import com.mimvista.dicom.devices.dump.newDump.StringSeriesViewTableItem;
import com.mimvista.dicom.devices.dump.newDump.TableItem;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public class SeriesFilesTable {
    private DefaultTableModel model;
    private JTable jtable;
    private File file;
    private DumpGuiFrame dumpGuiFrame;
    private SeriesTablePanel seriesTablePanel;

    public SeriesFilesTable(File file, SeriesTablePanel seriesTablePanel, DumpGuiFrame dumpGuiFrame) {
        this.file = file;
        this.dumpGuiFrame = dumpGuiFrame;
        this.seriesTablePanel = seriesTablePanel;
        this.build();
        this.populateTable();
    }

    private void build() {
        this.createModel();
        this.createTable();
        this.addTableListener();
    }

    private void createModel() {
        this.model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int n2, int n3) {
                return false;
            }
        };
    }

    private void createTable() {
        this.jtable = new JTable(this.model){
            private static final long serialVersionUID = -627468992841987962L;

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return this.getPreferredSize().width < this.getParent().getWidth();
            }
        };
        this.jtable.setDefaultRenderer(Object.class, new DumpTableCellRenderer());
        this.jtable.setRowSorter(new TableRowSorter(this.model){

            @Override
            public Comparator<?> getComparator(int n2) {
                Attribute attribute = null;
                if (SeriesFilesTable.this.model.getRowCount() > 0 && SeriesFilesTable.this.model.getValueAt(0, n2) instanceof AttributeSeriesViewTableItem) {
                    attribute = ((AttributeSeriesViewTableItem)SeriesFilesTable.this.model.getValueAt(0, n2)).getAttribute();
                }
                if (attribute != null && attribute.getTag().equals("(0020,0013)")) {
                    return new Comparator(){

                        public int compare(Object object, Object object2) {
                            return Integer.parseInt((String)object) - Integer.parseInt((String)object2);
                        }
                    };
                }
                return super.getComparator(n2);
            }
        });
        this.jtable.getActionMap().put("copy", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DumpCopyMenuItemHandler.copyTable(SeriesFilesTable.this.jtable);
            }
        });
        this.jtable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SeriesFilesTable.this.jtable.addColumnSelectionInterval(0, SeriesFilesTable.this.jtable.getColumnCount() - 1);
            }
        });
        TableCopyHandler tableCopyHandler = new TableCopyHandler(this.jtable);
        tableCopyHandler.addMenuItemHandler(new DumpCopyMenuItemHandler(this.jtable));
    }

    private void populateTable() {
        ArrayList<ArrayList<Attribute>> arrayList = new SeriesDifferenceExtractor(this.file.getParentFile().getAbsolutePath()).extract();
        ArrayList<ArrayList<Attribute>> arrayList2 = SeriesDifferenceExtractor.filterTopLevel(arrayList);
        TreeSet<String> treeSet = SeriesDifferenceExtractor.diffTags(arrayList2);
        ArrayList<ArrayList<Attribute>> arrayList3 = SeriesDifferenceExtractor.filterDiff(arrayList2, treeSet);
        ArrayList<ArrayList<Attribute>> arrayList4 = SeriesDifferenceExtractor.filterPrivate(arrayList3);
        ArrayList<ArrayList<Attribute>> arrayList5 = SeriesDifferenceExtractor.filterGroupTag(arrayList4);
        ArrayList<ArrayList<Attribute>> arrayList6 = SeriesDifferenceExtractor.reorderTags(arrayList5);
        this.addTableColumns(arrayList6.get(0));
        int n2 = 1;
        for (ArrayList<Attribute> arrayList7 : arrayList6) {
            this.addTableRow(arrayList7, n2++, arrayList6.size());
        }
        this.adjustColumnWidth();
    }

    private void adjustColumnWidth() {
        this.jtable.setAutoResizeMode(0);
        TableColumnAdjuster tableColumnAdjuster = new TableColumnAdjuster(this.jtable);
        tableColumnAdjuster.setLastColumnAdjusted(false);
        tableColumnAdjuster.adjustColumns();
    }

    private void addTableListener() {
        this.jtable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 1) {
                    Point point = mouseEvent.getPoint();
                    int n2 = SeriesFilesTable.this.jtable.rowAtPoint(point);
                    AttributeSeriesViewTableItem attributeSeriesViewTableItem = (AttributeSeriesViewTableItem)SeriesFilesTable.this.jtable.getValueAt(n2, 1);
                    Attribute attribute = attributeSeriesViewTableItem.getAttribute();
                    File file = attribute.getFile();
                    SeriesFilesTable.this.dumpGuiFrame.update(new File[]{file}, SeriesFilesTable.this.seriesTablePanel);
                }
            }
        });
    }

    private void addTableRow(ArrayList<Attribute> arrayList, int n2, int n3) {
        Vector<TableItem> vector = new Vector<TableItem>();
        for (Attribute attribute : arrayList) {
            vector.add(new AttributeSeriesViewTableItem(attribute));
        }
        if (arrayList.size() != 0) {
            String string = arrayList.get(0).getFile().getName();
            int n4 = string.length() > 7 ? string.length() - 7 : 0;
            vector.add(new StringSeriesViewTableItem("~" + string.substring(n4), string));
        }
        this.model.addRow(vector);
    }

    private void addTableColumns(ArrayList<Attribute> arrayList) {
        Object object;
        for (int i2 = 0; i2 < arrayList.size() + 1; ++i2) {
            this.model.addColumn("");
        }
        ArrayList<HeaderTableItem> arrayList2 = new ArrayList<HeaderTableItem>();
        for (Attribute attribute : arrayList) {
            if (attribute.getTag().equals("(0020,0013)")) {
                arrayList2.add(new HeaderTableItem("Img#", attribute.getName().concat(attribute.getTag())));
                continue;
            }
            object = attribute.getName() + " " + attribute.getTag();
            arrayList2.add(new HeaderTableItem((String)object, (String)object));
        }
        arrayList2.add(new HeaderTableItem("File Name", ""));
        TableColumnModel tableColumnModel = this.jtable.getColumnModel();
        for (int i3 = 0; i3 < tableColumnModel.getColumnCount(); ++i3) {
            object = tableColumnModel.getColumn(i3);
            ((TableColumn)object).setHeaderValue(arrayList2.get(i3));
            ((TableColumn)object).setHeaderRenderer(this.getHeaderRenderer());
        }
    }

    private DefaultTableCellRenderer getHeaderRenderer() {
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 6989429440534838328L;

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
                ((JComponent)component).setToolTipText(((HeaderTableItem)object).getTip());
                return component;
            }
        };
        return defaultTableCellRenderer;
    }

    public JTable getJTable() {
        return this.jtable;
    }
}

