/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.devices.dump.gui;

import com.mimvista.dicom.devices.dump.gui.DumpGuiFrame;
import com.mimvista.dicom.devices.dump.gui.NavigatorPanel;
import com.mimvista.dicom.devices.dump.newDump.NodeData;
import com.mimvista.dicom.devices.dump.newDump.TreeNodeData;
import com.mimvista.dicom.read.FileExcluder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SeriesNavigatorPanel
extends NavigatorPanel {
    public SeriesNavigatorPanel(DumpGuiFrame dumpGuiFrame) {
        super(dumpGuiFrame);
    }

    @Override
    public String getConfigIdentifier() {
        return DumpGuiFrame.props.getProperty("SERIES_NAVIGATOR");
    }

    @Override
    protected TreeNode createDirectoryRoot(File file) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new TreeNodeData("My Computer"));
        for (File file2 : file.getParentFile().listFiles(new FileExcluder().getFilenameFilter())) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new TreeNodeData(file2));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode;
    }

    @Override
    protected void expandDirectoryTree(File[] fileArray) {
        TreePath[] treePathArray = new TreePath[fileArray.length];
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            TreeNode treeNode = (TreeNode)this.directoryTree.getModel().getRoot();
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode2 = enumeration.nextElement();
                NodeData nodeData = (NodeData)((DefaultMutableTreeNode)treeNode2).getUserObject();
                File file = nodeData.getFile();
                if (!file.getAbsolutePath().equals(fileArray[i2].getAbsolutePath())) continue;
                treePathArray[i2] = new TreePath(this.model.getPathToRoot(treeNode2));
            }
        }
        this.muteSetSelectionPaths(treePathArray);
    }

    @Override
    protected File[] getSelectedFiles(File[] fileArray) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : fileArray) {
            try {
                if (!file.getParentFile().getCanonicalFile().equals(fileArray[0].getParentFile().getCanonicalFile())) continue;
                arrayList.add(file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return arrayList.toArray(new File[0]);
    }
}

