/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.devices.dump.gui;

import com.mimvista.dicom.devices.dump.gui.DumpGuiFrame;
import com.mimvista.dicom.devices.dump.gui.SeriesFilesTable;
import com.mimvista.dicom.devices.dump.gui.UpdateInterface;
import com.mimvista.dicom.devices.dump.util.DcmFileUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.io.File;
import javax.swing.JDesktopPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class SeriesTablePanel
extends JPanel
implements UpdateInterface {
    private DumpGuiFrame dumpGuiFrame;
    private JDesktopPane layeredPane;
    private GridBagConstraints gs = new GridBagConstraints();
    private File file;
    private JScrollPane scroll;
    private SeriesFilesTable seriesFilesTable;

    public SeriesTablePanel(DumpGuiFrame dumpGuiFrame) {
        this.dumpGuiFrame = dumpGuiFrame;
        this.dumpGuiFrame.add(this);
        this.layeredPane = new JDesktopPane();
        this.setLayout(new GridBagLayout());
        this.gs.fill = 1;
        this.gs.weighty = 100.0;
        this.gs.weightx = 100.0;
        this.add((Component)this.layeredPane, this.gs);
        this.setBackground(Color.WHITE);
    }

    @Override
    public void updateFiles(final File[] fileArray) {
        new Thread(){

            @Override
            public void run() {
                if (fileArray[0].getParentFile().listFiles(DcmFileUtil.getDcmFilter()).length <= 1) {
                    return;
                }
                if (SeriesTablePanel.this.file == null || !SeriesTablePanel.this.file.getParentFile().getAbsolutePath().equals(fileArray[0].getParentFile().getAbsolutePath())) {
                    SeriesTablePanel.this.file = fileArray[0];
                    SeriesTablePanel.this.reload();
                } else if (!SeriesTablePanel.this.file.getAbsolutePath().equals(fileArray[0].getAbsolutePath())) {
                    SeriesTablePanel.this.file = fileArray[0];
                } else {
                    return;
                }
                SeriesTablePanel.this.validate();
                SeriesTablePanel.this.repaint();
            }
        }.start();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Rectangle rectangle = this.layeredPane.getBounds();
        if (this.scroll != null) {
            this.scroll.setBounds(rectangle);
            this.scroll.setLocation(0, 0);
            this.scroll.validate();
        }
    }

    private void reload() {
        if (this.scroll != null && this.scroll.getParent() == this.layeredPane) {
            this.layeredPane.remove(this.scroll);
        }
        this.seriesFilesTable = new SeriesFilesTable(this.file, this, this.dumpGuiFrame);
        this.scroll = new JScrollPane(this.seriesFilesTable.getJTable());
        this.layeredPane.add((Component)this.scroll, new Integer(1));
        this.scroll.setOpaque(true);
    }
}

