/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.devices.dump.gui;

import com.mimvista.dicom.devices.dump.gui.DumpGuiFrame;
import com.mimvista.dicom.devices.dump.gui.SeriesTablePanel;
import com.mimvista.dicom.devices.dump.util.DcmFileUtil;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.util.MIMFormat;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import javax.swing.JFrame;

public class SeriesViewFrame
extends JFrame {
    private static final long serialVersionUID = -786627083622377545L;
    private DumpGuiFrame dumpGuiFrame;
    private SeriesTablePanel seriesTablePanel;

    public SeriesViewFrame(DumpGuiFrame dumpGuiFrame, File file) {
        ImageManipulator.a(this);
        this.dumpGuiFrame = dumpGuiFrame;
        this.setMinimumSize(new Dimension(1000, 800));
        this.deploy(file);
        this.display();
    }

    public void deploy(File file) {
        this.setTitle(MIMFormat.a(DumpGuiFrame.props.getProperty("DICOM_SERIES_VIEW"), DcmFileUtil.getPatientName(file)));
        this.build(file);
        this.seriesTablePanel.updateFiles(new File[]{file});
        this.setVisible(true);
    }

    private void build(File file) {
        this.addSeriesTablePanel();
    }

    private void addSeriesTablePanel() {
        if (this.seriesTablePanel != null && this.seriesTablePanel.getParent() == this) {
            this.remove(this.seriesTablePanel);
        }
        this.seriesTablePanel = new SeriesTablePanel(this.dumpGuiFrame);
        this.add((Component)this.seriesTablePanel, "Center");
    }

    private void display() {
        this.pack();
        this.setExtendedState(6);
        this.setVisible(true);
    }
}

