/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.devices.dump.gui;

import com.mimvista.dicom.devices.dump.gui.TableManager;
import com.mimvista.dicom.devices.dump.gui.TablePanel;
import com.mimvista.dicom.devices.dump.newDump.Attribute;
import com.mimvista.dicom.devices.dump.newDump.AttributeExtractor;
import com.mimvista.dicom.devices.dump.newDump.AttributePath;
import com.mimvista.dicom.devices.dump.newDump.TableItem;
import com.mimvista.util.Messages;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.dcm4che2.util.StringUtils;

public class SingleFileTable
extends TableManager {
    public static Messages DUMP = Messages.a("Dump");
    private static String[] COLUMN_NAMES = new String[]{"", DUMP.getProperty("ATTRIB_TAG"), DUMP.getProperty("ATTRIB_VR"), DUMP.getProperty("ATTRIB_VM"), DUMP.getProperty("ATTRIB_NAME"), DUMP.getProperty("ATTRIB_VALUES")};
    private static final int ATTRNAME_COLUMN_WIDTH = 250;
    private static final int VALUES_COLUMN_WIDTH = 3000;
    private File file;
    private ArrayList<Attribute> originalAttrList;
    private ArrayList<Attribute> visibleAttrList;

    public SingleFileTable(File file, TablePanel tablePanel) {
        this.tablePanel = tablePanel;
        this.file = file;
        this.build();
        AttributeExtractor attributeExtractor = new AttributeExtractor(file, true);
        this.originalAttrList = attributeExtractor.extractAttributeList();
        this.populateTable();
    }

    @Override
    public void setCollapsed(boolean bl2) {
        for (Attribute attribute : this.originalAttrList) {
            if (!attribute.getSq()) continue;
            attribute.setCollapsed(bl2);
        }
        this.populateTable();
    }

    @Override
    public boolean isSavable() {
        return true;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public File[] getFiles() {
        return new File[]{this.file};
    }

    @Override
    protected void populateTable() {
        if (this.originalAttrList == null) {
            return;
        }
        this.clearTable();
        this.visibleAttrList = this.originalAttrList;
        this.filter();
        for (Attribute attribute : this.visibleAttrList) {
            this.addItem(attribute);
        }
        this.adjustColumnWidth();
    }

    private void filter() {
        if (this.tablePanel.getFilterString().trim().length() == 0) {
            if (this.isPrivateHidden) {
                this.filterPrivate();
            }
            this.filterSq();
        } else {
            this.filterSpecific();
        }
    }

    private void filterSpecific() {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        String string = this.tablePanel.getFilterString().toLowerCase();
        for (Attribute attribute : this.originalAttrList) {
            attribute.setCollapsed(false);
            if (this.tablePanel.isFilteringName()) {
                if (!attribute.getName().toLowerCase().contains(string)) continue;
                arrayList.add(attribute);
                continue;
            }
            if (attribute.getValues().length == 0 || !StringUtils.join((String[])attribute.getValues(), (char)'\\').toLowerCase().contains(string)) continue;
            arrayList.add(attribute);
        }
        this.visibleAttrList = arrayList;
    }

    private void filterSq() {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        AttributePath attributePath = null;
        for (Attribute attribute : this.visibleAttrList) {
            if (attributePath == null) {
                arrayList.add(attribute);
                if (!attribute.getSq() || !attribute.isCollapsed()) continue;
                attributePath = (AttributePath)attribute.getPath().clone();
                continue;
            }
            if (attributePath.contains(attribute.getPath())) continue;
            arrayList.add(attribute);
            if (attribute.getSq() && attribute.isCollapsed()) {
                attributePath = (AttributePath)attribute.getPath().clone();
                continue;
            }
            attributePath = null;
        }
        this.visibleAttrList = arrayList;
    }

    private void filterPrivate() {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        for (Attribute attribute : this.visibleAttrList) {
            if (attribute.getPrivate()) continue;
            arrayList.add(attribute);
        }
        this.visibleAttrList = arrayList;
    }

    private void addItem(Attribute attribute) {
        Vector<TableItem> vector = new Vector<TableItem>();
        int n2 = attribute.getPath().getLevel();
        vector.add(new TableItem(this.getExpandToken(attribute), attribute.getId(), attribute));
        vector.add(new TableItem(this.getIndentStr(n2) + attribute.getTag(), attribute.getId(), attribute));
        vector.add(new TableItem(attribute.getVrName(), attribute.getId(), attribute));
        vector.add(new TableItem("   " + attribute.getVm(), attribute.getId(), attribute));
        vector.add(new TableItem(this.getIndentStr(n2 - 1) + attribute.getName(), attribute.getId(), attribute));
        vector.add(new TableItem(attribute.getValues(), attribute.getId(), attribute, attribute.getReadableUid(), attribute.getReadableValues(), null));
        this.model.addRow(vector);
    }

    private String getExpandToken(Attribute attribute) {
        if (attribute.getSq()) {
            return attribute.isCollapsed() ? "+" : "-";
        }
        return "";
    }

    @Override
    protected void createModel() {
        this.model = new DefaultTableModel(COLUMN_NAMES, 0){

            @Override
            public boolean isCellEditable(int n2, int n3) {
                return false;
            }
        };
    }

    @Override
    protected void addTableListener() {
        this.jtable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    Point point = mouseEvent.getPoint();
                    int n2 = SingleFileTable.this.jtable.rowAtPoint(point);
                    int n3 = SingleFileTable.this.jtable.columnAtPoint(point);
                    TableItem tableItem = (TableItem)SingleFileTable.this.jtable.getValueAt(n2, 0);
                    Attribute attribute = tableItem.getAttribute();
                    if (attribute.getSq()) {
                        attribute.setCollapsed(!attribute.isCollapsed());
                        SingleFileTable.this.populateTable();
                    }
                }
            }
        });
    }
}

