/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.devices.dump.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableColumnAdjuster
implements PropertyChangeListener,
TableModelListener {
    private JTable table;
    private int spacing;
    private boolean isColumnHeaderIncluded;
    private boolean isColumnDataIncluded;
    private boolean isOnlyAdjustLarger;
    private boolean isDynamicAdjustment;
    private boolean isLastColumnAdjusted;
    private Map<TableColumn, Integer> columnSizes = new HashMap<TableColumn, Integer>();
    private int defaultMaxWidth = 300;
    private boolean setPreferredWidth = false;
    private boolean setMinWidth = false;

    public TableColumnAdjuster(JTable jTable) {
        this(jTable, 6);
    }

    public TableColumnAdjuster(JTable jTable, int n2) {
        this.table = jTable;
        this.spacing = n2;
        this.setColumnHeaderIncluded(false);
        this.setColumnDataIncluded(true);
        this.setOnlyAdjustLarger(false);
        this.setDynamicAdjustment(false);
        this.setLastColumnAdjusted(true);
        this.installActions();
    }

    public void adjustColumns() {
        this.adjustColumns(false);
    }

    public void adjustColumns(boolean bl2) {
        this.adjustColumns(bl2, 0.0f);
    }

    public void adjustColumns(boolean bl2, float f2) {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        if (bl2) {
            for (int i2 = tableColumnModel.getColumnCount() - 1; i2 >= 0; --i2) {
                this.adjustColumn(i2, f2);
            }
        } else {
            for (int i3 = 0; i3 < tableColumnModel.getColumnCount(); ++i3) {
                this.adjustColumn(i3, f2);
            }
        }
    }

    public void adjustColumn(int n2) {
        this.adjustColumn(n2, 0.0f);
    }

    public void adjustColumn(int n2, float f2) {
        int n3 = this.table.getColumnModel().getColumnCount();
        if (n2 >= 0 && n2 < n3) {
            TableColumn tableColumn = this.table.getColumnModel().getColumn(n2);
            if (!tableColumn.getResizable()) {
                return;
            }
            int n4 = this.getColumnHeaderWidth(n2);
            int n5 = this.getColumnDataWidth(n2);
            n4 += (int)((float)n4 * f2);
            n5 += (int)((float)n5 * f2);
            int n6 = Math.max(n4, n5);
            this.updateTableColumn(n2, n6);
        }
    }

    private int getColumnHeaderWidth(int n2) {
        if (!this.isColumnHeaderIncluded) {
            return 0;
        }
        TableColumn tableColumn = this.table.getColumnModel().getColumn(n2);
        Object object = tableColumn.getHeaderValue();
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null && this.table.getTableHeader() != null) {
            tableCellRenderer = this.table.getTableHeader().getDefaultRenderer();
        }
        if (tableCellRenderer == null) {
            return 0;
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(this.table, object, false, false, -1, n2);
        return component.getPreferredSize().width;
    }

    private int getColumnDataWidth(int n2) {
        if (!this.isColumnDataIncluded) {
            return 0;
        }
        int n3 = 0;
        int n4 = this.defaultMaxWidth;
        for (int i2 = 0; i2 < this.table.getRowCount() && (n3 = Math.max(n3, this.getCellDataWidth(i2, n2))) < n4; ++i2) {
        }
        return n3;
    }

    private int getCellDataWidth(int n2, int n3) {
        TableCellRenderer tableCellRenderer = this.table.getCellRenderer(n2, n3);
        Component component = this.table.prepareRenderer(tableCellRenderer, n2, n3);
        int n4 = component.getPreferredSize().width + this.table.getIntercellSpacing().width;
        return n4;
    }

    private void updateTableColumn(int n2, int n3) {
        TableColumn tableColumn = this.table.getColumnModel().getColumn(n2);
        if (!tableColumn.getResizable()) {
            return;
        }
        n3 += this.spacing;
        if (this.isOnlyAdjustLarger) {
            n3 = Math.max(n3, tableColumn.getPreferredWidth());
        }
        this.columnSizes.put(tableColumn, new Integer(tableColumn.getWidth()));
        if (this.isLastColumnAdjusted || n2 < this.table.getColumnCount() - 1) {
            if (this.setPreferredWidth) {
                tableColumn.setPreferredWidth(n3);
                tableColumn.setMaxWidth(n3);
            } else {
                if (this.table.getTableHeader() != null) {
                    this.table.getTableHeader().setResizingColumn(tableColumn);
                }
                tableColumn.setWidth(n3);
            }
            if (this.setMinWidth) {
                tableColumn.setMinWidth(n3);
            }
        }
    }

    public void restoreColumns() {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i2 = 0; i2 < tableColumnModel.getColumnCount(); ++i2) {
            this.restoreColumn(i2);
        }
    }

    private void restoreColumn(int n2) {
        TableColumn tableColumn = this.table.getColumnModel().getColumn(n2);
        Integer n3 = this.columnSizes.get(tableColumn);
        if (n3 != null) {
            this.table.getTableHeader().setResizingColumn(tableColumn);
            tableColumn.setWidth(n3);
        }
    }

    public void setMaxWidth(int n2) {
        this.defaultMaxWidth = n2;
    }

    public void setApplyMinWidth(boolean bl2) {
        this.setMinWidth = bl2;
    }

    public void setApplyMaxAndPreferredWidth(boolean bl2) {
        this.setPreferredWidth = bl2;
    }

    public void setColumnHeaderIncluded(boolean bl2) {
        this.isColumnHeaderIncluded = bl2;
    }

    public void setColumnDataIncluded(boolean bl2) {
        this.isColumnDataIncluded = bl2;
    }

    public void setOnlyAdjustLarger(boolean bl2) {
        this.isOnlyAdjustLarger = bl2;
    }

    public void setLastColumnAdjusted(boolean bl2) {
        this.isLastColumnAdjusted = bl2;
    }

    public void setDynamicAdjustment(boolean bl2) {
        if (this.isDynamicAdjustment != bl2) {
            if (bl2) {
                this.table.addPropertyChangeListener(this);
                this.table.getModel().addTableModelListener(this);
            } else {
                this.table.removePropertyChangeListener(this);
                this.table.getModel().removeTableModelListener(this);
            }
        }
        this.isDynamicAdjustment = bl2;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("model".equals(propertyChangeEvent.getPropertyName())) {
            TableModel tableModel = (TableModel)propertyChangeEvent.getOldValue();
            tableModel.removeTableModelListener(this);
            tableModel = (TableModel)propertyChangeEvent.getNewValue();
            tableModel.addTableModelListener(this);
            this.adjustColumns();
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (!this.isColumnDataIncluded) {
            return;
        }
        if (tableModelEvent.getType() == 0) {
            int n2 = this.table.convertColumnIndexToView(tableModelEvent.getColumn());
            if (n2 >= 0) {
                if (this.isOnlyAdjustLarger) {
                    int n3 = tableModelEvent.getFirstRow();
                    TableColumn tableColumn = this.table.getColumnModel().getColumn(n2);
                    if (tableColumn.getResizable()) {
                        int n4 = this.getCellDataWidth(n3, n2);
                        this.updateTableColumn(n2, n4);
                    }
                } else {
                    this.adjustColumn(n2);
                }
            }
        } else {
            this.adjustColumns();
        }
    }

    private void installActions() {
        this.installColumnAction(true, true, "adjustColumn", "control ADD");
        this.installColumnAction(false, true, "adjustColumns", "control shift ADD");
        this.installColumnAction(true, false, "restoreColumn", "control SUBTRACT");
        this.installColumnAction(false, false, "restoreColumns", "control shift SUBTRACT");
        this.installToggleAction(true, false, "toggleDynamic", "control MULTIPLY");
        this.installToggleAction(false, true, "toggleLarger", "control DIVIDE");
    }

    private void installColumnAction(boolean bl2, boolean bl3, String string, String string2) {
        ColumnAction columnAction = new ColumnAction(bl2, bl3);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(string2);
        this.table.getInputMap().put(keyStroke, string);
        this.table.getActionMap().put(string, columnAction);
    }

    private void installToggleAction(boolean bl2, boolean bl3, String string, String string2) {
        ToggleAction toggleAction = new ToggleAction(bl2, bl3);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(string2);
        this.table.getInputMap().put(keyStroke, string);
        this.table.getActionMap().put(string, toggleAction);
    }

    class ToggleAction
    extends AbstractAction {
        private static final long serialVersionUID = -1666798087019872114L;
        private boolean isToggleDynamic;
        private boolean isToggleLarger;

        public ToggleAction(boolean bl2, boolean bl3) {
            this.isToggleDynamic = bl2;
            this.isToggleLarger = bl3;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isToggleDynamic) {
                TableColumnAdjuster.this.setDynamicAdjustment(!TableColumnAdjuster.this.isDynamicAdjustment);
                return;
            }
            if (this.isToggleLarger) {
                TableColumnAdjuster.this.setOnlyAdjustLarger(!TableColumnAdjuster.this.isOnlyAdjustLarger);
                return;
            }
        }
    }

    class ColumnAction
    extends AbstractAction {
        private static final long serialVersionUID = 3571091556739479979L;
        private boolean isSelectedColumn;
        private boolean isAdjust;

        public ColumnAction(boolean bl2, boolean bl3) {
            this.isSelectedColumn = bl2;
            this.isAdjust = bl3;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isSelectedColumn) {
                int[] nArray = TableColumnAdjuster.this.table.getSelectedColumns();
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    if (this.isAdjust) {
                        TableColumnAdjuster.this.adjustColumn(nArray[i2]);
                        continue;
                    }
                    TableColumnAdjuster.this.restoreColumn(nArray[i2]);
                }
            } else if (this.isAdjust) {
                TableColumnAdjuster.this.adjustColumns();
            } else {
                TableColumnAdjuster.this.restoreColumns();
            }
        }
    }
}

